/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.exporter.http;

import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class BackedFileOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final File parentDirectory;
    private final int fileThreshold;
    private final boolean resetOnFinalize;
    private final ByteSource source;
    private OutputStream out;
    private MemoryOutput memory;
    private File file;

    public BackedFileOutputStream(int fileThreshold) {
        this(fileThreshold, false, null);
    }

    public BackedFileOutputStream(int fileThreshold, boolean resetOnFinalize, File parentDirectory) {
        this.parentDirectory = parentDirectory;
        this.fileThreshold = fileThreshold;
        this.resetOnFinalize = resetOnFinalize;
        this.memory = new MemoryOutput();
        this.out = this.memory;
        this.source = resetOnFinalize ? new ByteSource(){

            public InputStream openStream() throws IOException {
                return BackedFileOutputStream.this.openInputStream();
            }

            protected void finalize() {
                try {
                    BackedFileOutputStream.this.reset();
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
        } : new ByteSource(){

            public InputStream openStream() throws IOException {
                return BackedFileOutputStream.this.openInputStream();
            }
        };
    }

    public synchronized File getFile() {
        return this.file;
    }

    public ByteSource asByteSource() {
        return this.source;
    }

    private synchronized InputStream openInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return new ByteArrayInputStream(this.memory.getBuffer(), 0, this.memory.getCount());
    }

    public synchronized void reset() throws IOException {
        try {
            this.close();
        }
        finally {
            if (this.memory == null) {
                this.memory = new MemoryOutput();
            } else {
                this.memory.reset();
            }
            this.out = this.memory;
            if (this.file != null) {
                File deleteMe = this.file;
                this.file = null;
                if (!deleteMe.delete()) {
                    throw new IOException("Could not delete: " + deleteMe);
                }
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.update(1);
        this.out.write(b);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.update(len);
        this.out.write(b, off, len);
    }

    @Override
    public synchronized void close() throws IOException {
        this.out.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    private void update(int len) throws IOException {
        if (this.memory != null && this.memory.getCount() + len > this.fileThreshold) {
            File temp = Files.createTempFile(this.parentDirectory.toPath(), "FileBackedOutputStream", null, new FileAttribute[0]).toFile();
            if (this.resetOnFinalize) {
                temp.deleteOnExit();
            }
            try {
                FileOutputStream transfer = new FileOutputStream(temp);
                transfer.write(this.memory.getBuffer(), 0, this.memory.getCount());
                transfer.flush();
                this.out = transfer;
            }
            catch (IOException e) {
                temp.delete();
                throw e;
            }
            this.file = temp;
            this.memory = null;
        }
    }

    public long size() {
        if (this.file != null) {
            return this.file.length();
        }
        return this.memory.getCount();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        block6: {
            if (this.file != null) {
                try (FileInputStream fileInputStream = null;){
                    fileInputStream = new FileInputStream(this.file);
                    if (this.transferTo(fileInputStream, out) != this.file.length()) {
                        throw new IOException("Bug in BackedFileOutputStream");
                    }
                    break block6;
                }
            }
            out.write(this.memory.getBuffer(), 0, this.memory.getCount());
        }
    }

    private long transferTo(FileInputStream fileInputStream, OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = fileInputStream.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    private static class MemoryOutput
    extends ByteArrayOutputStream {
        private MemoryOutput() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCount() {
            return this.count;
        }
    }
}

