/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NameBasedDefinitionProvider;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class PureFunctionIdentifier
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final NameBasedDefinitionProvider definitionProvider;
    private final Map<String, FunctionInformation> functionInfoByName = new HashMap<String, FunctionInformation>();
    private final Multimap<Node, FunctionInformation> functionSideEffectMap;
    private final List<Node> allFunctionCalls;
    private final LinkedDirectedGraph<FunctionInformation, CallSitePropagationInfo> sideEffectGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private Node externs;
    private Node root;
    private static final Predicate<Node> RHS_IS_ALWAYS_LOCAL = lhs -> true;
    private static final Predicate<Node> RHS_IS_NEVER_LOCAL = lhs -> false;
    private static final Predicate<Node> FIND_RHS_AND_CHECK_FOR_LOCAL_VALUE = lhs -> {
        Node rhs = NodeUtil.getRValueOfLValue(lhs);
        return rhs == null || NodeUtil.evaluatesToLocalValue(rhs);
    };

    public PureFunctionIdentifier(AbstractCompiler compiler, NameBasedDefinitionProvider definitionProvider) {
        this.compiler = Preconditions.checkNotNull(compiler);
        this.definitionProvider = definitionProvider;
        this.functionSideEffectMap = ArrayListMultimap.create();
        this.allFunctionCalls = new ArrayList<Node>();
        this.externs = null;
        this.root = null;
    }

    @Override
    public void process(Node externsAst, Node srcAst) {
        Preconditions.checkState(this.externs == null && this.root == null, "It is illegal to call PureFunctionIdentifier.process  twice the same instance.  Please  use a new PureFunctionIdentifier instance each time.");
        this.externs = externsAst;
        this.root = srcAst;
        this.buildGraph();
        NodeTraversal.traverse(this.compiler, this.externs, new FunctionAnalyzer(true));
        NodeTraversal.traverse(this.compiler, this.root, new FunctionAnalyzer(false));
        this.propagateSideEffects();
        this.markPureFunctionCalls();
    }

    @VisibleForTesting
    String getDebugReport() {
        Preconditions.checkNotNull(this.externs);
        Preconditions.checkNotNull(this.root);
        StringBuilder sb = new StringBuilder();
        for (Node call : this.allFunctionCalls) {
            sb.append("  ");
            Iterable<Node> expanded = PureFunctionIdentifier.unwrapCallableExpression(call.getFirstChild());
            if (expanded != null) {
                for (Node comp : expanded) {
                    String name = NameBasedDefinitionProvider.getSimplifiedName(comp);
                    sb.append(name).append("|");
                }
            } else {
                sb.append("<cant expand>");
            }
            sb.append(" ").append(new Node.SideEffectFlags(call.getSideEffectFlags())).append(" from: ").append(call.getSourceFileName()).append("\n");
        }
        return sb.toString();
    }

    @Nullable
    private static Iterable<Node> unwrapCallableExpression(Node exp) {
        switch (exp.getToken()) {
            case GETPROP: {
                String propName = exp.getLastChild().getString();
                if (propName.equals("apply") || propName.equals("call")) {
                    return PureFunctionIdentifier.unwrapCallableExpression(exp.getFirstChild());
                }
                return ImmutableList.of(exp);
            }
            case FUNCTION: 
            case NAME: {
                return ImmutableList.of(exp);
            }
            case OR: 
            case HOOK: {
                Node firstVal = exp.isHook() ? exp.getSecondChild() : exp.getFirstChild();
                Iterable<Node> firstCallable = PureFunctionIdentifier.unwrapCallableExpression(firstVal);
                Iterable<Node> secondCallable = PureFunctionIdentifier.unwrapCallableExpression(firstVal.getNext());
                if (firstCallable == null || secondCallable == null) {
                    return null;
                }
                return Iterables.concat(firstCallable, secondCallable);
            }
        }
        return null;
    }

    private static boolean isSupportedFunctionDefinition(@Nullable Node definitionRValue) {
        if (definitionRValue == null) {
            return false;
        }
        switch (definitionRValue.getToken()) {
            case FUNCTION: {
                return true;
            }
            case HOOK: {
                return PureFunctionIdentifier.isSupportedFunctionDefinition(definitionRValue.getSecondChild()) && PureFunctionIdentifier.isSupportedFunctionDefinition(definitionRValue.getLastChild());
            }
        }
        return false;
    }

    private Iterable<Node> getGoogCacheCallableExpression(CodingConvention.Cache cacheCall) {
        Preconditions.checkNotNull(cacheCall);
        if (cacheCall.keyFn == null) {
            return PureFunctionIdentifier.unwrapCallableExpression(cacheCall.valueFn);
        }
        return Iterables.concat(PureFunctionIdentifier.unwrapCallableExpression(cacheCall.valueFn), PureFunctionIdentifier.unwrapCallableExpression(cacheCall.keyFn));
    }

    @Nullable
    private List<FunctionInformation> getSideEffectsForCall(Node call) {
        Preconditions.checkArgument(call.isCall() || call.isNew(), call);
        CodingConvention.Cache cacheCall = this.compiler.getCodingConvention().describeCachingCall(call);
        Iterable<Node> expanded = cacheCall != null ? this.getGoogCacheCallableExpression(cacheCall) : PureFunctionIdentifier.unwrapCallableExpression(call.getFirstChild());
        if (expanded == null) {
            return null;
        }
        ArrayList<FunctionInformation> results = new ArrayList<FunctionInformation>();
        for (Node expression : expanded) {
            if (NodeUtil.isFunctionExpression(expression)) {
                results.addAll(this.functionSideEffectMap.get(expression));
                continue;
            }
            String name = NameBasedDefinitionProvider.getSimplifiedName(expression);
            FunctionInformation info = null;
            if (name != null) {
                info = this.functionInfoByName.get(name);
            }
            if (info != null) {
                results.add(info);
                continue;
            }
            return null;
        }
        return results;
    }

    private void buildGraph() {
        FunctionInformation unknownDefinitionFunction = new FunctionInformation();
        unknownDefinitionFunction.setTaintsGlobalState();
        unknownDefinitionFunction.setFunctionThrows();
        unknownDefinitionFunction.setTaintsReturn();
        unknownDefinitionFunction.graphNode = this.sideEffectGraph.createNode((Object)unknownDefinitionFunction);
        for (DefinitionSite site : this.definitionProvider.getDefinitionSites()) {
            DefinitionsRemover.Definition definition = site.definition;
            if (definition.getLValue() == null) continue;
            Node getOrName = definition.getLValue();
            Preconditions.checkArgument(getOrName.isGetProp() || getOrName.isName(), getOrName);
            String name = NameBasedDefinitionProvider.getSimplifiedName(getOrName);
            Preconditions.checkNotNull(name);
            if (PureFunctionIdentifier.isSupportedFunctionDefinition(definition.getRValue())) {
                this.addSupportedDefinition(site, name);
                continue;
            }
            FunctionInformation info = this.functionInfoByName.get(name);
            if (info != null) {
                info.setTaintsGlobalState();
                info.setFunctionThrows();
                info.setTaintsReturn();
                continue;
            }
            this.functionInfoByName.put(name, unknownDefinitionFunction);
        }
    }

    private void addSupportedDefinition(DefinitionSite definitionSite, String name) {
        for (Node function : PureFunctionIdentifier.unwrapCallableExpression(definitionSite.definition.getRValue())) {
            FunctionInformation functionInfo = this.functionInfoByName.get(name);
            if (functionInfo == null) {
                functionInfo = new FunctionInformation();
                functionInfo.graphNode = this.sideEffectGraph.createNode((Object)functionInfo);
                this.functionInfoByName.put(name, functionInfo);
            }
            this.functionSideEffectMap.put(function, functionInfo);
            if (!definitionSite.inExterns) continue;
            functionInfo.updateSideEffectsFromExtern(function, this.compiler);
        }
    }

    private void propagateSideEffects() {
        FixedPointGraphTraversal.newTraversal(new FixedPointGraphTraversal.EdgeCallback<FunctionInformation, CallSitePropagationInfo>(){

            @Override
            public boolean traverseEdge(FunctionInformation source, CallSitePropagationInfo edge, FunctionInformation destination) {
                return edge.propagate(source, destination);
            }
        }).computeFixedPoint(this.sideEffectGraph);
    }

    private void markPureFunctionCalls() {
        for (Node callNode : this.allFunctionCalls) {
            List<FunctionInformation> possibleSideEffects = this.getSideEffectsForCall(callNode);
            Node.SideEffectFlags flags = new Node.SideEffectFlags();
            if (possibleSideEffects == null) {
                flags.setMutatesGlobalState();
                flags.setThrows();
                flags.setReturnsTainted();
            } else {
                flags.clearAllFlags();
                for (FunctionInformation functionInfo : possibleSideEffects) {
                    Preconditions.checkNotNull(functionInfo);
                    if (functionInfo.mutatesGlobalState()) {
                        flags.setMutatesGlobalState();
                    }
                    if (functionInfo.mutatesArguments()) {
                        flags.setMutatesArguments();
                    }
                    if (functionInfo.functionThrows()) {
                        flags.setThrows();
                    }
                    if (callNode.isCall() && functionInfo.taintsThis()) {
                        if (PureFunctionIdentifier.isCallOrApply(callNode)) {
                            flags.setMutatesArguments();
                        } else {
                            flags.setMutatesThis();
                        }
                    }
                    if (!functionInfo.taintsReturn()) continue;
                    flags.setReturnsTainted();
                }
            }
            if (callNode.isCall()) {
                if (!NodeUtil.functionCallHasSideEffects(callNode, this.compiler)) {
                    flags.clearSideEffectFlags();
                }
            } else if (callNode.isNew() && !NodeUtil.constructorCallHasSideEffects(callNode)) {
                flags.clearSideEffectFlags();
            }
            int newSideEffectFlags = flags.valueOf();
            if (callNode.getSideEffectFlags() == newSideEffectFlags) continue;
            callNode.setSideEffectFlags(newSideEffectFlags);
            this.compiler.reportChangeToEnclosingScope(callNode);
        }
    }

    private static boolean isCallOrApply(Node callSite) {
        return NodeUtil.isFunctionObjectCall(callSite) || NodeUtil.isFunctionObjectApply(callSite);
    }

    private static boolean isLocalValueType(JSType typei, AbstractCompiler compiler) {
        Preconditions.checkNotNull(typei);
        JSType nativeObj = compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_TYPE);
        JSType subtype = typei.meetWith(nativeObj);
        return subtype.isEmptyType();
    }

    static class Driver
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final String reportPath;

        Driver(AbstractCompiler compiler, String reportPath) {
            this.compiler = compiler;
            this.reportPath = reportPath;
        }

        @Override
        public void process(Node externs, Node root) {
            NameBasedDefinitionProvider defFinder = new NameBasedDefinitionProvider(this.compiler, true);
            defFinder.process(externs, root);
            PureFunctionIdentifier pureFunctionIdentifier = new PureFunctionIdentifier(this.compiler, defFinder);
            pureFunctionIdentifier.process(externs, root);
            if (this.reportPath != null) {
                try {
                    Files.asCharSink(new File(this.reportPath), StandardCharsets.UTF_8, new FileWriteMode[0]).write(pureFunctionIdentifier.getDebugReport());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class FunctionInformation {
        DiGraph.DiGraphNode<FunctionInformation, CallSitePropagationInfo> graphNode;
        private int bitmask = 0;
        private static final int FUNCTION_THROWS_MASK = 2;
        private static final int TAINTS_GLOBAL_STATE_MASK = 4;
        private static final int TAINTS_THIS_MASK = 8;
        private static final int TAINTS_ARGUMENTS_MASK = 16;
        private static final int TAINTS_RETURN_MASK = 32;

        private FunctionInformation() {
        }

        void setMask(int mask) {
            this.bitmask |= mask;
        }

        boolean getMask(int mask) {
            return (this.bitmask & mask) != 0;
        }

        boolean taintsThis() {
            return this.getMask(8);
        }

        boolean taintsReturn() {
            return this.getMask(32);
        }

        boolean functionThrows() {
            return this.getMask(2);
        }

        boolean isPure() {
            return !this.getMask(30);
        }

        void setTaintsGlobalState() {
            this.setMask(4);
        }

        void setTaintsThis() {
            this.setMask(8);
        }

        void setTaintsArguments() {
            this.setMask(16);
        }

        void setFunctionThrows() {
            this.setMask(2);
        }

        void setTaintsReturn() {
            this.setMask(32);
        }

        boolean mutatesGlobalState() {
            return this.getMask(4);
        }

        boolean mutatesArguments() {
            return this.getMask(20);
        }

        boolean mutatesThis() {
            return this.taintsThis();
        }

        public String toString() {
            ArrayList<String> status = new ArrayList<String>();
            if (this.taintsThis()) {
                status.add("this");
            }
            if (this.mutatesGlobalState()) {
                status.add("global");
            }
            if (this.mutatesArguments()) {
                status.add("args");
            }
            if (this.taintsReturn()) {
                status.add("return");
            }
            if (this.functionThrows()) {
                status.add("throw");
            }
            return "Side effects: " + status;
        }

        private void updateSideEffectsFromExtern(Node externFunction, AbstractCompiler compiler) {
            FunctionType functionType;
            Preconditions.checkArgument(externFunction.isFunction());
            Preconditions.checkArgument(externFunction.isFromExterns());
            JSDocInfo info = NodeUtil.getBestJSDocInfo(externFunction);
            JSType typei = externFunction.getJSType();
            FunctionType functionType2 = functionType = typei == null ? null : typei.toMaybeFunctionType();
            if (functionType == null) {
                this.setTaintsReturn();
            } else {
                JSType retType = functionType.getReturnType();
                if (!PureFunctionIdentifier.isLocalValueType(retType, compiler)) {
                    this.setTaintsReturn();
                }
            }
            if (info == null) {
                this.setTaintsGlobalState();
                this.setFunctionThrows();
            } else if (info.modifiesThis()) {
                this.setTaintsThis();
            } else if (info.hasSideEffectsArgumentsAnnotation()) {
                this.setTaintsArguments();
            } else if (!info.getThrownTypes().isEmpty()) {
                this.setFunctionThrows();
            } else if (!info.isNoSideEffects()) {
                this.setTaintsGlobalState();
            }
        }
    }

    @Immutable
    private static class CallSitePropagationInfo {
        private final boolean allArgsUnescapedLocal;
        private final boolean calleeThisEqualsCallerThis;
        private final Token callType;

        private CallSitePropagationInfo(boolean allArgsUnescapedLocal, boolean calleeThisEqualsCallerThis, Token callType) {
            Preconditions.checkArgument(callType == Token.CALL || callType == Token.NEW);
            this.allArgsUnescapedLocal = allArgsUnescapedLocal;
            this.calleeThisEqualsCallerThis = calleeThisEqualsCallerThis;
            this.callType = callType;
        }

        boolean propagate(FunctionInformation callee, FunctionInformation caller) {
            CallSitePropagationInfo propagationType = this;
            boolean changed = false;
            if (callee.mutatesGlobalState() && !caller.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            if (callee.functionThrows() && !caller.functionThrows()) {
                caller.setFunctionThrows();
                changed = true;
            }
            if (callee.mutatesArguments() && !propagationType.allArgsUnescapedLocal && !caller.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            if (callee.mutatesThis() && propagationType.calleeThisEqualsCallerThis) {
                if (!caller.mutatesThis()) {
                    caller.setTaintsThis();
                    changed = true;
                }
            } else if (callee.mutatesThis() && propagationType.callType != Token.NEW && !caller.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            return changed;
        }

        static CallSitePropagationInfo computePropagationType(Node callSite) {
            Preconditions.checkArgument(callSite.isCall() || callSite.isNew());
            boolean thisIsOuterThis = false;
            if (callSite.isCall()) {
                Node objectNode;
                boolean isCallOrApply = PureFunctionIdentifier.isCallOrApply(callSite);
                Node node = objectNode = isCallOrApply ? callSite.getSecondChild() : callSite.getFirstFirstChild();
                if ((objectNode == null || !objectNode.isName() || isCallOrApply) && objectNode != null && objectNode.isThis()) {
                    thisIsOuterThis = true;
                }
            }
            boolean argsUnescapedLocal = NodeUtil.allArgsUnescapedLocal(callSite);
            return new CallSitePropagationInfo(argsUnescapedLocal, thisIsOuterThis, callSite.getToken());
        }
    }

    private class FunctionAnalyzer
    implements NodeTraversal.ScopedCallback {
        private final SetMultimap<Node, Var> blacklistedVarsByFunction = HashMultimap.create();
        private final SetMultimap<Node, Var> taintedVarsByFunction = HashMultimap.create();
        private final boolean inExterns;

        FunctionAnalyzer(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            if (node.isFunction() && !PureFunctionIdentifier.this.functionSideEffectMap.containsKey(node)) {
                FunctionInformation functionInfo = new FunctionInformation();
                PureFunctionIdentifier.this.functionSideEffectMap.put(node, functionInfo);
                functionInfo.graphNode = PureFunctionIdentifier.this.sideEffectGraph.createNode(functionInfo);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            Scope containerScope;
            if (this.inExterns) {
                return;
            }
            if (!NodeUtil.nodeTypeMayHaveSideEffects(node, PureFunctionIdentifier.this.compiler) && !node.isReturn()) {
                return;
            }
            if (NodeUtil.isCallOrNew(node)) {
                PureFunctionIdentifier.this.allFunctionCalls.add(node);
            }
            if (!(containerScope = (Scope)traversal.getScope().getClosestContainerScope()).isFunctionScope()) {
                return;
            }
            Node enclosingFunction = containerScope.getRootNode();
            for (FunctionInformation sideEffectInfo : PureFunctionIdentifier.this.functionSideEffectMap.get(enclosingFunction)) {
                Preconditions.checkNotNull(sideEffectInfo);
                this.updateSideEffectsForNode(sideEffectInfo, traversal, node, enclosingFunction);
            }
        }

        public void updateSideEffectsForNode(FunctionInformation sideEffectInfo, NodeTraversal traversal, Node node, Node enclosingFunction) {
            if (node.isAssign()) {
                this.visitLhsNodes(sideEffectInfo, traversal.getScope(), enclosingFunction, NodeUtil.findLhsNodesInNode(node), FIND_RHS_AND_CHECK_FOR_LOCAL_VALUE);
            } else if (NodeUtil.isCompoundAssignmentOp(node)) {
                this.visitLhsNodes(sideEffectInfo, traversal.getScope(), enclosingFunction, ImmutableList.of(node.getFirstChild()), RHS_IS_ALWAYS_LOCAL);
            } else if (node.isInc() || node.isDelProp() || node.isDec()) {
                this.visitLhsNodes(sideEffectInfo, traversal.getScope(), enclosingFunction, ImmutableList.of(node.getOnlyChild()), RHS_IS_ALWAYS_LOCAL);
            } else if (node.isForOf()) {
                this.visitLhsNodes(sideEffectInfo, traversal.getScope(), enclosingFunction, NodeUtil.findLhsNodesInNode(node), RHS_IS_NEVER_LOCAL);
            } else if (node.isForIn()) {
                this.visitLhsNodes(sideEffectInfo, traversal.getScope(), enclosingFunction, NodeUtil.findLhsNodesInNode(node), RHS_IS_ALWAYS_LOCAL);
            } else if (NodeUtil.isCallOrNew(node)) {
                this.visitCall(sideEffectInfo, node);
            } else if (node.isName()) {
                Preconditions.checkArgument(NodeUtil.isNameDeclaration(node.getParent()), node.getParent());
                Node value = node.getFirstChild();
                if (value != null && !NodeUtil.evaluatesToLocalValue(value)) {
                    Scope scope = traversal.getScope();
                    Var var = (Var)scope.getVar(node.getString());
                    this.blacklistedVarsByFunction.put(enclosingFunction, var);
                }
            } else if (node.isThrow()) {
                sideEffectInfo.setFunctionThrows();
            } else if (node.isReturn()) {
                if (node.hasChildren() && !NodeUtil.evaluatesToLocalValue(node.getFirstChild())) {
                    sideEffectInfo.setTaintsReturn();
                }
            } else if (node.isYield()) {
                sideEffectInfo.setFunctionThrows();
            } else if (node.isAwait()) {
                sideEffectInfo.setFunctionThrows();
            } else {
                throw new IllegalArgumentException("Unhandled side effect node type " + node);
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
            Scope closestContainerScope = (Scope)t.getScope().getClosestContainerScope();
            if (!closestContainerScope.isFunctionScope()) {
                return;
            }
            Node function = closestContainerScope.getRootNode();
            block0: for (FunctionInformation sideEffectInfo : PureFunctionIdentifier.this.functionSideEffectMap.get(function)) {
                Preconditions.checkNotNull(sideEffectInfo, "%s has no side effect info.", (Object)function);
                if (sideEffectInfo.mutatesGlobalState()) continue;
                for (Var v : t.getScope().getVarIterable()) {
                    if (v.isParam() && !this.blacklistedVarsByFunction.containsEntry(function, v) && this.taintedVarsByFunction.containsEntry(function, v)) {
                        sideEffectInfo.setTaintsArguments();
                        continue;
                    }
                    boolean localVar = false;
                    if (!v.isParam() && !v.isCatch()) {
                        localVar = true;
                    }
                    if (localVar && !this.blacklistedVarsByFunction.containsEntry(function, v) || !this.taintedVarsByFunction.containsEntry(function, v)) continue;
                    sideEffectInfo.setTaintsGlobalState();
                    continue block0;
                }
            }
            if (t.getScopeRoot().isFunction()) {
                this.blacklistedVarsByFunction.removeAll(function);
                this.taintedVarsByFunction.removeAll(function);
            }
        }

        private boolean isVarDeclaredInSameContainerScope(@Nullable Var v, Scope scope) {
            return v != null && ((Scope)v.scope).hasSameContainerScope(scope);
        }

        private void visitLhsNodes(FunctionInformation sideEffectInfo, Scope scope, Node enclosingFunction, Iterable<Node> lhsNodes, Predicate<Node> hasLocalRhs) {
            for (Node lhs : lhsNodes) {
                if (NodeUtil.isGet(lhs)) {
                    if (lhs.getFirstChild().isThis()) {
                        sideEffectInfo.setTaintsThis();
                        continue;
                    }
                    Node objectNode = lhs.getFirstChild();
                    if (objectNode.isName()) {
                        Var var = (Var)scope.getVar(objectNode.getString());
                        if (this.isVarDeclaredInSameContainerScope(var, scope)) {
                            this.taintedVarsByFunction.put(enclosingFunction, var);
                            continue;
                        }
                        sideEffectInfo.setTaintsGlobalState();
                        continue;
                    }
                    sideEffectInfo.setTaintsGlobalState();
                    continue;
                }
                Preconditions.checkState(lhs.isName(), lhs);
                Var var = (Var)scope.getVar(lhs.getString());
                if (this.isVarDeclaredInSameContainerScope(var, scope)) {
                    if (hasLocalRhs.test(lhs)) continue;
                    this.blacklistedVarsByFunction.put(enclosingFunction, var);
                    continue;
                }
                sideEffectInfo.setTaintsGlobalState();
            }
        }

        private void visitCall(FunctionInformation sideEffectInfo, Node node) {
            if (node.isCall() && !NodeUtil.functionCallHasSideEffects(node, PureFunctionIdentifier.this.compiler)) {
                return;
            }
            if (node.isNew() && !NodeUtil.constructorCallHasSideEffects(node)) {
                return;
            }
            List possibleSideEffects = PureFunctionIdentifier.this.getSideEffectsForCall(node);
            if (possibleSideEffects == null) {
                sideEffectInfo.setTaintsGlobalState();
                sideEffectInfo.setFunctionThrows();
                return;
            }
            for (FunctionInformation sideEffectNode : possibleSideEffects) {
                CallSitePropagationInfo edge = CallSitePropagationInfo.computePropagationType(node);
                PureFunctionIdentifier.this.sideEffectGraph.connect(sideEffectNode.graphNode, edge, sideEffectInfo.graphNode);
            }
        }
    }
}

