/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom.fills;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.fxg.logging.FXGLog;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.GradientEntryNode;
import org.apache.royale.compiler.internal.fxg.dom.IScalableGradientNode;
import org.apache.royale.compiler.internal.fxg.dom.fills.AbstractFillNode;
import org.apache.royale.compiler.internal.fxg.dom.transforms.MatrixNode;
import org.apache.royale.compiler.internal.fxg.dom.types.InterpolationMethod;
import org.apache.royale.compiler.internal.fxg.dom.types.SpreadMethod;
import org.apache.royale.compiler.problems.FXGInvalidChildMatrixNodeProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class LinearGradientFillNode
extends AbstractFillNode
implements IScalableGradientNode {
    public double x = Double.NaN;
    public double y = Double.NaN;
    public double scaleX = Double.NaN;
    private static final double scaleY = Double.NaN;
    public double rotation = 0.0;
    public SpreadMethod spreadMethod = SpreadMethod.PAD;
    public InterpolationMethod interpolationMethod = InterpolationMethod.RGB;
    private boolean translateSet;
    private boolean scaleSet;
    private boolean rotationSet;
    public MatrixNode matrix;
    public List<GradientEntryNode> entries;

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        children.add(this.matrix);
        if (this.entries != null) {
            children.addAll(this.entries);
        }
        return children;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getScaleX() {
        return this.scaleX;
    }

    @Override
    public double getScaleY() {
        return Double.NaN;
    }

    @Override
    public double getRotation() {
        return this.rotation;
    }

    @Override
    public MatrixNode getMatrixNode() {
        return this.matrix;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof MatrixNode) {
            if (this.translateSet || this.scaleSet || this.rotationSet) {
                problems.add(new FXGInvalidChildMatrixNodeProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn()));
                return;
            }
            this.matrix = (MatrixNode)child;
        } else if (child instanceof GradientEntryNode) {
            if (this.entries == null) {
                this.entries = new ArrayList<GradientEntryNode>(4);
            } else if (this.entries.size() >= 15) {
                FXGLog.getLogger().log(30000, "InvalidLinearGradientNumElements", null, this.getDocumentPath(), this.startLine, this.startColumn);
                return;
            }
            this.entries.add((GradientEntryNode)child);
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public String getNodeName() {
        return "LinearGradient";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("x".equals(name)) {
            this.x = DOMParserHelper.parseDouble(this, value, name, this.x, problems);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = DOMParserHelper.parseDouble(this, value, name, this.y, problems);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = DOMParserHelper.parseDouble(this, value, name, this.rotation, problems);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = DOMParserHelper.parseDouble(this, value, name, this.scaleX, problems);
            this.scaleSet = true;
        } else if ("spreadMethod".equals(name)) {
            this.spreadMethod = DOMParserHelper.parseSpreadMethod(this, value, this.spreadMethod, problems);
        } else if ("interpolationMethod".equals(name)) {
            this.interpolationMethod = DOMParserHelper.parseInterpolationMethod(this, value, this.interpolationMethod, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }
}

