/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.util.List;

public final class ByPathWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final List<String> paths;
    private final boolean include;
    private final int priority;
    private final CheckLevel level;

    private ByPathWarningsGuard(List<String> paths, boolean include, CheckLevel level) {
        Preconditions.checkArgument(paths != null);
        Preconditions.checkArgument(level == CheckLevel.OFF || level == CheckLevel.ERROR);
        this.paths = paths;
        this.include = include;
        this.level = level;
        this.priority = level == CheckLevel.ERROR ? WarningsGuard.Priority.STRICT.value : WarningsGuard.Priority.FILTER_BY_PATH.value;
    }

    public static ByPathWarningsGuard forPath(List<String> paths, CheckLevel level) {
        return new ByPathWarningsGuard(paths, true, level);
    }

    public static ByPathWarningsGuard exceptPath(List<String> paths, CheckLevel level) {
        return new ByPathWarningsGuard(paths, false, level);
    }

    @Override
    public CheckLevel level(JSError error) {
        String errorPath = error.sourceName;
        CheckLevel defaultLevel = error.getDefaultLevel();
        if (defaultLevel != CheckLevel.ERROR && errorPath != null) {
            boolean inPath = false;
            for (String path : this.paths) {
                inPath |= errorPath.contains(path);
            }
            if (inPath == this.include) {
                return this.level;
            }
        }
        return null;
    }

    @Override
    protected int getPriority() {
        return this.priority;
    }
}

