/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.AbstractLogger;

public class ConsoleLogger
extends AbstractLogger
implements Logger {
    private static final String lineSeparator = System.getProperty("line.separator");
    private boolean isInfoEnabled;
    private boolean isDebugEnabled;
    private boolean isWarningEnabled;
    private boolean isErrorEnabled;
    private int errorCount;
    private int warningCount;

    public ConsoleLogger() {
        this(true, true, true, true);
    }

    public ConsoleLogger(boolean isInfoEnabled, boolean isDebugEnabled, boolean isWarningEnabled, boolean isErrorEnabled) {
        this.isInfoEnabled = isInfoEnabled;
        this.isDebugEnabled = isDebugEnabled;
        this.isWarningEnabled = isWarningEnabled;
        this.isErrorEnabled = isErrorEnabled;
        this.init();
    }

    @Override
    public int errorCount() {
        return this.errorCount;
    }

    @Override
    public int warningCount() {
        return this.warningCount;
    }

    @Override
    public void logInfo(String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(info, false);
    }

    @Override
    public void logDebug(String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(debug, false);
    }

    @Override
    public void logWarning(String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(this.WARNING + ": " + warning);
    }

    @Override
    public void logError(String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(this.ERROR + ": " + error);
    }

    @Override
    public void logInfo(String path, String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(path + lineSeparator + lineSeparator + info);
    }

    @Override
    public void logDebug(String path, String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(path + lineSeparator + lineSeparator + debug);
    }

    @Override
    public void logWarning(String path, String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(path + lineSeparator + lineSeparator + this.WARNING + ": " + warning);
    }

    @Override
    public void logWarning(String path, String warning, int errorCode) {
        this.logWarning(path, warning);
    }

    @Override
    public void logError(String path, String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(path + lineSeparator + lineSeparator + this.ERROR + ": " + error);
    }

    @Override
    public void logError(String path, String error, int errorCode) {
        this.logError(path, error);
    }

    @Override
    public void logInfo(String path, int line, String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "): " + info);
    }

    @Override
    public void logDebug(String path, int line, String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "): " + debug);
    }

    @Override
    public void logWarning(String path, int line, String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(path + "(" + line + "): " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + this.getLineText(path, line));
    }

    @Override
    public void logWarning(String path, int line, String warning, int errorCode) {
        this.logWarning(path, line, warning);
    }

    @Override
    public void logError(String path, int line, String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(path + "(" + line + "):  " + this.ERROR + ": " + error + lineSeparator + lineSeparator + this.getLineText(path, line));
    }

    @Override
    public void logError(String path, int line, String error, int errorCode) {
        this.logError(path, line, error);
    }

    @Override
    public void logInfo(String path, int line, int col, String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "): " + this.COL + ": " + col + " " + info);
    }

    @Override
    public void logDebug(String path, int line, int col, String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "): " + this.COL + ": " + col + " " + debug);
    }

    @Override
    public void logWarning(String path, int line, int col, String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        String lineText = this.getLineText(path, line);
        this.printWarning(path + "(" + line + "): " + this.COL + ": " + col + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + lineText + lineSeparator + this.getLinePointer(col, lineText));
    }

    @Override
    public void log(ILocalizableMessage m) {
        this.log(m, null);
    }

    @Override
    public void log(ILocalizableMessage m, String source) {
        if (m.getLevel() == "error" ? !this.isErrorEnabled : (m.getLevel() == "warning" ? !this.isWarningEnabled : !this.isInfoEnabled)) {
            return;
        }
        String prefix = this.formatPrefix(m);
        boolean found = true;
        String text = null;
        if (text == null) {
            text = m.getClass().getName();
            found = false;
        }
        Object exText = this.formatExceptionDetail(m);
        if (m.getPath() != null && m.getLine() != -1) {
            exText = (String)exText + lineSeparator + lineSeparator + (source == null ? this.getLineText(m.getPath(), m.getLine()) : source);
        }
        if (m.getColumn() != -1) {
            exText = (String)exText + lineSeparator + this.getLinePointer(m.getColumn(), source);
        }
        if (m.getLevel() == "info") {
            this.printOut(prefix + text + (String)exText, false);
        } else if (m.getLevel() == "warning") {
            this.printWarning(prefix + text + (String)exText);
        } else {
            this.printError(prefix + text + (String)exText);
        }
        assert (found) : "Localized text missing for " + m.getClass().getName();
    }

    @Override
    public void logError(String path, int line, int col, String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        String lineText = this.getLineText(path, line);
        this.printError(path + "(" + line + "): " + this.COL + ": " + col + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + lineText + lineSeparator + this.getLinePointer(col, lineText));
    }

    @Override
    public void logWarning(String path, int line, int col, String warning, String source) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(path + "(" + line + "): " + this.COL + ": " + col + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + source + lineSeparator + this.getLinePointer(col, source));
    }

    @Override
    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        this.logWarning(path, line, col, warning, source);
    }

    @Override
    public void logError(String path, int line, int col, String error, String source) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(path + "(" + line + "): " + this.COL + ": " + col + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + source + lineSeparator + this.getLinePointer(col, source));
    }

    @Override
    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        this.logError(path, line, col, error, source);
    }

    @Override
    public void needsCompilation(String path, String reason) {
        this.printOut(this.RECOMPILE + ": " + path, false);
        this.printOut(this.REASON + ": " + reason, false);
    }

    @Override
    public void includedFileUpdated(String path) {
        this.printOut(this.INCLUDEUPDATED + ": " + path, false);
    }

    @Override
    public void includedFileAffected(String path) {
        this.printOut(this.INCLUDEAFFECTED + ": " + path, false);
    }

    private void printOut(String message) {
        this.printOut(message, true);
    }

    private void printOut(String message, boolean extraLineBreak) {
        System.out.println(message + (extraLineBreak ? lineSeparator : ""));
    }

    private void printWarning(String message) {
        ++this.warningCount;
        System.err.println(message + lineSeparator);
        if (message == null) {
            Thread.dumpStack();
        }
    }

    private void printError(String message) {
        ++this.errorCount;
        System.err.println(message + lineSeparator);
        if (message == null) {
            Thread.dumpStack();
        }
    }

    private String getLineText(String path, int line) {
        String text = FileUtil.readLine(path, line);
        return text == null ? "" : text;
    }

    private String getLinePointer(int col, String source) {
        if (col <= 0) {
            return "^";
        }
        StringBuilder b = new StringBuilder(col);
        for (int i = 0; i < col - 1; ++i) {
            if (source != null && i < source.length() && source.charAt(i) == '\t') {
                b.append('\t');
                continue;
            }
            b.append(' ');
        }
        b.append('^');
        return b.toString();
    }
}

