/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class ExtractPrototypeMemberDeclarations
implements CompilerPass {
    private static final String PROTOTYPE_ALIAS = "JSCompiler_prototypeAlias";
    private final AbstractCompiler compiler;
    private final Pattern pattern;

    ExtractPrototypeMemberDeclarations(AbstractCompiler compiler, Pattern pattern) {
        this.compiler = compiler;
        this.pattern = pattern;
    }

    @Override
    public void process(Node externs, Node root) {
        GatherExtractionInfo extractionInfo = new GatherExtractionInfo();
        NodeTraversal.traverse(this.compiler, root, extractionInfo);
        if (extractionInfo.shouldExtract()) {
            this.doExtraction(extractionInfo);
        }
    }

    private void doExtraction(GatherExtractionInfo info) {
        if (this.pattern == Pattern.USE_GLOBAL_TEMP) {
            Node injectionPoint = this.compiler.getNodeForCodeInsertion(null);
            Node var = NodeUtil.newVarNode(PROTOTYPE_ALIAS, null).useSourceInfoIfMissingFromForTree(injectionPoint);
            injectionPoint.addChildToFront(var);
            this.compiler.reportChangeToEnclosingScope(var);
        }
        for (ExtractionInstance instance : info.instances) {
            this.extractInstance(instance);
        }
    }

    private void extractInstance(ExtractionInstance instance) {
        PrototypeMemberDeclaration first = instance.declarations.get(0);
        String className = first.qualifiedClassName;
        if (this.pattern == Pattern.USE_GLOBAL_TEMP) {
            Node classNameNode = NodeUtil.newQName(this.compiler, className);
            classNameNode.putBooleanProp(Node.IS_CONSTANT_NAME, first.constant);
            Node stmt = IR.exprResult(IR.assign(IR.name(PROTOTYPE_ALIAS), IR.getprop(classNameNode, IR.string("prototype")))).useSourceInfoIfMissingFromForTree(first.node);
            instance.parent.addChildBefore(stmt, first.node);
            this.compiler.reportChangeToEnclosingScope(stmt);
        } else if (this.pattern == Pattern.USE_IIFE) {
            Node block = IR.block();
            Node func = IR.function(IR.name(""), IR.paramList(IR.name(PROTOTYPE_ALIAS)), block);
            Node call = IR.call(func, NodeUtil.newQName(this.compiler, className + ".prototype", instance.parent, className + ".prototype"));
            call.putIntProp(Node.FREE_CALL, 1);
            Node stmt = IR.exprResult(call);
            stmt.useSourceInfoIfMissingFromForTree(first.node);
            instance.parent.addChildBefore(stmt, first.node);
            this.compiler.reportChangeToEnclosingScope(stmt);
            for (PrototypeMemberDeclaration declar : instance.declarations) {
                this.compiler.reportChangeToEnclosingScope(declar.node);
                block.addChildToBack(declar.node.detach());
            }
        }
        for (PrototypeMemberDeclaration declar : instance.declarations) {
            this.replacePrototypeMemberDeclaration(declar);
        }
    }

    private void replacePrototypeMemberDeclaration(PrototypeMemberDeclaration declar) {
        Node assignment = declar.node.getFirstChild();
        Node lhs = assignment.getFirstChild();
        Node name = NodeUtil.newQName(this.compiler, "JSCompiler_prototypeAlias." + declar.memberName, declar.node, declar.memberName);
        Node accessNode = declar.lhs.getFirstFirstChild();
        String originalName = accessNode.getOriginalName();
        String className = originalName != null ? originalName : "?";
        name.getFirstChild().useSourceInfoFromForTree(lhs);
        name.putBooleanProp(Node.IS_CONSTANT_NAME, lhs.getBooleanProp(Node.IS_CONSTANT_NAME));
        name.getFirstChild().setOriginalName(className + ".prototype");
        assignment.replaceChild(lhs, name);
        this.compiler.reportChangeToEnclosingScope(name);
    }

    private static class PrototypeMemberDeclaration {
        final String memberName;
        final Node node;
        final String qualifiedClassName;
        final Node lhs;
        final boolean constant;

        private PrototypeMemberDeclaration(Node lhs, Node node) {
            Preconditions.checkState(NodeUtil.isExprAssign(node), node);
            this.lhs = lhs;
            this.memberName = NodeUtil.getPrototypePropertyName(lhs);
            this.node = node;
            Node classNode = PrototypeMemberDeclaration.getPrototypeClassName(lhs);
            this.qualifiedClassName = classNode.getQualifiedName();
            this.constant = classNode.getBooleanProp(Node.IS_CONSTANT_NAME);
        }

        private boolean isSameClass(PrototypeMemberDeclaration other) {
            return this.qualifiedClassName.equals(other.qualifiedClassName);
        }

        private static Node getPrototypeClassName(Node qName) {
            Node cur = qName;
            while (cur.isGetProp()) {
                if (cur.getLastChild().getString().equals("prototype")) {
                    return cur.getFirstChild();
                }
                cur = cur.getFirstChild();
            }
            return null;
        }

        private static boolean isPrototypePropertyDeclaration(Node n) {
            if (!NodeUtil.isExprAssign(n)) {
                return false;
            }
            Node lvalue = n.getFirstFirstChild();
            if (lvalue.isGetProp()) {
                Node cur = lvalue.getFirstChild();
                while (cur.isGetProp()) {
                    if (cur.getLastChild().getString().equals("prototype")) {
                        return cur.isQualifiedName();
                    }
                    cur = cur.getFirstChild();
                }
            }
            return false;
        }

        @Nullable
        private static PrototypeMemberDeclaration extractDeclaration(Node n) {
            if (!PrototypeMemberDeclaration.isPrototypePropertyDeclaration(n)) {
                return null;
            }
            Node lhs = n.getFirstFirstChild();
            return new PrototypeMemberDeclaration(lhs, n);
        }
    }

    private class ExtractionInstance {
        List<PrototypeMemberDeclaration> declarations = new ArrayList<PrototypeMemberDeclaration>();
        private int delta = 0;
        private final Node parent;

        private ExtractionInstance(PrototypeMemberDeclaration head, Node parent) {
            this.parent = parent;
            this.declarations.add(head);
            this.delta = ExtractPrototypeMemberDeclarations.this.pattern.perExtractionOverhead + ExtractPrototypeMemberDeclarations.this.pattern.perMemberOverhead;
            for (Node cur = head.node.getNext(); cur != null; cur = cur.getNext()) {
                if (cur.isFunction()) continue;
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null || !head.isSameClass(prototypeMember)) break;
                this.declarations.add(prototypeMember);
                this.delta += ExtractPrototypeMemberDeclarations.this.pattern.perMemberOverhead;
            }
        }

        boolean isFavorable() {
            return this.delta <= 0;
        }
    }

    private class GatherExtractionInfo
    extends NodeTraversal.AbstractShallowCallback {
        private final List<ExtractionInstance> instances = new ArrayList<ExtractionInstance>();
        private int totalDelta = Pattern.access$500(ExtractPrototypeMemberDeclarations.access$400(ExtractPrototypeMemberDeclarations.this));

        private GatherExtractionInfo() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isScript() && !n.isBlock()) {
                return;
            }
            for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null) continue;
                ExtractionInstance instance = new ExtractionInstance(prototypeMember, n);
                cur = instance.declarations.get((int)(instance.declarations.size() - 1)).node;
                if (!instance.isFavorable()) continue;
                this.instances.add(instance);
                this.totalDelta += instance.delta;
            }
        }

        private boolean shouldExtract() {
            return this.totalDelta < 0;
        }
    }

    static enum Pattern {
        USE_GLOBAL_TEMP("var t;".length(), "t=y.prototype;".length(), "t.y=".length() - "x[p].y=".length()),
        USE_IIFE(0, "(function(t){})(y.prototype);".length(), "t.y=".length() - "x.prototype.y=".length());

        private final int globalOverhead;
        private final int perExtractionOverhead;
        private final int perMemberOverhead;

        private Pattern(int globalOverHead, int perExtractionOverhead, int perMemberOverhead) {
            this.globalOverhead = globalOverHead;
            this.perExtractionOverhead = perExtractionOverhead;
            this.perMemberOverhead = perMemberOverhead;
        }

        static /* synthetic */ int access$500(Pattern x0) {
            return x0.globalOverhead;
        }
    }
}

