/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Set;

public class KeepRoyalePropertyNames
implements CompilerPass {
    private final AbstractCompiler compiler;
    private Set<String> propertyNamesToKeep;

    public KeepRoyalePropertyNames(AbstractCompiler compiler, Set<String> propertyNamesToKeep) {
        this.compiler = compiler;
        this.propertyNamesToKeep = propertyNamesToKeep;
    }

    public void process(Node externs, Node root) {
        for (String nameToKeep : this.propertyNamesToKeep) {
            this.addExtern(nameToKeep);
        }
    }

    private void addExtern(String export) {
        Node objectPrototype = NodeUtil.newQName((AbstractCompiler)this.compiler, (String)"Object.prototype");
        JSType objCtor = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE);
        objectPrototype.getFirstChild().setJSType(objCtor);
        Node propstmt = IR.exprResult((Node)IR.getprop((Node)objectPrototype, (Node)IR.string((String)export)));
        propstmt.useSourceInfoFromForTree(this.getSynthesizedExternsRoot());
        propstmt.setOriginalName(export);
        this.getSynthesizedExternsRoot().addChildToBack(propstmt);
        this.compiler.reportChangeToEnclosingScope(propstmt);
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }
}

