/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.abc.ABCConstants;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IConstantDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceResolvedReference;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.NonResolvingIdentifierNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.utils.NativeUtils;

public class IdentifierEmitter
extends JSSubEmitter
implements ISubEmitter<IIdentifierNode> {
    public IdentifierEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IIdentifierNode node) {
        IConstantDefinition constDef;
        Object initialValue;
        boolean isStatic;
        if (node instanceof NonResolvingIdentifierNode) {
            this.startMapping((ISourceLocation)node);
            this.write(node.getName());
            this.endMapping((ISourceLocation)node);
            return;
        }
        IDefinition nodeDef = node.resolve(this.getProject());
        IASNode parentNode = node.getParent();
        ASTNodeID parentNodeId = parentNode.getNodeID();
        IASNode grandparentNode = parentNode.getParent();
        boolean identifierIsAccessorFunction = nodeDef instanceof AccessorDefinition;
        boolean identifierIsPlainFunction = nodeDef instanceof FunctionDefinition && !identifierIsAccessorFunction;
        boolean emitName = true;
        boolean wroteMemberAccess = false;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        boolean isCustomNamespace = false;
        boolean bl = isStatic = nodeDef != null && nodeDef.isStatic();
        if (nodeDef instanceof FunctionDefinition && fjs.isCustomNamespace((FunctionDefinition)nodeDef)) {
            isCustomNamespace = true;
        }
        if (isStatic && nodeDef instanceof IConstantDefinition && project != null && project.config != null && project.config.getInlineConstants() && (initialValue = (constDef = (IConstantDefinition)nodeDef).resolveInitialValue((ICompilerProject)project)) != null) {
            this.startMapping((ISourceLocation)parentNode);
            if (initialValue instanceof String) {
                this.write(ASEmitterTokens.DOUBLE_QUOTE);
                this.write((String)initialValue);
                this.write(ASEmitterTokens.DOUBLE_QUOTE);
            } else if (initialValue == ABCConstants.UNDEFINED_VALUE) {
                this.write("undefined");
            } else if (initialValue == ABCConstants.NULL_VALUE) {
                this.write("null");
            } else {
                this.write(initialValue.toString());
            }
            this.endMapping((ISourceLocation)parentNode);
            return;
        }
        if (isStatic) {
            String baseName;
            String sname = nodeDef.getParent().getQualifiedName();
            if (sname.equals("Array")) {
                baseName = nodeDef.getBaseName();
                if (baseName.equals("CASEINSENSITIVE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("1");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("DESCENDING")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("2");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("UNIQUESORT")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("4");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("RETURNINDEXEDARRAY")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("8");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("NUMERIC")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("16");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
            } else if (sname.equals("int")) {
                baseName = nodeDef.getBaseName();
                if (baseName.equals("MAX_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("2147483647");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("MIN_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("-2147483648");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
            } else if (sname.equals("uint")) {
                baseName = nodeDef.getBaseName();
                if (baseName.equals("MAX_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("4294967295");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
                if (baseName.equals("MIN_VALUE")) {
                    this.startMapping((ISourceLocation)parentNode);
                    this.write("0");
                    this.endMapping((ISourceLocation)parentNode);
                    return;
                }
            }
            if (sname.length() > 0) {
                IASNode prevSibling = parentNode.getChild(0);
                if (prevSibling == node) {
                    this.startMapping((ISourceLocation)parentNode);
                } else {
                    this.startMapping((ISourceLocation)prevSibling);
                }
                this.write(this.getEmitter().formatQualifiedName(sname));
                if (prevSibling != node) {
                    this.endMapping((ISourceLocation)prevSibling);
                    this.startMapping((ISourceLocation)parentNode, (ISourceLocation)prevSibling);
                }
                if (!isCustomNamespace) {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    wroteMemberAccess = true;
                }
                this.endMapping((ISourceLocation)parentNode);
            }
        } else if (!NativeUtils.isNative(node.getName())) {
            boolean generateClosure;
            boolean bl2 = generateClosure = identifierIsPlainFunction && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER && parentNodeId != ASTNodeID.FunctionCallID && parentNodeId != ASTNodeID.MemberAccessExpressionID;
            if (generateClosure) {
                this.getEmitter().emitClosureStart();
            }
            boolean wroteSelf = false;
            if (EmitterUtils.writeThis(this.getProject(), this.getModel(), node)) {
                IFunctionObjectNode functionObjectNode = (IFunctionObjectNode)node.getParent().getAncestorOfType(IFunctionObjectNode.class);
                IFunctionNode functionNode = (IFunctionNode)node.getParent().getAncestorOfType(IFunctionNode.class);
                IFunctionDefinition functionDef = null;
                if (functionNode != null) {
                    functionDef = functionNode.getDefinition();
                }
                this.startMapping((ISourceLocation)node);
                if (functionObjectNode != null) {
                    this.write(JSGoogEmitterTokens.SELF);
                    wroteSelf = true;
                } else if (functionNode != null && functionDef.getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL) {
                    this.write(JSGoogEmitterTokens.SELF);
                    wroteSelf = true;
                } else {
                    this.write(ASEmitterTokens.THIS);
                }
                if (!isCustomNamespace) {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    wroteMemberAccess = true;
                }
                this.endMapping((ISourceLocation)node);
            } else if (EmitterUtils.writeE4xFilterNode(this.getProject(), this.getModel(), (IExpressionNode)node)) {
                this.write("node.");
            }
            if (generateClosure) {
                if (isCustomNamespace) {
                    Namespace ns = ((INamespaceResolvedReference)((FunctionDefinition)nodeDef).getNamespaceReference()).resolveAETNamespace(this.getProject());
                    INamespaceDefinition nsDef = ((FunctionDefinition)nodeDef).getNamespaceReference().resolveNamespaceReference(this.getProject());
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    String nsName = ns.getName();
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(nsName, node.getName(), true));
                } else {
                    String qname = node.getName();
                    if (nodeDef != null && !isStatic && !(nodeDef instanceof IParameterDefinition) && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                        qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
                    }
                    this.write(qname);
                }
                this.writeToken(ASEmitterTokens.COMMA);
                if (wroteSelf) {
                    this.write(JSGoogEmitterTokens.SELF);
                } else {
                    this.write(ASEmitterTokens.THIS);
                }
                this.getEmitter().emitClosureEnd((IASNode)node, nodeDef);
                emitName = false;
            }
        }
        if (emitName) {
            boolean accessWithNS;
            boolean bl3 = accessWithNS = !wroteMemberAccess;
            if (nodeDef != null) {
                String ns;
                IFunctionDefinition func;
                IVariableDefinition.VariableClassification classification;
                String qname = nodeDef.getQualifiedName();
                boolean isPackageOrFileMember = false;
                if (nodeDef instanceof IVariableDefinition) {
                    String ns2;
                    IVariableDefinition variable = (IVariableDefinition)nodeDef;
                    classification = variable.getVariableClassification();
                    if (classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER) {
                        isPackageOrFileMember = true;
                    }
                    if ((isCustomNamespace = EmitterUtils.isCustomNamespace(ns2 = nodeDef.getNamespaceReference().getBaseName())) && parentNode instanceof IMemberAccessExpressionNode && ((IMemberAccessExpressionNode)parentNode).getRightOperandNode() == node) {
                        accessWithNS = true;
                        boolean wasCustomNamespace = false;
                        if (nodeDef instanceof IAccessorDefinition && ((IMemberAccessExpressionNode)parentNode).getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS) {
                            wasCustomNamespace = fjs.isCustomNamespace((FunctionDefinition)nodeDef);
                        }
                        if (!wasCustomNamespace) {
                            accessWithNS = false;
                        }
                    }
                } else if (nodeDef instanceof IFunctionDefinition && ((classification = (func = (IFunctionDefinition)nodeDef).getFunctionClassification()) == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER || classification == IFunctionDefinition.FunctionClassification.FILE_MEMBER)) {
                    isPackageOrFileMember = true;
                }
                boolean needsFormattedName = false;
                if (isPackageOrFileMember && parentNodeId == ASTNodeID.MemberAccessExpressionID) {
                    IMemberAccessExpressionNode parentMemberAccessNode = (IMemberAccessExpressionNode)parentNode;
                    needsFormattedName = parentMemberAccessNode.getLeftOperandNode() == node;
                }
                this.startMapping((ISourceLocation)node);
                if (parentNodeId == ASTNodeID.MemberAccessExpressionID) {
                    if (needsFormattedName) {
                        this.write(this.getEmitter().formatQualifiedName(qname));
                    } else if (isCustomNamespace) {
                        ns = ((INamespaceResolvedReference)nodeDef.getNamespaceReference()).resolveAETNamespace(this.getProject()).getName();
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(ns, qname, accessWithNS));
                    } else {
                        if (!(nodeDef.getParent() instanceof IPackageDefinition)) {
                            qname = node.getName();
                            if (nodeDef != null && !isStatic && nodeDef.getParent() instanceof ClassDefinition && !(nodeDef instanceof IParameterDefinition) && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                                qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
                            }
                        }
                        this.write(qname);
                    }
                } else if (isPackageOrFileMember) {
                    this.write(this.getEmitter().formatQualifiedName(qname));
                } else if (nodeDef instanceof TypeDefinitionBase) {
                    if (NativeUtils.isSyntheticJSType(qname) && !(parentNode instanceof IFunctionCallNode)) {
                        this.getEmitter().getModel().needLanguage = true;
                        this.write(JSRoyaleEmitterTokens.SYNTH_TYPE);
                        this.write(ASEmitterTokens.PAREN_OPEN);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(this.getEmitter().formatQualifiedName(qname));
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                    } else {
                        this.write(this.getEmitter().formatQualifiedName(qname));
                    }
                } else if (isCustomNamespace) {
                    ns = ((INamespaceResolvedReference)nodeDef.getNamespaceReference()).resolveAETNamespace(this.getProject()).getName();
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(ns, qname, accessWithNS));
                } else {
                    if (nodeDef != null && !isStatic && nodeDef.getParent() instanceof ClassDefinition && !(nodeDef instanceof IParameterDefinition) && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                        qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
                    }
                    this.write(qname);
                }
                this.endMapping((ISourceLocation)node);
            } else if (this.getModel().inE4xFilter && EmitterUtils.writeE4xFilterNode(this.getProject(), this.getModel(), (IExpressionNode)node) && parentNodeId != ASTNodeID.MemberAccessExpressionID && parentNodeId != ASTNodeID.Op_DescendantsID && parentNodeId != ASTNodeID.FunctionCallID) {
                this.startMapping((ISourceLocation)node);
                this.write("child('");
                this.write(node.getName());
                this.write("')");
                this.endMapping((ISourceLocation)node);
            } else {
                this.startMapping((ISourceLocation)node);
                this.write(node.getName());
                this.endMapping((ISourceLocation)node);
            }
        }
    }
}

