/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.mxml;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.common.MutablePrefixMap;
import org.apache.royale.compiler.common.PrefixMap;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.parsing.mxml.RawMXMLTokenizer;
import org.apache.royale.compiler.parsing.IMXMLToken;
import org.apache.royale.compiler.parsing.IMXMLTokenizer;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem2;
import org.apache.royale.compiler.problems.MXMLUnclosedTagProblem;
import org.apache.royale.utils.NonLockingStringReader;

public class MXMLTokenizer
implements IMXMLTokenizer,
Closeable {
    protected int startOffset;
    private int tagDepth = -1;
    private boolean inTagContent = false;
    private RawMXMLTokenizer tokenizer = new RawMXMLTokenizer();
    protected MXMLToken xmlNSToken = null;
    protected MutablePrefixMap rootPrefixMap;
    private MXMLToken postRepairToken = null;
    private boolean isRepairing = true;
    private boolean wasRepaired = false;
    private static final int SIZE = 100;
    private List<ICompilerProblem> problems;
    private String path;
    private MXMLToken lastToken = null;
    private static final String SUB_SYSTEM = "MXMLTokenizer";

    public MXMLTokenizer(String path) {
        this.tokenizer.setSourcePath(path);
        this.problems = new ArrayList<ICompilerProblem>();
        this.rootPrefixMap = new MutablePrefixMap();
        this.path = path;
    }

    public MXMLTokenizer() {
        this("");
    }

    public MXMLTokenizer(IFileSpecification specification) {
        this(specification.getPath());
    }

    public MXMLTokenizer(int startOffset) {
        this("");
        this.startOffset = startOffset;
    }

    public void setPath(String path) {
        this.path = path;
        this.tokenizer.setSourcePath(path);
    }

    public void setReader(Reader reader) {
        this.tokenizer.reset();
        this.tokenizer.yyreset(reader);
    }

    @Override
    public void close() throws IOException {
        if (this.tokenizer != null) {
            this.tokenizer.reset();
            this.tokenizer.yyclose();
        }
    }

    public PrefixMap getPrefixMap() {
        return this.rootPrefixMap;
    }

    @Override
    public void setIsRepairing(boolean isRepairing) {
        this.isRepairing = isRepairing;
    }

    @Override
    public IMXMLToken[] getTokens(Reader reader) {
        List<MXMLToken> parseTokens = this.parseTokens(reader);
        return parseTokens.toArray(new IMXMLToken[0]);
    }

    @Override
    public IMXMLToken[] getTokens(String range) {
        List<MXMLToken> parseTokens = this.parseTokens(new NonLockingStringReader(range));
        return parseTokens.toArray(new IMXMLToken[0]);
    }

    public boolean hasTokenizationProblems() {
        return this.tokenizer.hasProblems() || this.problems.size() > 0;
    }

    public PrefixMap getRootTagPrefixMap() {
        boolean cont = true;
        do {
            MXMLToken token;
            if ((token = this.nextToken()) != null && !token.isTagEnd()) continue;
            cont = false;
        } while (cont);
        return this.rootPrefixMap;
    }

    public List<ICompilerProblem> getTokenizationProblems() {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(this.problems);
        problems.addAll(this.tokenizer.getProblems());
        return problems;
    }

    private final MXMLToken nextTokenInternal() {
        try {
            MXMLToken token;
            MXMLToken mXMLToken = token = this.tokenizer.hasBufferToken() ? (MXMLToken)this.tokenizer.getBufferToken() : (MXMLToken)this.tokenizer.nextToken();
            if (token == null) {
                return null;
            }
            MXMLToken mxmlToken = this.processToken(token);
            return mxmlToken;
        }
        catch (Exception e) {
            InternalCompilerProblem2 problem = new InternalCompilerProblem2(this.path, e, SUB_SYSTEM);
            this.problems.add(problem);
            return null;
        }
    }

    public MXMLToken nextToken() {
        if (this.isRepairing) {
            if (this.postRepairToken != null) {
                MXMLToken retVal = this.postRepairToken;
                this.postRepairToken = null;
                return retVal;
            }
            MXMLToken mxmlToken = this.nextTokenInternal();
            MXMLToken addedToken = this.analyzeForEndTagProblems(mxmlToken);
            if (addedToken != null) {
                this.postRepairToken = mxmlToken;
                this.wasRepaired = true;
                return addedToken;
            }
            return mxmlToken;
        }
        return this.nextTokenInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MXMLToken> parseTokens(Reader input) {
        this.wasRepaired = false;
        this.setReader(input);
        this.tokenizer.setOffset(this.startOffset);
        MXMLToken token = null;
        ArrayList<MXMLToken> list = new ArrayList<MXMLToken>(100);
        try {
            do {
                if ((token = this.nextToken()) == null) continue;
                this.buildTokenList(token.clone(), list);
            } while (token != null);
            this.lastToken = null;
            ArrayList<MXMLToken> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                this.tokenizer.yyclose();
            }
            catch (IOException e) {
                InternalCompilerProblem2 problem = new InternalCompilerProblem2(this.path, e, SUB_SYSTEM);
                this.problems.add(problem);
            }
        }
    }

    private MXMLToken analyzeForEndTagProblems(MXMLToken currentToken) {
        if (currentToken == null) {
            return null;
        }
        try {
            if (currentToken.isTagStart() && this.lastToken != null) {
                switch (this.lastToken.getType()) {
                    case -1: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        MXMLToken mXMLToken = null;
                        return mXMLToken;
                    }
                }
                MXMLToken mXMLToken = null;
                return mXMLToken;
            }
            MXMLToken mXMLToken = null;
            return mXMLToken;
        }
        finally {
            this.lastToken = currentToken;
        }
    }

    public boolean tokensWereRepaired() {
        return this.wasRepaired;
    }

    private MXMLToken processToken(MXMLToken token) {
        if (this.lastToken != null && this.lastToken.getType() == 3 && token.getType() != 11) {
            this.problems.add(new MXMLUnclosedTagProblem(token, this.lastToken.getText()));
            return null;
        }
        switch (token.getType()) {
            case 8: {
                ++this.tagDepth;
                this.inTagContent = true;
                return token;
            }
            case 3: {
                --this.tagDepth;
                this.inTagContent = true;
                return token;
            }
            case 5: 
            case 11: {
                this.inTagContent = false;
                return token;
            }
            case 2: 
            case 6: {
                return token;
            }
            case 7: {
                this.xmlNSToken = null;
                return token;
            }
            case 14: {
                token.setType(7);
                this.xmlNSToken = token;
                return token;
            }
            case 10: {
                if (this.xmlNSToken != null && this.tagDepth == 0) {
                    String nsText;
                    String prefix = "";
                    String text = this.xmlNSToken.getText();
                    if (text.length() > 5) {
                        prefix = text.substring(6);
                    }
                    String ns = (nsText = token.getText()).length() > 1 ? nsText.substring(1, nsText.length() - 1) : "";
                    this.rootPrefixMap.add(prefix, ns);
                }
                return token;
            }
        }
        if (!(this.tagDepth == 0 || this.tokenizer.isInE4XDatabinding() || this.inTagContent || !token.isLiteral() && token.getType() != 15)) {
            token.setType(12);
        }
        return token;
    }

    protected void buildTokenList(MXMLToken token, List<MXMLToken> list) {
        if (token != null) {
            list.add(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileSpecification fileSpec = new FileSpecification(args[0]);
        MXMLTokenizer tokenizer = new MXMLTokenizer(fileSpec.getPath());
        try {
            List<MXMLToken> tokens = tokenizer.parseTokens(fileSpec.createReader());
            for (MXMLToken token : tokens) {
                System.out.println(token.toDumpString());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
    }
}

