/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.processor.injection;

import org.apache.servicecomb.governance.policy.FaultInjectionPolicy;
import org.apache.servicecomb.governance.processor.injection.AbstractFault;
import org.apache.servicecomb.governance.processor.injection.FaultInjectionUtil;
import org.apache.servicecomb.governance.processor.injection.FaultParam;
import org.apache.servicecomb.governance.processor.injection.Sleepable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayFault
extends AbstractFault {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayFault.class);

    public DelayFault(String key, FaultInjectionPolicy policy) {
        super(key, policy);
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public boolean injectFault(FaultParam faultParam) {
        if (!this.shouldDelay(faultParam, this.policy)) {
            return false;
        }
        LOGGER.debug("Fault injection: delay is added for the request by fault inject handler");
        long delay = this.policy.getDelayTimeToMillis();
        if (delay == -1L) {
            LOGGER.debug("Fault injection: delay is not configured");
            return false;
        }
        this.executeDelay(faultParam, delay);
        return false;
    }

    private void executeDelay(FaultParam faultParam, long delay) {
        Sleepable sleepable = faultParam.getSleepable();
        if (sleepable != null) {
            sleepable.sleep(delay);
        }
    }

    private boolean shouldDelay(FaultParam param, FaultInjectionPolicy policy) {
        int delayPercent = policy.getPercentage();
        if (delayPercent == -1) {
            LOGGER.debug("Fault injection: delay percentage is not configured");
            return false;
        }
        return FaultInjectionUtil.isFaultNeedToInject(param.getReqCount(), delayPercent);
    }

    @Override
    public String getName() {
        return "delay";
    }
}

