/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.localregistry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.core.provider.LocalOpenAPIRegistry;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.apache.servicecomb.localregistry.LocalDiscoveryInstance;
import org.apache.servicecomb.localregistry.LocalRegistrationInstance;
import org.apache.servicecomb.localregistry.RegistryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalRegistryStore {
    private static final String REGISTRY_FILE_NAME = "registry.yaml";
    private LocalRegistrationInstance selfMicroserviceInstance;
    private LocalOpenAPIRegistry localOpenAPIRegistry;
    private final Map<String, Map<String, List<LocalDiscoveryInstance>>> microserviceInstanceMap = new ConcurrentHashMap<String, Map<String, List<LocalDiscoveryInstance>>>();

    @Autowired
    public void setLocalRegistrationInstance(LocalRegistrationInstance selfMicroserviceInstance) {
        this.selfMicroserviceInstance = selfMicroserviceInstance;
    }

    @Autowired
    public void setLocalOpenAPIRegistry(LocalOpenAPIRegistry localOpenAPIRegistry) {
        this.localOpenAPIRegistry = localOpenAPIRegistry;
    }

    public void init() {
        this.microserviceInstanceMap.clear();
    }

    public void run() {
        List<RegistryBean> beans = this.loadYamlBeans();
        BeanUtils.getBeansOfType(RegistryBean.class).forEach((key, value) -> beans.add((RegistryBean)value));
        this.initRegistryFromBeans(beans);
        this.addSelf();
    }

    private void addSelf() {
        this.microserviceInstanceMap.computeIfAbsent(this.selfMicroserviceInstance.getApplication(), key -> new ConcurrentHashMapEx()).computeIfAbsent(this.selfMicroserviceInstance.getServiceName(), key -> new ArrayList()).add(new LocalDiscoveryInstance(this.selfMicroserviceInstance));
    }

    private List<RegistryBean> loadYamlBeans() {
        ArrayList<RegistryBean> beans = new ArrayList<RegistryBean>();
        try {
            ClassLoader loader = JvmUtils.findClassLoader();
            Enumeration<URL> urls = loader.getResources(REGISTRY_FILE_NAME);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = url.openStream();
                try {
                    if (is == null) continue;
                    beans.addAll(this.initFromData(is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return beans;
    }

    private List<RegistryBean> initFromData(InputStream is) {
        Map data = YAMLUtil.yaml2Properties((InputStream)is);
        return this.initFromData(data);
    }

    private List<RegistryBean> initFromData(Map<String, Object> data) {
        ArrayList<RegistryBean> beans = new ArrayList<RegistryBean>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String name = entry.getKey();
            List serviceConfigs = (List)entry.getValue();
            for (Map serviceConfig : serviceConfigs) {
                beans.add(RegistryBean.buildFromYamlModel(name, serviceConfig));
            }
        }
        return beans;
    }

    private void initRegistryFromBeans(List<RegistryBean> beans) {
        beans.forEach(bean -> {
            List instances = this.microserviceInstanceMap.computeIfAbsent(bean.getAppId(), key -> new ConcurrentHashMapEx()).computeIfAbsent(bean.getServiceName(), key -> new ArrayList());
            if (bean.getInstances() == null) {
                return;
            }
            for (RegistryBean.Instance instance : bean.getInstances().getInstances()) {
                instances.add(new LocalDiscoveryInstance(this.localOpenAPIRegistry, (RegistryBean)bean, instance.getEndpoints(), this.selfMicroserviceInstance));
            }
        });
    }

    public List<LocalDiscoveryInstance> findServiceInstances(String application, String serviceName) {
        Map<String, List<LocalDiscoveryInstance>> app = this.microserviceInstanceMap.get(application);
        if (app == null) {
            return Collections.emptyList();
        }
        List<LocalDiscoveryInstance> instances = app.get(serviceName);
        if (instances == null) {
            return Collections.emptyList();
        }
        return instances;
    }

    public List<String> findServices(String application) {
        if (this.microserviceInstanceMap.get(application) == null) {
            return Collections.emptyList();
        }
        return this.microserviceInstanceMap.get(application).keySet().stream().toList();
    }
}

