/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.config.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.servicecomb.foundation.common.utils.FortifyUtils;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XmlLoaderUtils {
    private static ObjectMapper xmlMapper = new XmlMapper();

    private XmlLoaderUtils() {
    }

    public static <T> T load(Resource res, Class<?> cls) throws Exception {
        return (T)xmlMapper.readValue(res.getURL(), cls);
    }

    public static Document load(URL url) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = FortifyUtils.getSecurityXmlDocumentFactory();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(url.toString());
    }

    public static Document load(Resource res) throws Exception {
        return XmlLoaderUtils.load(res.getURL());
    }

    public static Document newDoc() throws ParserConfigurationException {
        DocumentBuilderFactory factory = FortifyUtils.getSecurityXmlDocumentFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static void mergeElement(Element from, Element to) {
        Node node;
        int idx;
        for (idx = 0; idx < from.getAttributes().getLength(); ++idx) {
            node = from.getAttributes().item(idx);
            to.getAttributes().setNamedItem(node.cloneNode(false));
        }
        for (idx = 0; idx < from.getChildNodes().getLength(); ++idx) {
            node = from.getChildNodes().item(idx);
            if (!Element.class.isInstance(node)) continue;
            to.appendChild(node.cloneNode(true));
        }
    }
}

