/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.toolkit.CodeGenerator;
import org.apache.servicecomb.toolkit.ContractsGenerator;
import org.apache.servicecomb.toolkit.DocGenerator;
import org.apache.servicecomb.toolkit.Generator;

public class GeneratorFactory {
    private static final Map<String, List> interfaceMap = new ConcurrentHashMap<String, List>();

    public static void addGeneratorType(Class<? extends Generator> generatorClass) {
        if (interfaceMap.get(generatorClass.getName()) == null) {
            interfaceMap.put(generatorClass.getName(), GeneratorFactory.loadInitialCodeGenerators(generatorClass));
        }
    }

    private static List<Generator> loadInitialCodeGenerators(Class<? extends Generator> generatorClass) {
        ArrayList<Generator> registeredGenerators = new ArrayList<Generator>();
        ServiceLoader.load(generatorClass).forEach(registeredGenerators::add);
        return registeredGenerators;
    }

    public static <T extends Generator> T getGenerator(Class<? extends T> generatorClass, String type) {
        List registeredList = interfaceMap.get(generatorClass.getName());
        for (Generator generator : registeredList) {
            if (!generator.canProcess(type)) continue;
            return (T)generator;
        }
        return null;
    }

    static {
        GeneratorFactory.addGeneratorType(CodeGenerator.class);
        GeneratorFactory.addGeneratorType(DocGenerator.class);
        GeneratorFactory.addGeneratorType(ContractsGenerator.class);
    }
}

