/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.mergepatch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.mergepatch.ArrayMergePatch;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatchDeserializer;
import com.github.fge.jsonpatch.mergepatch.ObjectMergePatch;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

@JsonDeserialize(using=JsonMergePatchDeserializer.class)
public abstract class JsonMergePatch
implements JsonSerializable {
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected final JsonNode origPatch;

    protected JsonMergePatch(JsonNode node) {
        this.origPatch = node;
    }

    public abstract JsonNode apply(JsonNode var1) throws JsonPatchException;

    public static JsonMergePatch fromJson(JsonNode input) throws JsonPatchException {
        BUNDLE.checkNotNull((Object)input, "jsonPatch.nullInput");
        BUNDLE.checkArgumentPrintf(input.isContainerNode(), "mergePatch.notContainer", new Object[]{NodeType.getNodeType((JsonNode)input)});
        return input.isArray() ? new ArrayMergePatch(input) : new ObjectMergePatch(input);
    }

    protected static JsonNode clearNulls(JsonNode node) {
        if (!node.isContainerNode()) {
            return node;
        }
        return node.isArray() ? JsonMergePatch.clearNullsFromArray(node) : JsonMergePatch.clearNullsFromObject(node);
    }

    private static JsonNode clearNullsFromArray(JsonNode node) {
        ArrayNode ret = FACTORY.arrayNode();
        for (JsonNode element : node) {
            if (element.isNull()) continue;
            ret.add(JsonMergePatch.clearNulls(element));
        }
        return ret;
    }

    private static JsonNode clearNullsFromObject(JsonNode node) {
        ObjectNode ret = FACTORY.objectNode();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isNull()) continue;
            ret.put((String)entry.getKey(), JsonMergePatch.clearNulls(value));
        }
        return ret;
    }

    public final void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeTree((TreeNode)this.origPatch);
    }

    public final void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }
}

