/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.toolkit.generator;

/**
 * Common media type constants
 *
 * @see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.7">HTTP/1.1 section 3.7</a>
 */
public class MediaTypes {

  public final static String WILDCARD = "*/*";

  public final static String APPLICATION_XML = "application/xml";

  public final static String APPLICATION_ATOM_XML = "application/atom+xml";

  public final static String APPLICATION_XHTML_XML = "application/xhtml+xml";

  public final static String APPLICATION_SVG_XML = "application/svg+xml";

  public final static String APPLICATION_JSON = "application/json";

  public final static String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";

  public final static String MULTIPART_FORM_DATA = "multipart/form-data";

  public final static String APPLICATION_OCTET_STREAM = "application/octet-stream";

  public final static String TEXT_PLAIN = "text/plain";

  public final static String TEXT_XML = "text/xml";

  public final static String TEXT_HTML = "text/html";

  public final static String SERVER_SENT_EVENTS = "text/event-stream";

  public final static String APPLICATION_JSON_PATCH_JSON = "application/json-patch+json";
}
