/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.springframework.osgi.service.importer.support.internal.collection.DynamicSet;
import org.springframework.util.Assert;

public class DynamicSortedSet
extends DynamicSet
implements SortedSet {
    private final Comparator comparator;

    public DynamicSortedSet() {
        this((Comparator)null);
    }

    public DynamicSortedSet(Collection c) {
        this.comparator = null;
        this.addAll(c);
    }

    public DynamicSortedSet(int size2) {
        super(size2);
        this.comparator = null;
    }

    public DynamicSortedSet(SortedSet ss) {
        this.comparator = ss.comparator();
        this.addAll((Collection)ss);
    }

    public DynamicSortedSet(Comparator c) {
        this.comparator = c;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        Assert.notNull((Object)o);
        if (this.comparator == null && !(o instanceof Comparable)) {
            throw new ClassCastException("given object does not implement " + Comparable.class.getName() + " and no Comparator is set on the collection");
        }
        int index = 0;
        List list = this.storage;
        synchronized (list) {
            index = Collections.binarySearch(this.storage, o, this.comparator);
            if (index >= 0) {
                return false;
            }
            index = -index - 1;
            super.add(index, o);
        }
        return true;
    }

    public boolean remove(Object o) {
        Assert.notNull((Object)o);
        return super.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object first() {
        List list = this.storage;
        synchronized (list) {
            if (this.storage.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.storage.get(0);
        }
    }

    public SortedSet headSet(Object toElement) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object last() {
        List list = this.storage;
        synchronized (list) {
            if (this.storage.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.storage.get(this.storage.size() - 1);
        }
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        throw new UnsupportedOperationException();
    }

    public SortedSet tailSet(Object fromElement) {
        throw new UnsupportedOperationException();
    }
}

