/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.util.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ReplaceableService<T> {
    private final BundleContext context;
    private final Class<T> serviceClass;
    private final ReplaceableServiceListener<T> serviceListener;
    private final ServiceTracker<T, T> serviceTracker;
    private final List<ServiceReference<T>> boundReferences;
    private T replacableService;

    public ReplaceableService(BundleContext bundleContext, Class<T> replacableServiceClass, ReplaceableServiceListener<T> replacableServiceListener) {
        this.context = bundleContext;
        this.serviceClass = replacableServiceClass;
        this.serviceListener = replacableServiceListener;
        this.serviceTracker = new ServiceTracker(bundleContext, replacableServiceClass, (ServiceTrackerCustomizer)new Customizer());
        this.boundReferences = new ArrayList<ServiceReference<T>>();
    }

    public void start() {
        this.serviceTracker.open();
    }

    public void stop() {
        this.serviceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(T service) {
        if (this.serviceListener != null) {
            T oldService;
            ReplaceableService replaceableService = this;
            synchronized (replaceableService) {
                oldService = this.replacableService;
                this.replacableService = service;
            }
            this.serviceListener.serviceChanged(oldService, service);
        }
    }

    private class Customizer
    implements ServiceTrackerCustomizer<T, T> {
        private Customizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T addingService(ServiceReference<T> reference) {
            ServiceReference bind;
            Object service = ReplaceableService.this.context.getService(reference);
            List list = ReplaceableService.this.boundReferences;
            synchronized (list) {
                ReplaceableService.this.boundReferences.add(reference);
                Collections.sort(ReplaceableService.this.boundReferences);
                bind = (ServiceReference)ReplaceableService.this.boundReferences.get(0);
            }
            if (bind == reference) {
                ReplaceableService.this.bind(service);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.serviceTracker.getService(bind));
            }
            return service;
        }

        public void modifiedService(ServiceReference<T> reference, T service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<T> reference, T service) {
            ServiceReference bind;
            if (ReplaceableService.this.context == null) {
                return;
            }
            List list = ReplaceableService.this.boundReferences;
            synchronized (list) {
                ReplaceableService.this.boundReferences.remove(reference);
                bind = ReplaceableService.this.boundReferences.isEmpty() ? null : (ServiceReference)ReplaceableService.this.boundReferences.get(0);
            }
            if (bind == null) {
                ReplaceableService.this.bind(null);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.serviceTracker.getService(bind));
            }
            boolean active = false;
            try {
                active = 32 == ReplaceableService.this.context.getBundle().getState();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (active) {
                ReplaceableService.this.context.ungetService(reference);
            }
        }
    }
}

