/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.binding;

import org.apache.camel.Processor;
import org.apache.camel.processor.MarshalProcessor;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.spi.Binding;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DataFormatBinding
extends ServiceSupport
implements Binding {
    private DataFormat producerDataFormat;
    private DataFormat consumerDataFormat;

    public DataFormatBinding() {
    }

    public DataFormatBinding(DataFormat dataFormat) {
        this(dataFormat, dataFormat);
    }

    public DataFormatBinding(DataFormat consumerDataFormat, DataFormat producerDataFormat) {
        this.consumerDataFormat = consumerDataFormat;
        this.producerDataFormat = producerDataFormat;
    }

    @Override
    public Processor createProduceProcessor() {
        ObjectHelper.notNull(this.producerDataFormat, "producerDataFormat");
        return new MarshalProcessor(this.producerDataFormat);
    }

    @Override
    public Processor createConsumeProcessor() {
        ObjectHelper.notNull(this.consumerDataFormat, "consumerDataFormat");
        return new UnmarshalProcessor(this.consumerDataFormat);
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.setConsumerDataFormat(dataFormat);
        this.setProducerDataFormat(dataFormat);
    }

    public DataFormat getConsumerDataFormat() {
        return this.consumerDataFormat;
    }

    public void setConsumerDataFormat(DataFormat consumerDataFormat) {
        this.consumerDataFormat = consumerDataFormat;
    }

    public DataFormat getProducerDataFormat() {
        return this.producerDataFormat;
    }

    public void setProducerDataFormat(DataFormat producerDataFormat) {
        this.producerDataFormat = producerDataFormat;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

