/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.ZoneId;
import java.util.Locale;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.io.stream.ChannelFactory;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.io.stream.Markable;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.ConcurrentReadException;
import org.apache.sis.storage.ConcurrentWriteException;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.xml.stream.FormattedWriter;
import org.apache.sis.storage.xml.stream.InputType;
import org.apache.sis.storage.xml.stream.OutputType;
import org.apache.sis.storage.xml.stream.StaxDataStoreProvider;
import org.apache.sis.storage.xml.stream.StaxStreamReader;
import org.apache.sis.storage.xml.stream.StaxStreamWriter;
import org.apache.sis.util.internal.shared.AbstractMap;
import org.apache.sis.util.internal.shared.Strings;

public abstract class StaxDataStore
extends URIDataStore {
    protected final Locale locale;
    protected final ZoneId timezone;
    protected final Charset encoding;
    final Config configuration;
    private Object storage;
    private volatile Closeable stream;
    private long streamPosition;
    private final InputType storageToReader;
    private final OutputType storageToWriter;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private final ChannelFactory channelFactory;
    private final byte indentation;
    private byte state;
    private static final byte START = 0;
    private static final byte READING = 1;
    private static final byte WRITING = 2;
    private static final byte FINISHED = 3;

    protected StaxDataStore(StaxDataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super((DataStoreProvider)provider, connector);
        this.storage = connector.getStorage();
        this.locale = (Locale)connector.getOption(OptionKey.LOCALE);
        this.timezone = (ZoneId)connector.getOption(OptionKey.TIMEZONE);
        this.encoding = (Charset)connector.getOption(OptionKey.ENCODING);
        Integer indent = (Integer)connector.getOption(OptionKey.INDENTATION);
        this.indentation = (byte)(indent == null ? 2 : (byte)Math.max(-1, Math.min(120, indent)));
        this.configuration = new Config();
        this.storageToWriter = OutputType.forType(this.storage.getClass());
        this.storageToReader = InputType.forType(this.storage.getClass());
        if (this.storageToReader == null) {
            this.stream = (Closeable)connector.getStorageAs(InputStream.class);
        }
        if (this.stream == null && this.storage instanceof Closeable) {
            this.stream = (Closeable)this.storage;
        }
        this.channelFactory = (ChannelFactory)connector.getStorageAs(ChannelFactory.class);
        connector.closeAllExcept((Object)this.stream);
        try {
            this.mark();
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    private void mark() throws IOException {
        this.streamPosition = -1L;
        if (this.stream instanceof Markable) {
            Markable m = (Markable)this.stream;
            this.streamPosition = m.getStreamPosition();
            m.mark();
        }
    }

    private boolean reset() throws IOException {
        if (this.streamPosition >= 0L) {
            try {
                Markable m = (Markable)this.stream;
                m.reset(this.streamPosition);
                m.mark();
                this.state = 0;
                return true;
            }
            catch (InvalidSeekException e) {
                this.listeners.warning((Exception)((Object)e));
            }
        }
        return false;
    }

    public final StaxDataStoreProvider getProvider() {
        return (StaxDataStoreProvider)this.provider;
    }

    public final String getFormatName() {
        return this.provider.getShortName();
    }

    final XMLInputFactory inputFactory() {
        assert (Thread.holdsLock((Object)this));
        if (this.inputFactory == null) {
            this.inputFactory = XMLInputFactory.newInstance();
            this.inputFactory.setXMLReporter(this.configuration);
        }
        return this.inputFactory;
    }

    final XMLOutputFactory outputFactory() {
        assert (Thread.holdsLock((Object)this));
        if (this.outputFactory == null) {
            this.outputFactory = XMLOutputFactory.newInstance();
        }
        return this.outputFactory;
    }

    final synchronized XMLStreamReader createReader(StaxStreamReader target) throws Exception {
        Object inputOrFile = this.storage;
        if (inputOrFile == null) {
            throw new DataStoreClosedException(this.getLocale(), this.getFormatName(), new OpenOption[]{StandardOpenOption.READ});
        }
        Closeable input = this.stream;
        InputType type = this.storageToReader;
        switch (this.state) {
            default: {
                throw new AssertionError(this.state);
            }
            case 2: {
                throw new ConcurrentWriteException(this.getLocale(), this.getDisplayName());
            }
            case 0: {
                break;
            }
            case 3: {
                if (this.reset()) break;
                if (input != null) {
                    this.stream = null;
                    input.close();
                    input = null;
                }
            }
            case 1: {
                if (type == InputType.NODE) break;
                String name = this.getDisplayName();
                if (this.channelFactory == null) {
                    throw new ForwardOnlyStorageException(this.getLocale(), name, new OpenOption[]{StandardOpenOption.READ});
                }
                input = this.channelFactory.inputStream(name, this.listeners);
                inputOrFile = input;
                type = InputType.STREAM;
                if (this.stream != null) break;
                this.stream = input;
                this.state = 0;
                this.mark();
            }
        }
        if (type == null) {
            Closeable snapshot;
            if (this.storageToWriter != null && (snapshot = this.storageToWriter.snapshot(inputOrFile)) != null) {
                XMLStreamReader reader = this.storageToWriter.inputType.create(this, snapshot);
                target.stream = snapshot;
                return reader;
            }
            type = InputType.STREAM;
            if ((input = IOUtilities.toInputStream((AutoCloseable)input)) == null) {
                throw new UnsupportedStorageException(this.getLocale(), this.getFormatName(), this.storage, new OpenOption[]{StandardOpenOption.READ});
            }
            inputOrFile = input;
            if (input != this.stream) {
                this.stream = input;
                this.mark();
            }
        }
        XMLStreamReader reader = type.create(this, inputOrFile);
        target.stream = input;
        this.state = 1;
        return reader;
    }

    final synchronized XMLStreamWriter createWriter(StaxStreamWriter target, OutputStream temporary) throws DataStoreException, XMLStreamException, IOException {
        OutputType outputType;
        Object outputOrFile;
        Closeable output;
        if (temporary == null) {
            output = this.stream;
            outputOrFile = this.storage;
            outputType = this.storageToWriter;
            if (outputOrFile == null) {
                throw new DataStoreClosedException(this.getLocale(), this.getFormatName(), new OpenOption[]{StandardOpenOption.WRITE});
            }
            switch (this.state) {
                default: {
                    throw new AssertionError(this.state);
                }
                case 1: {
                    throw new ConcurrentReadException(this.getLocale(), this.getDisplayName());
                }
                case 2: {
                    throw new ConcurrentWriteException(this.getLocale(), this.getDisplayName());
                }
                case 0: {
                    break;
                }
                case 3: {
                    if (this.reset()) break;
                    throw new ForwardOnlyStorageException(this.getLocale(), this.getDisplayName(), new OpenOption[]{StandardOpenOption.WRITE});
                }
            }
            if (outputType == null) {
                outputType = OutputType.STREAM;
                output = IOUtilities.toOutputStream((AutoCloseable)output);
                outputOrFile = output;
                if (output == null) {
                    throw new UnsupportedStorageException(this.getLocale(), this.getFormatName(), outputOrFile, new OpenOption[]{StandardOpenOption.WRITE});
                }
                if (output != this.stream) {
                    this.stream = output;
                    this.mark();
                }
            }
        } else {
            outputType = OutputType.STREAM;
            output = temporary;
            outputOrFile = output;
        }
        Object writer = outputType.create(this, outputOrFile);
        if (this.indentation >= 0) {
            writer = new FormattedWriter((XMLStreamWriter)writer, this.indentation);
        }
        target.stream = output;
        if (temporary == null) {
            this.state = (byte)2;
        }
        return writer;
    }

    final synchronized boolean canClose(AutoCloseable finished) {
        if (finished == this.stream) {
            this.state = (byte)3;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DataStoreException {
        try {
            Object s = this.stream;
            if (s != null) {
                s.close();
            }
        }
        catch (DataStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataStoreException((Throwable)e);
        }
        finally {
            StaxDataStore staxDataStore = this;
            synchronized (staxDataStore) {
                this.outputFactory = null;
                this.inputFactory = null;
                this.storage = null;
                this.stream = null;
            }
        }
    }

    private final class Config
    extends AbstractMap<String, Object>
    implements XMLReporter,
    Filter {
        Config() {
        }

        public Object get(Object key) {
            if (key instanceof String) {
                switch ((String)key) {
                    case "org.apache.sis.xml.locale": {
                        return StaxDataStore.this.locale;
                    }
                    case "org.apache.sis.xml.timezone": {
                        return StaxDataStore.this.timezone;
                    }
                    case "org.apache.sis.xml.warningFilter": {
                        return this;
                    }
                }
            }
            return null;
        }

        protected AbstractMap.EntryIterator<String, Object> entryIterator() {
            return new AbstractMap.KeyIterator((AbstractMap)this, (Object[])new String[]{"org.apache.sis.xml.locale", "org.apache.sis.xml.timezone", "org.apache.sis.xml.warningFilter"});
        }

        @Override
        public void report(String message, String errorType, Object info, Location location) {
            LogRecord record = new LogRecord(Level.WARNING, message);
            record.setSourceClassName(((Object)((Object)StaxDataStore.this)).getClass().getCanonicalName());
            StaxDataStore.this.listeners.warning(record);
        }

        @Override
        public boolean isLoggable(LogRecord warning) {
            warning.setLoggerName(null);
            StaxDataStore.this.listeners.warning(warning);
            return false;
        }

        public String toString() {
            return Strings.toString(this.getClass(), (Object[])new Object[]{"locale", StaxDataStore.this.locale, "timezone", StaxDataStore.this.timezone});
        }
    }
}

