/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.internal.shared;

import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.image.internal.shared.ImageUtilities;

public final class FillValues {
    public final Object asPrimitiveArray;
    public final boolean isFullyZero;

    public FillValues(SampleModel model, Number[] values, boolean allowFloat) {
        long zeroFlag;
        int toCopy;
        int dataType = model.getDataType();
        int numBands = model.getNumBands();
        int n = toCopy = values != null ? Math.min(values.length, numBands) : 0;
        if (ImageUtilities.isIntegerType(dataType)) {
            int[] fill = new int[numBands];
            this.asPrimitiveArray = fill;
            zeroFlag = 0L;
            for (int i = 0; i < toCopy; ++i) {
                Number f = values[i];
                if (f == null) continue;
                fill[i] = f.intValue();
                zeroFlag |= (long)fill[i];
            }
        } else if (allowFloat && dataType == 4) {
            float[] fill = new float[numBands];
            Arrays.fill(fill, Float.NaN);
            this.asPrimitiveArray = fill;
            zeroFlag = toCopy ^ numBands;
            for (int i = 0; i < toCopy; ++i) {
                Number f = values[i];
                if (f != null) {
                    fill[i] = f.floatValue();
                    zeroFlag |= (long)Float.floatToRawIntBits(fill[i]);
                    continue;
                }
                zeroFlag = -1L;
            }
        } else {
            double[] fill = new double[numBands];
            Arrays.fill(fill, Double.NaN);
            this.asPrimitiveArray = fill;
            zeroFlag = toCopy ^ numBands;
            for (int i = 0; i < toCopy; ++i) {
                Number f = values[i];
                if (f != null) {
                    fill[i] = f.doubleValue();
                    zeroFlag |= Double.doubleToRawLongBits(fill[i]);
                    continue;
                }
                zeroFlag = -1L;
            }
        }
        this.isFullyZero = zeroFlag == 0L;
    }

    public void fill(WritableRaster tile) {
        int xmin = tile.getMinX();
        int width = tile.getWidth();
        int numBands = tile.getNumBands();
        int chunkWidth = Integer.highestOneBit(Math.max(Math.min(width * numBands, 256) / numBands, 1));
        Object chunk = Array.newInstance(this.asPrimitiveArray.getClass().getComponentType(), chunkWidth * numBands);
        System.arraycopy(this.asPrimitiveArray, 0, chunk, 0, Math.min(numBands, Array.getLength(this.asPrimitiveArray)));
        for (int p = 1; p < chunkWidth; p <<= 1) {
            int n = p * numBands;
            System.arraycopy(chunk, 0, chunk, n, n);
        }
        int y = tile.getMinY();
        if (chunk instanceof int[]) {
            tile.setPixels(xmin, y, chunkWidth, 1, (int[])chunk);
        } else if (chunk instanceof float[]) {
            tile.setPixels(xmin, y, chunkWidth, 1, (float[])chunk);
        } else {
            tile.setPixels(xmin, y, chunkWidth, 1, (double[])chunk);
        }
        chunk = tile.getDataElements(xmin, y, chunkWidth, 1, null);
        int ymax = y + tile.getHeight();
        int xmax = xmin + width;
        int x = xmin + chunkWidth;
        while (true) {
            int remaining;
            if ((remaining = xmax - x) > 0) {
                tile.setDataElements(x, y, Math.min(chunkWidth, remaining), 1, chunk);
                x += chunkWidth;
                continue;
            }
            x = xmin;
            if (++y >= ymax) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(WritableRenderedImage image) {
        int y = image.getMinTileY();
        int ny = image.getNumYTiles();
        while (--ny >= 0) {
            int x = image.getMinTileX();
            int nx = image.getNumXTiles();
            while (--nx >= 0) {
                WritableRaster raster = image.getWritableTile(x, y);
                try {
                    this.fill(raster);
                }
                finally {
                    image.releaseWritableTile(x, y);
                }
                ++x;
            }
            ++y;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof FillValues && Objects.deepEquals(this.asPrimitiveArray, ((FillValues)obj).asPrimitiveArray);
    }

    public int hashCode() {
        return ~Arrays.deepHashCode(new Object[]{this.asPrimitiveArray});
    }
}

