/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.CharSequences;

public final class LenientDateFormat
extends DateFormat {
    private static final OffsetTime MIDNIGHT = OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC);
    public static final DateTimeFormatter FORMAT = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().optionalStart().appendLiteral(' ').optionalEnd().appendZoneOrOffsetId().toFormatter(Locale.ROOT);
    private static TemporalQuery<?>[] QUERIES = new TemporalQuery[]{Instant::from, LocalDateTime::from, LocalDate::from, YearMonth::from, Year::from};
    private DateTimeFormatter format;
    private final DateTimeFormatter formatWithoutZone;

    public static Temporal parseBest(CharSequence text) {
        return text != null ? (Temporal)FORMAT.parseBest(LenientDateFormat.toISO(text, 0, text.length()), QUERIES) : null;
    }

    public static Instant parseInstantUTC(CharSequence text) {
        return text != null ? LenientDateFormat.parseInstantUTC(text, 0, text.length()) : null;
    }

    public static Instant parseInstantUTC(CharSequence text, int lower, int upper) {
        TemporalAccessor date = FORMAT.parseBest(LenientDateFormat.toISO(text, lower, upper), QUERIES);
        if (date instanceof Instant) {
            return (Instant)date;
        }
        OffsetDateTime time = date instanceof LocalDateTime ? ((LocalDateTime)date).atOffset(ZoneOffset.UTC) : ((LocalDate)date).atTime(MIDNIGHT);
        return time.toInstant();
    }

    static CharSequence toISO(CharSequence text, int lower, int upper) {
        int n;
        lower = CharSequences.skipLeadingWhitespaces((CharSequence)text, (int)lower, (int)upper);
        upper = CharSequences.skipTrailingWhitespaces((CharSequence)text, (int)lower, (int)upper);
        StringBuilder buffer = null;
        int cp = 0;
        for (int i = upper; i > lower; i -= n) {
            int c;
            block7: {
                boolean isDateTimeSeparator;
                int end;
                block8: {
                    c = Character.codePointBefore(text, i);
                    n = Character.charCount(c);
                    if (!Character.isWhitespace(c)) break block7;
                    end = i;
                    i = CharSequences.skipTrailingWhitespaces((CharSequence)text, (int)lower, (int)(i - n));
                    c = Character.codePointBefore(text, i);
                    n = Character.charCount(c);
                    isDateTimeSeparator = false;
                    if (!Character.isDigit(cp) || !Character.isDigit(c)) break block8;
                    boolean bl = isDateTimeSeparator = CharSequences.indexOf((CharSequence)text, (int)58, (int)lower, (int)upper) > end;
                    if (!isDateTimeSeparator) break block7;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(upper - lower).append(text, lower, upper);
                    text = buffer;
                    i -= lower;
                    end -= lower;
                    lower = 0;
                }
                if (isDateTimeSeparator) {
                    buffer.replace(i, end, "T");
                } else {
                    buffer.delete(i, end);
                }
                upper = buffer.length();
            }
            cp = c;
        }
        return text.subSequence(lower, upper);
    }

    public LenientDateFormat() {
        this.formatWithoutZone = this.format = FORMAT;
    }

    public LenientDateFormat(Locale locale) {
        this.formatWithoutZone = this.format = FORMAT.withLocale(locale);
    }

    public LenientDateFormat(Locale locale, TimeZone zone) {
        this(locale);
        if (!"UTC".equals(zone.getID())) {
            this.setTimeZone(zone);
        }
    }

    @Override
    public final Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.getTimeZone(), this.format.getLocale());
        }
        return this.calendar;
    }

    @Override
    public final NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance(this.format.getLocale());
        }
        return this.numberFormat;
    }

    private ZoneId getZone() {
        ZoneId zone = this.format.getZone();
        return zone != null ? zone : ZoneOffset.UTC;
    }

    @Override
    public final TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.getZone());
    }

    @Override
    public final void setTimeZone(TimeZone zone) {
        this.format = this.format.withZone(zone.toZoneId());
        if (this.calendar != null) {
            super.setTimeZone(zone);
        }
    }

    @Override
    public final void setLenient(boolean lenient) {
        this.getCalendar().setLenient(lenient);
    }

    @Override
    public final boolean isLenient() {
        return this.getCalendar().isLenient();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        LocalDateTime dt;
        Comparable<ChronoLocalDateTime<?>> value = dt = LocalDateTime.ofInstant(date.toInstant(), this.getZone());
        if (dt.getHour() == 0 && dt.getMinute() == 0 && dt.getSecond() == 0 && dt.getNano() == 0) {
            value = dt.toLocalDate();
        }
        this.formatWithoutZone.formatTo((TemporalAccessor)((Object)value), toAppendTo);
        return toAppendTo;
    }

    @Override
    public Date parse(String text, ParsePosition position) {
        try {
            return TemporalDate.toDate(TemporalDate.toInstant(this.format.parse((CharSequence)text, position), this.getZone()));
        }
        catch (ArithmeticException | DateTimeException e) {
            position.setErrorIndex(LenientDateFormat.getErrorIndex(e, position));
            return null;
        }
    }

    @Override
    public Date parse(String text) throws ParseException {
        try {
            return TemporalDate.toDate(TemporalDate.toInstant(this.format.parse(LenientDateFormat.toISO(text, 0, text.length())), this.getZone()));
        }
        catch (RuntimeException e) {
            throw (ParseException)new ParseException(e.getLocalizedMessage(), LenientDateFormat.getErrorIndex(e, null)).initCause(e);
        }
    }

    private static int getErrorIndex(RuntimeException e, ParsePosition position) {
        if (e instanceof DateTimeParseException) {
            return ((DateTimeParseException)e).getErrorIndex();
        }
        if (position != null) {
            return position.getIndex();
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return 31 * this.format.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof LenientDateFormat && this.format.equals(((LenientDateFormat)obj).format);
    }
}

