/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.PositionalAccuracyConstant;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.InverseOperationMethod;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlType(name="ConcatenatedOperationType")
@XmlRootElement(name="ConcatenatedOperation")
final class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    public static final String TRANSFORM_KEY = "transform";
    private static final ComparisonMode[] CRS_ORDER_CRITERIA = new ComparisonMode[]{ComparisonMode.BY_CONTRACT, ComparisonMode.IGNORE_METADATA, ComparisonMode.COMPATIBILITY, ComparisonMode.APPROXIMATE};
    private List<SingleOperation> operations;

    public DefaultConcatenatedOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperation[] operations, MathTransformFactory mtFactory) throws FactoryException {
        super(properties);
        if (operations.length < 2) {
            throw new InvalidGeodeticParameterException(Errors.forProperties(properties).getString((short)158, (Object)2, CoordinateOperation.class));
        }
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.transform = (MathTransform)Containers.property(properties, (Object)TRANSFORM_KEY, MathTransform.class);
        this.initialize(properties, operations, (MathTransformFactory)(this.transform == null ? mtFactory : null));
        this.checkDimensions(properties);
    }

    private void initialize(Map<String, ?> properties, CoordinateOperation[] operations, MathTransformFactory mtFactory) throws FactoryException {
        ArrayList<CoordinateOperation> flattened = new ArrayList<CoordinateOperation>(operations.length);
        CoordinateReferenceSystem crs = this.initialize(properties, operations, flattened, mtFactory, this.sourceCRS, this.sourceCRS == null, this.coordinateOperationAccuracy == null);
        if (this.targetCRS == null) {
            this.targetCRS = crs;
        } else if (mtFactory != null) {
            MathTransformBuilder builder = CoordinateOperations.builder(mtFactory, "Coordinate system conversion");
            builder.setSourceAxes(crs.getCoordinateSystem(), DatumOrEnsemble.getEllipsoid(crs).orElse(null));
            builder.setTargetAxes(this.targetCRS.getCoordinateSystem(), null);
            this.transform = mtFactory.createConcatenatedTransform(this.transform, builder.create());
        }
        this.operations = UnmodifiableArrayList.wrap((Object[])((SingleOperation[])flattened.toArray(SingleOperation[]::new)));
    }

    private CoordinateReferenceSystem initialize(Map<String, ?> properties, CoordinateOperation[] operations, List<CoordinateOperation> flattened, MathTransformFactory mtFactory, CoordinateReferenceSystem previous, boolean setSource, boolean setAccuracy) throws FactoryException {
        CoordinateReferenceSystem target = null;
        for (int i = 0; i < operations.length; ++i) {
            CoordinateOperation op = operations[i];
            ArgumentChecks.ensureNonNullElement((String)"operations", (int)i, (Object)op);
            CoordinateReferenceSystem source = op.getSourceCRS();
            target = op.getTargetCRS();
            boolean inverse = DefaultConcatenatedOperation.verifyStepChaining(properties, i, previous, source, target);
            if (inverse) {
                CoordinateOperation natural;
                CoordinateReferenceSystem t = source;
                source = target;
                target = t;
                if (CoordinateOperations.getMethod(op) instanceof InverseOperationMethod && (natural = DefaultConcatenatedOperation.getCachedInverse(op)) != null) {
                    op = natural;
                }
            }
            if (setSource) {
                setSource = false;
                this.sourceCRS = source;
            }
            NoninvertibleTransformException cause = null;
            MathTransform step = op.getMathTransform();
            if (step != null && inverse) {
                try {
                    step = step.inverse();
                }
                catch (NoninvertibleTransformException e) {
                    step = null;
                    cause = e;
                }
            }
            if (step == null) {
                throw new InvalidGeodeticParameterException(Resources.format((short)43, op.getClass(), op.getName()), cause);
            }
            if (op instanceof ConcatenatedOperation) {
                CoordinateOperation[] nested = (CoordinateOperation[])((ConcatenatedOperation)op).getOperations().toArray(CoordinateOperation[]::new);
                previous = this.initialize(properties, nested, flattened, null, previous, false, setAccuracy);
            } else {
                if (!step.isIdentity()) {
                    flattened.add(op);
                }
                previous = target;
            }
            if (mtFactory != null) {
                MathTransform mathTransform = this.transform = this.transform != null ? mtFactory.createConcatenatedTransform(this.transform, step) : step;
            }
            if (!setAccuracy || !(op instanceof Transformation) && !(op instanceof ConcatenatedOperation) || PositionalAccuracyConstant.getLinearAccuracy(op) == 0.0) continue;
            if (this.coordinateOperationAccuracy == null) {
                this.coordinateOperationAccuracy = op.getCoordinateOperationAccuracy();
                continue;
            }
            this.coordinateOperationAccuracy = null;
            setAccuracy = false;
        }
        if (mtFactory != null) {
            DefaultConcatenatedOperation.verifyStepChaining(properties, operations.length, target, this.targetCRS, null);
        }
        return previous;
    }

    static boolean verifyStepChaining(Map<String, ?> properties, int step, CoordinateReferenceSystem previous, CoordinateReferenceSystem source, CoordinateReferenceSystem target) throws FactoryException {
        if (previous == null || source == null) {
            return false;
        }
        for (ComparisonMode mode : CRS_ORDER_CRITERIA) {
            if (Utilities.deepEquals((Object)previous, (Object)source, (ComparisonMode)mode)) {
                return false;
            }
            if (!Utilities.deepEquals((Object)previous, (Object)target, (ComparisonMode)mode)) continue;
            return true;
        }
        Resources resources = Resources.forProperties(properties);
        Locale locale = resources.getLocale();
        throw new InvalidGeodeticParameterException(resources.getString((short)100, step, IdentifiedObjects.getDisplayName((IdentifiedObject)previous, locale), IdentifiedObjects.getDisplayName((IdentifiedObject)source, locale)));
    }

    protected DefaultConcatenatedOperation(ConcatenatedOperation operation) {
        super((CoordinateOperation)operation);
        this.operations = operation.getOperations();
    }

    public static DefaultConcatenatedOperation castOrCopy(ConcatenatedOperation object) {
        return object == null || object instanceof DefaultConcatenatedOperation ? (DefaultConcatenatedOperation)object : new DefaultConcatenatedOperation(object);
    }

    public Class<? extends ConcatenatedOperation> getInterface() {
        return ConcatenatedOperation.class;
    }

    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                return Objects.equals(this.operations, ((DefaultConcatenatedOperation)object).operations);
            }
            return Utilities.deepEquals(this.getOperations(), (Object)((ConcatenatedOperation)object).getOperations(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(37 * Objects.hashCode(this.operations));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        for (final CoordinateOperation coordinateOperation : this.operations) {
            formatter.newLine();
            formatter.append(new FormattableObject(this){
                final /* synthetic */ DefaultConcatenatedOperation this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected String formatTo(Formatter formatter) {
                    formatter.newLine();
                    formatter.appendFormattable(coordinateOperation, AbstractCoordinateOperation::castOrCopy);
                    return "Step";
                }
            });
        }
        WKTUtilities.appendElementIfPositive("OperationAccuracy", this.getLinearAccuracy(), formatter);
        if (!formatter.getConvention().supports(Convention.WKT2_2019)) {
            formatter.setInvalidWKT(this, null);
        }
        return "ConcatenatedOperation";
    }

    private DefaultConcatenatedOperation() {
        this.operations = List.of();
    }

    @XmlElement(name="coordOperation", required=true)
    private CoordinateOperation[] getSteps() {
        List<SingleOperation> operations = this.getOperations();
        return operations != null ? (CoordinateOperation[])operations.toArray(CoordinateOperation[]::new) : null;
    }

    private void setSteps(CoordinateOperation[] steps) throws FactoryException {
        this.initialize(null, steps, DefaultMathTransformFactory.provider());
    }
}

