/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.esri;

import java.awt.image.BandedSampleModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.coverage.internal.shared.RangeArgument;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.esri.AsciiGridStoreProvider;
import org.apache.sis.storage.esri.CharactersView;
import org.apache.sis.storage.esri.RasterStore;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

class AsciiGridStore
extends RasterStore {
    static final String XLLCORNER = "XLLCORNER";
    static final String YLLCORNER = "YLLCORNER";
    static final String XLLCENTER = "XLLCENTER";
    static final String YLLCENTER = "YLLCENTER";
    static final String CELLSIZE = "CELLSIZE";
    static final String NODATA_VALUE = "NODATA_VALUE";
    static final String[] CELLSIZES = new String[]{"XCELLSIZE", "YCELLSIZE", "XDIM", "YDIM", "DX", "DY"};
    private static final double DEFAULT_NODATA = -9999.0;
    private volatile CharactersView input;
    private int width;
    private int height;
    private String nodataText;
    private GridGeometry gridGeometry;
    private GridCoverage coverage;

    AsciiGridStore(AsciiGridStoreProvider provider, StorageConnector connector, boolean readOnly) throws DataStoreException {
        super(provider, connector);
        ChannelDataInput channel;
        if (readOnly) {
            channel = connector.commit(ChannelDataInput.class, "ASCII Grid");
        } else {
            channel = connector.getStorageAs(ChannelDataInput.class);
            if (channel != null) {
                connector.closeAllExcept(channel);
            }
        }
        if (channel != null) {
            this.input = new CharactersView(channel, channel.buffer);
        }
    }

    boolean canReadOrWrite(boolean write) {
        return !write && this.input != null;
    }

    private void readHeader() throws DataStoreException {
        if (this.gridGeometry == null) {
            try {
                Map<String, String> header = this.input().readHeader();
                Matrix3 gridToCRS = new Matrix3();
                PixelInCell anchor = PixelInCell.CELL_CORNER;
                String key = null;
                try {
                    boolean yCenter;
                    boolean xCenter;
                    String value;
                    block21: {
                        key = "NCOLS";
                        this.width = Integer.parseInt(this.getHeaderValue(header, "NCOLS"));
                        key = "NROWS";
                        this.height = Integer.parseInt(this.getHeaderValue(header, "NROWS"));
                        key = CELLSIZE;
                        value = header.remove(CELLSIZE);
                        if (value != null) {
                            gridToCRS.m00 = Double.parseDouble(value);
                            gridToCRS.m11 = -gridToCRS.m00;
                        } else {
                            int def = 0;
                            int i = 0;
                            while (i < CELLSIZES.length) {
                                if ((value = header.remove(key = CELLSIZES[i++])) != null) {
                                    gridToCRS.m00 = Double.parseDouble(value);
                                    def |= 1;
                                }
                                if ((value = header.remove(key = CELLSIZES[i++])) != null) {
                                    gridToCRS.m11 = -Double.parseDouble(value);
                                    def |= 2;
                                }
                                if (def != 3) continue;
                                break block21;
                            }
                            throw new DataStoreContentException(this.messageForProperty((short)112, CELLSIZE));
                        }
                    }
                    key = XLLCENTER;
                    value = header.remove(XLLCENTER);
                    boolean bl = xCenter = value != null;
                    if (!xCenter) {
                        key = XLLCORNER;
                        value = this.getHeaderValue(header, XLLCORNER);
                    }
                    gridToCRS.m02 = Double.parseDouble(value);
                    key = YLLCENTER;
                    value = header.remove(YLLCENTER);
                    boolean bl2 = yCenter = value != null;
                    if (!yCenter) {
                        key = YLLCORNER;
                        value = this.getHeaderValue(header, YLLCORNER);
                    }
                    gridToCRS.m12 = Double.parseDouble(value) - gridToCRS.m11 * (double)this.height;
                    if (xCenter & yCenter) {
                        anchor = PixelInCell.CELL_CENTER;
                    } else if (xCenter != yCenter) {
                        gridToCRS.convertBefore(xCenter ? 0 : 1, null, (Number)-0.5);
                    }
                    key = NODATA_VALUE;
                    this.nodataText = header.remove(NODATA_VALUE);
                    if (this.nodataText != null) {
                        try {
                            this.nodataValue = Double.parseDouble(this.nodataText);
                        }
                        catch (NumberFormatException e) {
                            this.nodataValue = Double.NaN;
                            this.listeners.warning(this.messageForProperty((short)75, key), e);
                        }
                    } else {
                        this.nodataValue = -9999.0;
                        this.nodataText = "null";
                    }
                }
                catch (NumberFormatException e) {
                    throw new DataStoreContentException(this.messageForProperty((short)75, key), e);
                }
                this.readPRJ(AsciiGridStore.class, "getGridGeometry");
                this.gridGeometry = new GridGeometry(new GridExtent((long)this.width, (long)this.height), anchor, (MathTransform)MathTransforms.linear((Matrix)gridToCRS), this.crs);
                if (!header.isEmpty()) {
                    StringJoiner joiner = new StringJoiner(", ");
                    header.keySet().forEach(joiner::add);
                    this.listeners.warning(this.messageForProperty((short)173, joiner.toString()));
                }
            }
            catch (DataStoreException e) {
                this.closeOnError(e);
                throw e;
            }
            catch (Exception e) {
                this.closeOnError(e);
                throw new DataStoreException(e);
            }
        }
    }

    private String messageForProperty(short rk, String key) {
        return Errors.forLocale((Locale)this.getLocale()).getString(rk, (Object)this.input.input.filename, (Object)key);
    }

    private String getHeaderValue(Map<String, String> header, String key) throws DataStoreException {
        String value = header.remove(key);
        if (value == null) {
            throw new DataStoreContentException(this.messageForProperty((short)112, key));
        }
        return value;
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.createMetadata("ASCII Grid", "ASCGRD");
        }
        return this.metadata;
    }

    @Override
    public synchronized GridGeometry getGridGeometry() throws DataStoreException {
        this.readHeader();
        return this.gridGeometry;
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.read(null, null).getSampleDimensions();
    }

    @Override
    public synchronized GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        RangeArgument bands = RangeArgument.validate((int)1, (int[])ranges, (Localized)this.listeners);
        if (this.coverage == null) {
            try {
                this.readHeader();
                CharactersView view = this.input();
                String filename = view.input.filename;
                Statistics stats = new Statistics((CharSequence)filename);
                float[] data = new float[this.width * this.height];
                for (int i = 0; i < data.length; ++i) {
                    double value;
                    String token = view.readToken();
                    try {
                        value = Double.parseDouble(token);
                        if (value == this.nodataValue) {
                            value = Double.NaN;
                        }
                    }
                    catch (NumberFormatException e) {
                        if (token.equalsIgnoreCase(this.nodataText)) {
                            value = Double.NaN;
                        }
                        throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)68, i % this.width, i / this.width, filename), e);
                    }
                    data[i] = (float)value;
                    stats.accept(value);
                }
                if (!this.canReadOrWrite(true)) {
                    this.input = null;
                    view.input.channel.close();
                }
                BandedSampleModel sm = new BandedSampleModel(4, this.width, this.height, 1);
                this.loadBandDescriptions(filename, sm, stats);
                DataBufferFloat buffer = new DataBufferFloat(data, data.length);
                WritableRaster raster = WritableRaster.createWritableRaster(sm, buffer, null);
                this.coverage = this.createCoverage(this.gridGeometry, bands, raster, stats);
            }
            catch (DataStoreException e) {
                this.closeOnError(e);
                throw e;
            }
            catch (Exception e) {
                this.closeOnError(e);
                throw new DataStoreException(e);
            }
        }
        return this.coverage;
    }

    final Number setCoverage(GridCoverage replacement, RenderedImage data, int band) {
        this.coverage = replacement;
        this.gridGeometry = replacement.getGridGeometry();
        this.crs = this.gridGeometry.isDefined(1) ? this.gridGeometry.getCoordinateReferenceSystem() : null;
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.metadata = null;
        this.nodataText = "null";
        this.nodataValue = Double.NaN;
        SampleDimension sd = (SampleDimension)replacement.getSampleDimensions().get(band);
        NumberRange range = sd.getSampleRange().orElse(null);
        if (range != null) {
            try {
                for (Number nodata : sd.forConvertedValues(false).getNoDataValues()) {
                    if (range.containsAny(nodata)) continue;
                    this.nodataValue = nodata.doubleValue();
                    return nodata;
                }
            }
            catch (IllegalStateException e) {
                this.listeners.warning(e);
            }
            if (range.containsAny((Number)-9999.0)) {
                this.nodataValue = -9999.0;
            }
        }
        return this.nodataValue;
    }

    final CharactersView input() throws DataStoreException {
        CharactersView in = this.input;
        if (in == null) {
            throw new DataStoreClosedException(this.getLocale(), "ASCII Grid", StandardOpenOption.READ);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DataStoreException {
        try {
            this.listeners.close();
            CharactersView view = this.input;
            if (view != null) {
                view.input.channel.close();
            }
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        finally {
            AsciiGridStore asciiGridStore = this;
            synchronized (asciiGridStore) {
                super.close();
                this.gridGeometry = null;
                this.coverage = null;
                this.input = null;
            }
        }
    }

    final void closeOnError(Throwable e) {
        try {
            this.close();
        }
        catch (Throwable s) {
            e.addSuppressed(s);
        }
    }
}

