/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.jcr.internal;

import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import org.apache.sling.clam.internal.ClamUtil;
import org.apache.sling.clam.jcr.NodeDescendingJcrPropertyDigger;
import org.apache.sling.event.jobs.JobManager;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={NodeDescendingJcrPropertyDigger.class}, property={"service.description=Apache Sling Clam Default Node Descending JCR Property Digger", "service.vendor=The Apache Software Foundation"})
public class DefaultNodeDescendingJcrPropertyDigger
implements NodeDescendingJcrPropertyDigger {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile JobManager jobManager;
    private final Logger logger = LoggerFactory.getLogger(DefaultNodeDescendingJcrPropertyDigger.class);

    @Override
    public void dig(@NotNull Node node, @NotNull Pattern pattern, @NotNull Set<Integer> propertyTypes, long maxLength, int maxDepth) throws Exception {
        int absoluteMaxDepth = maxDepth < 0 ? -1 : node.getDepth() + maxDepth;
        this._dig(node, pattern, propertyTypes, maxLength, absoluteMaxDepth);
    }

    private void _dig(@NotNull Node node, @NotNull Pattern pattern, @NotNull Set<Integer> propertyTypes, long maxLength, int maxDepth) throws Exception {
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            int propertyType = property.getType();
            String path = property.getPath();
            if (!propertyTypes.contains(propertyType) || !pattern.matcher(path).matches()) continue;
            if (property.isMultiple()) {
                long[] lengths = property.getLengths();
                for (int index = 0; index < lengths.length; ++index) {
                    long length = lengths[index];
                    if (ClamUtil.checkLength(length, maxLength)) {
                        this.jobManager.addJob(ClamUtil.scanJobTopic(propertyType), ClamUtil.properties(path, index, null));
                        continue;
                    }
                    this.logger.warn("Length of property '{}' [{}] greater than given max length ({}).", new Object[]{path, index, maxLength});
                }
                continue;
            }
            if (ClamUtil.checkLength(property.getLength(), maxLength)) {
                this.jobManager.addJob(ClamUtil.scanJobTopic(propertyType), ClamUtil.properties(path, null));
                continue;
            }
            this.logger.warn("Length of property '{}' greater than given max length ({}).", (Object)path, (Object)maxLength);
        }
        if (maxDepth == -1 || node.getDepth() < maxDepth) {
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                this._dig(nodes.nextNode(), pattern, propertyTypes, maxLength, maxDepth);
            }
        }
    }
}

