/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.mdc.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.MDC;

class SlingMDCFilter
implements Filter {
    public static final String SLING_USER = "sling.userId";
    public static final String JCR_SESSION_ID = "jcr.sessionId";
    private static final String[] DEFAULT_KEY_NAMES = new String[]{"sling.userId"};

    SlingMDCFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SlingHttpServletRequest request = (SlingHttpServletRequest)servletRequest;
        try {
            this.insertIntoMDC(request);
            filterChain.doFilter((ServletRequest)request, servletResponse);
        }
        finally {
            this.clearMDC();
        }
    }

    private void clearMDC() {
        for (String key : DEFAULT_KEY_NAMES) {
            MDC.remove((String)key);
        }
    }

    private void insertIntoMDC(SlingHttpServletRequest request) {
        ResourceResolver rr = request.getResourceResolver();
        if (rr.getUserID() != null) {
            MDC.put((String)SLING_USER, (String)rr.getUserID());
        }
    }

    public void destroy() {
    }
}

