/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.utils.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sling.feature.io.impl.felix.utils.collections.StringArrayMap;
import org.apache.sling.feature.io.impl.felix.utils.resource.CapabilityImpl;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResourceImpl
implements Resource {
    protected final List<Capability> caps;
    protected final List<Requirement> reqs;

    public ResourceImpl() {
        this.caps = new ArrayList<Capability>(0);
        this.reqs = new ArrayList<Requirement>(0);
    }

    public ResourceImpl(String name, String type, Version version) {
        this.caps = new ArrayList<Capability>(1);
        StringArrayMap<String> dirs = new StringArrayMap<String>(0);
        StringArrayMap<Object> attrs = new StringArrayMap<Object>(3);
        attrs.put("osgi.identity", (Object)name);
        attrs.put("type", (Object)type);
        attrs.put("version", (Object)version);
        CapabilityImpl identity = new CapabilityImpl(this, "osgi.identity", dirs, attrs);
        this.caps.add(identity);
        this.reqs = new ArrayList<Requirement>(0);
    }

    public void addCapability(Capability capability) {
        assert (capability.getResource() == this);
        this.caps.add(capability);
    }

    public void addCapabilities(Collection<? extends Capability> capabilities) {
        for (Capability capability : capabilities) {
            assert (capability.getResource() == this);
        }
        this.caps.addAll(capabilities);
    }

    public void addRequirement(Requirement requirement) {
        assert (requirement.getResource() == this);
        this.reqs.add(requirement);
    }

    public void addRequirements(Collection<? extends Requirement> requirements) {
        for (Requirement requirement : requirements) {
            assert (requirement.getResource() == this);
        }
        this.reqs.addAll(requirements);
    }

    public List<Capability> getCapabilities(String namespace) {
        List<Capability> result = this.caps;
        if (namespace != null) {
            result = new ArrayList<Capability>();
            for (Capability cap : this.caps) {
                if (!cap.getNamespace().equals(namespace)) continue;
                result.add(cap);
            }
        }
        return result;
    }

    public List<Requirement> getRequirements(String namespace) {
        List<Requirement> result = this.reqs;
        if (namespace != null) {
            result = new ArrayList<Requirement>();
            for (Requirement req : this.reqs) {
                if (!req.getNamespace().equals(namespace)) continue;
                result.add(req);
            }
        }
        return result;
    }

    public String toString() {
        for (Capability cap : this.caps) {
            if (!"osgi.identity".equals(cap.getNamespace())) continue;
            return cap.getAttributes().get("osgi.identity") + "/" + cap.getAttributes().get("version");
        }
        return "Unidentified resource";
    }
}

