/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.Mounter;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.impl.AggregateManagerImpl;
import org.apache.jackrabbit.vault.fs.io.AbstractExporter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.JarExporter;
import org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageManagerImpl
implements PackageManager {
    @Nullable
    private PackageEventDispatcher dispatcher;

    @Override
    @NotNull
    public VaultPackage open(@NotNull Archive archive) throws IOException {
        return new ZipVaultPackage(archive, false);
    }

    @Override
    @NotNull
    public VaultPackage open(@NotNull Archive archive, boolean strict) throws IOException {
        return new ZipVaultPackage(archive, strict);
    }

    @Override
    public VaultPackage open(File file) throws IOException {
        return this.open(file, false);
    }

    @Override
    public VaultPackage open(File file, boolean strict) throws IOException {
        return new ZipVaultPackage(file, false, strict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultPackage assemble(Session s, ExportOptions opts, File file) throws IOException, RepositoryException {
        ZipVaultPackage zipVaultPackage;
        FileOutputStream out = null;
        boolean isTmp = false;
        boolean success = false;
        try {
            if (file == null) {
                file = File.createTempFile("filevault", ".zip");
                isTmp = true;
            }
            out = FileUtils.openOutputStream(file);
            this.assemble(s, opts, out);
            IOUtils.closeQuietly(out);
            success = true;
            zipVaultPackage = new ZipVaultPackage(file, isTmp);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            if (isTmp && !success) {
                FileUtils.deleteQuietly(file);
            }
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        if (isTmp && !success) {
            FileUtils.deleteQuietly(file);
        }
        return zipVaultPackage;
    }

    @Override
    public void assemble(Session s, ExportOptions opts, OutputStream out) throws IOException, RepositoryException {
        try (JarExporter exporter = new JarExporter(out, opts.getCompressionLevel());){
            RepositoryAddress addr;
            try {
                String mountPath = opts.getMountPath();
                if (mountPath == null || mountPath.length() == 0) {
                    mountPath = "/";
                }
                addr = new RepositoryAddress("/" + s.getWorkspace().getName() + mountPath);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            MetaInf metaInf = opts.getMetaInf();
            if (metaInf == null) {
                metaInf = new DefaultMetaInf();
            }
            VaultFsConfig config = metaInf.getConfig();
            if (metaInf.getProperties() != null && "true".equals(metaInf.getProperties().getProperty("useBinaryReferences"))) {
                config = AggregateManagerImpl.getDefaultBinaryReferencesConfig();
            }
            VaultFileSystem jcrfs = Mounter.mount(config, metaInf.getFilter(), addr, opts.getRootPath(), s);
            exporter.setProperties(metaInf.getProperties());
            if (opts.getListener() != null) {
                exporter.setVerbose(opts.getListener());
            }
            exporter.export(jcrfs.getRoot(), true);
            if (opts.getPostProcessor() != null) {
                opts.getPostProcessor().process(exporter);
            }
            jcrfs.unmount();
        }
    }

    @Override
    public VaultPackage rewrap(ExportOptions opts, VaultPackage src, File file) throws IOException, RepositoryException {
        boolean isTmp = false;
        boolean success = false;
        if (file == null) {
            file = File.createTempFile("filevault", ".zip");
            isTmp = true;
        }
        try {
            ZipVaultPackage zipVaultPackage;
            block11: {
                FileOutputStream out = FileUtils.openOutputStream(file);
                try {
                    this.rewrap(opts, src, out);
                    success = true;
                    ZipVaultPackage pack = new ZipVaultPackage(file, isTmp);
                    this.dispatch(PackageEvent.Type.REWRAPP, pack.getId(), null);
                    zipVaultPackage = pack;
                    if (out == null) break block11;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((OutputStream)out).close();
            }
            return zipVaultPackage;
        }
        finally {
            if (isTmp && !success) {
                FileUtils.deleteQuietly(file);
            }
        }
    }

    @Override
    public void rewrap(ExportOptions opts, VaultPackage src, OutputStream out) throws IOException {
        try (JarExporter exporter = new JarExporter(out, opts.getCompressionLevel());){
            Set<String> metaInfIncludes;
            MetaInf inf;
            MetaInf metaInf = opts.getMetaInf();
            if (metaInf == null) {
                metaInf = new DefaultMetaInf();
            }
            exporter.open();
            exporter.setProperties(metaInf.getProperties());
            ProgressTracker tracker = null;
            if (opts.getListener() != null) {
                tracker = new ProgressTracker();
                exporter.setVerbose(opts.getListener());
            }
            if ((inf = opts.getMetaInf()) == null || inf.getProperties() == null) {
                throw new IllegalArgumentException("The export options didn't set the mandatory properties");
            }
            HashSet<String> metaInfExcludes = new HashSet<String>();
            if (opts.getPostProcessor() == null) {
                metaInfIncludes = Collections.emptySet();
                metaInfExcludes.add("META-INF/vault/properties.xml");
            } else {
                metaInfIncludes = new HashSet();
                metaInfIncludes.add("META-INF/vault/");
                metaInfIncludes.add("META-INF/vault/nodetypes.cnd");
                metaInfIncludes.add("META-INF/vault/config.xml");
                metaInfIncludes.add("META-INF/vault/filter.xml");
            }
            if (inf.getFilter() != null) {
                metaInfExcludes.add("META-INF/vault/filter.xml");
            }
            try (Archive archive = src.getArchive();){
                archive.open(false);
                PackageManagerImpl.addArchiveEntryToExporter(exporter, archive, "", archive.getRoot(), metaInfIncludes, metaInfExcludes);
            }
            ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
            inf.getProperties().storeToXML((OutputStream)tmpOut, "FileVault Package Properties", "utf-8");
            exporter.writeFile(new ByteArrayInputStream(tmpOut.toByteArray()), "META-INF/vault/properties.xml");
            if (tracker != null) {
                tracker.track("A", "META-INF/vault/properties.xml");
            }
            if (inf.getFilter() != null) {
                try (InputStream filterStream = inf.getFilter().getSource();){
                    exporter.writeFile(filterStream, "META-INF/vault/filter.xml");
                }
            }
            if (opts.getPostProcessor() != null) {
                opts.getPostProcessor().process(exporter);
            }
        }
    }

    private static void addArchiveEntryToExporter(AbstractExporter exporter, Archive archive, String parentPath, Archive.Entry entry, Set<String> metaInfIncludes, Set<String> metaInfExcludes) throws IOException {
        String path = parentPath + entry.getName();
        if (path.startsWith("META-INF/") && (!metaInfIncludes.isEmpty() && !metaInfIncludes.contains(path) || metaInfExcludes.contains(path))) {
            return;
        }
        if (entry.isDirectory()) {
            exporter.createDirectory(path);
            for (Archive.Entry entry2 : entry.getChildren()) {
                PackageManagerImpl.addArchiveEntryToExporter(exporter, archive, path.isEmpty() ? path : path + "/", entry2, metaInfIncludes, metaInfExcludes);
            }
        } else {
            try (InputStream input = archive.openInputStream(entry);){
                exporter.writeFile(input, path);
            }
        }
    }

    @Nullable
    PackageEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(@Nullable PackageEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    void dispatch(@NotNull PackageEvent.Type type, @NotNull PackageId id, @Nullable PackageId[] related) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.dispatch(type, id, related);
    }
}

