/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.jcr.jackrabbit.server.impl.security.PluggableDefaultAccessManager;
import org.apache.sling.jcr.jackrabbit.server.security.accessmanager.AccessManagerPluginFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessManagerFactoryTracker
extends ServiceTracker {
    private AccessManagerPluginFactory factory;
    private BundleContext bundleContext;
    private Set<PluggableDefaultAccessManager> consumers = new HashSet<PluggableDefaultAccessManager>();
    private static final Logger log = LoggerFactory.getLogger(AccessManagerFactoryTracker.class);

    public AccessManagerFactoryTracker(BundleContext bundleContext) {
        super(bundleContext, AccessManagerPluginFactory.class.getName(), null);
        this.bundleContext = bundleContext;
    }

    public Object addingService(ServiceReference serviceReference) {
        log.info("AccessManager service added.");
        this.closeSessions();
        this.factory = (AccessManagerPluginFactory)this.bundleContext.getService(serviceReference);
        return super.addingService(serviceReference);
    }

    public void removedService(ServiceReference serviceReference, Object o) {
        log.warn("AccessManager service removed.");
        this.factory = null;
        this.closeSessions();
        super.removedService(serviceReference, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSessions() {
        HashSet<PluggableDefaultAccessManager> closing;
        log.warn("Closing all sessions");
        Set<PluggableDefaultAccessManager> set = this.consumers;
        synchronized (set) {
            closing = new HashSet<PluggableDefaultAccessManager>(this.consumers);
        }
        for (PluggableDefaultAccessManager consumer : closing) {
            try {
                consumer.endSession();
            }
            catch (Throwable throwable) {
                log.warn("Error closing a PluggableDefaultAccessManager", throwable);
            }
        }
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
        log.debug("AccessManager service modified.");
        super.modifiedService(serviceReference, o);
        this.factory = (AccessManagerPluginFactory)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessManagerPluginFactory getFactory(PluggableDefaultAccessManager consumer) {
        log.debug("Registering PluggableDefaultAccessManager instance");
        Set<PluggableDefaultAccessManager> set = this.consumers;
        synchronized (set) {
            this.consumers.add(consumer);
        }
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PluggableDefaultAccessManager consumer) {
        log.debug("Unregistering PluggableDefaultAccessManager instance");
        Set<PluggableDefaultAccessManager> set = this.consumers;
        synchronized (set) {
            this.consumers.remove(consumer);
        }
    }
}

