/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableOperation.class);
    int backoffBase;
    int maxRetries;
    int jitter;
    Random random = new Random();
    int retryCount = 0;

    RetryableOperation(int backoff, int maxRetries, int jitter) {
        this.backoffBase = backoff;
        this.maxRetries = maxRetries;
        this.jitter = jitter;
    }

    public RetryableOperationResult apply(Supplier<RetryableOperationResult> operation, String logMessage) {
        RetryableOperationResult result = operation.get();
        while (!result.isSuccessful() && result.shouldRetry() && this.retryCount < this.maxRetries) {
            ++this.retryCount;
            LOG.info("{} (retry {}/{})", new Object[]{logMessage, this.retryCount, this.maxRetries});
            this.delay(this.retryCount);
            result = operation.get();
        }
        return result;
    }

    private void delay(int retryCount) {
        int j = this.random.nextInt(this.jitter);
        int delayInMilis = this.backoffBase * retryCount + j;
        try {
            TimeUnit.MILLISECONDS.sleep(delayInMilis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static class RetryableOperationResult {
        final boolean successful;
        final boolean shouldRetry;
        final String reference;
        final Exception failureTrace;

        RetryableOperationResult(boolean successful, boolean shouldRetry, String reference, Exception trace) {
            this.successful = successful;
            this.shouldRetry = shouldRetry;
            this.reference = reference;
            this.failureTrace = trace;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean shouldRetry() {
            return this.shouldRetry;
        }

        public String getReference() {
            return this.reference;
        }

        public Exception getFailureTrace() {
            return this.failureTrace;
        }
    }

    public static class Builder {
        int exponentialBackoff = 1000;
        int maxRetries = 3;
        int jitter = 200;

        Builder withBackoffBaseMsec(int msec) {
            this.exponentialBackoff = msec;
            return this;
        }

        Builder withMaxRetries(int retries) {
            this.maxRetries = retries;
            return this;
        }

        Builder withJitterMsec(int msec) {
            this.jitter = msec;
            return this;
        }

        RetryableOperation build() {
            return new RetryableOperation(this.exponentialBackoff, this.maxRetries, this.jitter);
        }
    }
}

