/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=2147483647"}, service={Injector.class, StaticInjectAnnotationProcessorFactory.class, AcceptsNullName.class})
public final class SlingObjectInjector
implements Injector,
StaticInjectAnnotationProcessorFactory,
AcceptsNullName {
    @NotNull
    public static final String NAME = "sling-object";

    @NotNull
    public String getName() {
        return NAME;
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type type, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class requestedClass = (Class)type;
        SlingJakartaHttpServletRequest jakartaRequest = null;
        Supplier<SlingHttpServletRequest> javaxRequestSupplier = null;
        if (adaptable instanceof SlingJakartaHttpServletRequest) {
            SlingJakartaHttpServletRequest jr;
            jakartaRequest = jr = (SlingJakartaHttpServletRequest)adaptable;
            javaxRequestSupplier = () -> JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)jr);
        } else if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest r = (SlingHttpServletRequest)adaptable;
            jakartaRequest = JavaxToJakartaRequestWrapper.toJakartaRequest((SlingHttpServletRequest)r);
            javaxRequestSupplier = () -> r;
        }
        if (jakartaRequest != null) {
            if (requestedClass.equals(ResourceResolver.class)) {
                return jakartaRequest.getResourceResolver();
            }
            if (requestedClass.equals(Resource.class) && element.isAnnotationPresent(SlingObject.class)) {
                return jakartaRequest.getResource();
            }
            if (requestedClass.equals(SlingJakartaHttpServletRequest.class) || requestedClass.equals(HttpServletRequest.class)) {
                return jakartaRequest;
            }
            if (requestedClass.equals(SlingJakartaHttpServletResponse.class) || requestedClass.equals(jakarta.servlet.http.HttpServletResponse.class)) {
                return this.getScriptHelperItem(jakartaRequest, SlingScriptHelper::getJakartaResponse);
            }
            if (requestedClass.equals(SlingHttpServletRequest.class) || requestedClass.equals(javax.servlet.http.HttpServletRequest.class)) {
                return javaxRequestSupplier.get();
            }
            if (requestedClass.equals(SlingHttpServletResponse.class) || requestedClass.equals(HttpServletResponse.class)) {
                return this.getScriptHelperItem(jakartaRequest, SlingScriptHelper::getResponse);
            }
            if (requestedClass.equals(SlingScriptHelper.class)) {
                return this.getSlingJakartaScriptHelper(jakartaRequest);
            }
        } else if (adaptable instanceof ResourceResolver) {
            ResourceResolver resourceResolver = (ResourceResolver)adaptable;
            if (requestedClass.equals(ResourceResolver.class)) {
                return resourceResolver;
            }
        } else if (adaptable instanceof Resource) {
            Resource resource = (Resource)adaptable;
            if (requestedClass.equals(ResourceResolver.class)) {
                return resource.getResourceResolver();
            }
            if (requestedClass.equals(Resource.class) && element.isAnnotationPresent(SlingObject.class)) {
                return resource;
            }
        }
        return null;
    }

    private SlingScriptHelper getSlingJakartaScriptHelper(SlingJakartaHttpServletRequest request) {
        SlingScriptHelper value = null;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        if (bindings != null) {
            value = bindings.getSling();
        }
        return value;
    }

    private <T> T getScriptHelperItem(SlingJakartaHttpServletRequest request, Function<SlingScriptHelper, T> fn) {
        T value = null;
        SlingScriptHelper scriptHelper = this.getSlingJakartaScriptHelper(request);
        if (scriptHelper != null) {
            value = fn.apply(scriptHelper);
        }
        return value;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(AnnotatedElement element) {
        SlingObject annotation = element.getAnnotation(SlingObject.class);
        if (annotation != null) {
            return new SlingObjectAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class SlingObjectAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final SlingObject annotation;

        public SlingObjectAnnotationProcessor(SlingObject annotation) {
            this.annotation = annotation;
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }
    }
}

