/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.repoinit.parser.impl.QuotableStringUtil;
import org.apache.sling.repoinit.parser.operations.AclGroupBase;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class EnsureAclPrincipalBased
extends AclGroupBase {
    private final List<String> principals;

    public EnsureAclPrincipalBased(List<String> principals, List<AclLine> lines) {
        this(principals, lines, new ArrayList<String>());
    }

    public EnsureAclPrincipalBased(List<String> principals, List<AclLine> lines, List<String> aclOptions) {
        super(lines, aclOptions);
        this.principals = Collections.unmodifiableList(principals);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.principals);
        sb.append(super.getParametersDescription());
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        String topline = String.format("ensure principal ACL for %s%s%n", EnsureAclPrincipalBased.listToString(QuotableStringUtil.forRepoInitString(this.principals)), this.getAclOptionsString());
        return this.asRepoInit(topline, true);
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitEnsureAclPrincipalBased(this);
    }
}

