/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.util.Map;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.scripting.java.impl.JavaScriptEngineFactory;

public class CompilerOptions
extends Options {
    private static final long serialVersionUID = 6526386931840426139L;
    private String encoding;

    public static CompilerOptions createOptions(JavaScriptEngineFactory.Config config) {
        String currentVersion = System.getProperty("java.specification.version");
        CompilerOptions opts = new CompilerOptions();
        opts.put("generateDebugInfo", config.java_classdebuginfo());
        opts.put("sourceVersion", config.java_compilerSourceVM());
        if ("auto".equalsIgnoreCase((String)opts.get("sourceVersion"))) {
            opts.put("sourceVersion", currentVersion);
        }
        opts.put("targetVersion", config.java_compilerTargetVM());
        if ("auto".equalsIgnoreCase((String)opts.get("targetVersion"))) {
            opts.put("targetVersion", currentVersion);
        }
        opts.encoding = config.java_javaEncoding();
        opts.put("ignoreWarnings", true);
        return opts;
    }

    public static CompilerOptions copyOptions(CompilerOptions opt) {
        CompilerOptions opts = new CompilerOptions();
        opts.putAll((Map)((Object)opt));
        opts.encoding = opt.getJavaEncoding();
        return opts;
    }

    public String getJavaEncoding() {
        return this.encoding;
    }
}

