/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.config.ConfigAnnotationUtil;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeContext;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeStrictnessViolation;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigType;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfigs;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.propertytypes.ServiceRanking;

public class ConfigTypeContextImplTest {
    private TestOsgiContext context;
    private ConfigTypeContext configTypeContext;

    @Before
    public void setUp() throws Exception {
        this.context = new TestOsgiContext();
        this.context.setUpContext();
        this.configTypeContext = new ConfigTypeContext((OsgiContextImpl)this.context);
    }

    @After
    public void tearDown() throws Exception {
        this.context.tearDownContext();
    }

    @Test
    public void testConstructConfigType() {
        ConfigType configAnnotation = Configured.class.getAnnotation(ConfigType.class);
        Object reified = this.configTypeContext.constructConfigType(configAnnotation);
        Assert.assertTrue((boolean)(reified instanceof ServiceRanking));
        ServiceRanking serviceRanking = (ServiceRanking)reified;
        Assert.assertEquals((long)42L, (long)serviceRanking.value());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructConfigTypeThrows() {
        ConfigType configAnnotation = IllegallyConfigured.class.getAnnotation(ConfigType.class);
        this.configTypeContext.constructConfigType(configAnnotation);
    }

    @Test
    public void testConstructConfigTypeWithApplyPid() throws Exception {
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.context.getService(ConfigurationAdmin.class);
        Assert.assertNotNull((Object)configurationAdmin);
        Configuration config = configurationAdmin.getConfiguration("existing-pid");
        ConfigType configAnnotation = ConfiguredWithPid.class.getAnnotation(ConfigType.class);
        ConfigType rankingAnnotation = Configured.class.getAnnotation(ConfigType.class);
        Assert.assertEquals((Object)"a Component.property() value", (Object)((ConfigurableFromPid)this.configTypeContext.constructConfigType(configAnnotation)).string_property());
        Assert.assertEquals((long)42L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(rankingAnnotation)).value());
        Assert.assertEquals((Object)"a Component.property() value", (Object)((ConfigurableFromPid)this.configTypeContext.constructConfigType(configAnnotation, "existing-pid")).string_property());
        Assert.assertEquals((long)42L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(rankingAnnotation, "existing-pid")).value());
        config.update(MapUtil.toDictionary(Map.of("string.property", "a configured value", "service.ranking", 99)));
        Assert.assertEquals((Object)"a configured value", (Object)((ConfigurableFromPid)this.configTypeContext.constructConfigType(configAnnotation)).string_property());
        Assert.assertEquals((long)42L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(rankingAnnotation)).value());
        Assert.assertEquals((Object)"a configured value", (Object)((ConfigurableFromPid)this.configTypeContext.constructConfigType(configAnnotation, "existing-pid")).string_property());
        Assert.assertEquals((long)99L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(rankingAnnotation, "existing-pid")).value());
        Assert.assertEquals((Object)"a Component.property() value", (Object)((ConfigurableFromPid)this.configTypeContext.constructConfigType(configAnnotation, "new-pid")).string_property());
        Assert.assertEquals((long)42L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(rankingAnnotation, "new-pid")).value());
    }

    @Test(expected=IllegalStateException.class)
    public void testUpdatePropertiesForConfigPidThrows() throws IOException {
        ConfigurationAdmin mocked = (ConfigurationAdmin)Mockito.mock(ConfigurationAdmin.class);
        ((ConfigurationAdmin)Mockito.doThrow(IOException.class).when((Object)mocked)).getConfiguration(ArgumentMatchers.anyString());
        HashMap props = new HashMap();
        ConfigTypeContext.updatePropertiesForConfigPid(props, (String)"new-pid", (ConfigurationAdmin)mocked);
    }

    @Test
    public void testUpdatePropertiesForNewConfiguration() throws IOException {
        ConfigurationAdmin mocked = (ConfigurationAdmin)Mockito.mock(ConfigurationAdmin.class);
        Configuration mockedConfig = (Configuration)Mockito.mock(Configuration.class);
        ((ConfigurationAdmin)Mockito.doReturn((Object)mockedConfig).when((Object)mocked)).getConfiguration("new-pid");
        Map<String, String> props = Map.of("new.property", "value");
        Dictionary asDict = MapUtil.toDictionary(props);
        ConfigTypeContext.updatePropertiesForConfigPid(props, (String)"new-pid", (ConfigurationAdmin)mocked);
        ((Configuration)Mockito.verify((Object)mockedConfig, (VerificationMode)Mockito.times((int)1))).update(asDict);
    }

    @Test
    public void testUpdatePropertiesForNullConfigurationAdmin() {
        HashMap props = new HashMap();
        ConfigTypeContext.updatePropertiesForConfigPid(props, (String)"new-pid", null);
        Assert.assertTrue((boolean)props.isEmpty());
    }

    @Test
    public void testUpdateConfiguration() throws IOException {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.context.getService(ConfigurationAdmin.class);
        Assert.assertNull((Object)configAdmin.getConfiguration("a pid").getProperties());
        SetConfig setConfig = UpdatesConfiguration.class.getAnnotation(SetConfig.class);
        this.configTypeContext.updateConfiguration(setConfig);
        Assert.assertEquals((Object)42, configAdmin.getConfiguration("a pid").getProperties().get("service.ranking"));
    }

    @Test
    public void testUpdateConfigurationArray() throws IOException {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.context.getService(ConfigurationAdmin.class);
        Assert.assertNull((Object)configAdmin.getConfiguration("a pid").getProperties());
        SetConfig setConfig = UpdatesConfigurationArray.class.getAnnotation(SetConfig.class);
        this.configTypeContext.updateConfiguration(setConfig);
        Assert.assertArrayEquals((Object[])new Integer[]{42, 55}, (Object[])((Integer[])configAdmin.getConfiguration("a pid").getProperties().get("service.ranking")));
    }

    @Test
    public void testUpdateConfigurationEmptyPid() throws IOException {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.context.getService(ConfigurationAdmin.class);
        Assert.assertNull((Object)configAdmin.getConfiguration("").getProperties());
        SetConfig setConfig = NoUpdatesConfiguration.class.getAnnotation(SetConfig.class);
        this.configTypeContext.updateConfiguration(setConfig);
        Assert.assertNull((Object)configAdmin.getConfiguration("").getProperties());
    }

    @Test
    public void testUpdateConfigurationByComponentName() throws IOException {
        String pid = UpdatesConfigurationByComponentName.class.getName();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.context.getService(ConfigurationAdmin.class);
        Assert.assertNull((Object)configAdmin.getConfiguration(pid).getProperties());
        SetConfig setConfig = UpdatesConfigurationByComponentName.class.getAnnotation(SetConfig.class);
        this.configTypeContext.updateConfiguration(setConfig);
        Assert.assertEquals((Object)42, configAdmin.getConfiguration(pid).getProperties().get("service.ranking"));
    }

    @Test
    public void testConstructConfigTypeMultiplePids() {
        ConfigAnnotationUtil.findUpdateConfigAnnotations(AppliesMultipleConfigs.class).forEachOrdered(arg_0 -> ((ConfigTypeContext)this.configTypeContext).updateConfiguration(arg_0));
        ConfigType annotation = AppliesMultipleConfigs.class.getAnnotation(ConfigType.class);
        Assert.assertEquals((long)10L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation)).value());
        Assert.assertEquals((long)10L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "")).value());
        Assert.assertEquals((long)21L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "ranking.is.21")).value());
        Assert.assertEquals((long)42L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "ranking.is.42")).value());
        Assert.assertEquals((long)10L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "new-pid")).value());
        Assert.assertEquals((long)55L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, AppliesMultipleConfigs.class.getName())).value());
    }

    @Test
    public void testConstructConfigTypeMultiplePidsWithOwnDefault() {
        ConfigAnnotationUtil.findUpdateConfigAnnotations(AppliesMultipleConfigsWithOwnDefault.class).forEachOrdered(arg_0 -> ((ConfigTypeContext)this.configTypeContext).updateConfiguration(arg_0));
        ConfigType annotation = AppliesMultipleConfigsWithOwnDefault.class.getAnnotation(ConfigType.class);
        Assert.assertEquals((long)21L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation)).value());
        Assert.assertEquals((long)21L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "")).value());
        Assert.assertEquals((long)42L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "ranking.is.42")).value());
        Assert.assertEquals((long)10L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "new-pid")).value());
        Assert.assertEquals((long)55L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, AppliesMultipleConfigsWithOwnDefault.class.getName())).value());
    }

    @Test
    public void testConstructConfigTypeMultiplePidsWithOwnDefaultComponent() {
        ConfigAnnotationUtil.findUpdateConfigAnnotations(AppliesMultipleConfigsWithOwnDefaultComponent.class).forEachOrdered(arg_0 -> ((ConfigTypeContext)this.configTypeContext).updateConfiguration(arg_0));
        ConfigType annotation = AppliesMultipleConfigsWithOwnDefaultComponent.class.getAnnotation(ConfigType.class);
        Assert.assertEquals((long)55L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation)).value());
        Assert.assertEquals((long)55L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "")).value());
        Assert.assertEquals((long)21L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "ranking.is.21")).value());
        Assert.assertEquals((long)42L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "ranking.is.42")).value());
        Assert.assertEquals((long)10L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, "new-pid")).value());
        Assert.assertEquals((long)55L, (long)((ServiceRanking)this.configTypeContext.constructConfigType(annotation, AppliesMultipleConfigsWithOwnDefaultComponent.class.getName())).value());
    }

    @Test(expected=IllegalStateException.class)
    public void testMergePropertiesFromConfigurationPidThrows() throws IOException {
        ConfigurationAdmin mocked = (ConfigurationAdmin)Mockito.mock(ConfigurationAdmin.class);
        ((ConfigurationAdmin)Mockito.doThrow(IOException.class).when((Object)mocked)).getConfiguration(ArgumentMatchers.anyString());
        HashMap props = new HashMap();
        ConfigTypeContext.mergePropertiesFromConfigPid(props, (String)"new-pid", (ConfigurationAdmin)mocked);
    }

    @Test
    public void testMergePropertiesFromNewConfiguration() throws IOException {
        ConfigurationAdmin mocked = (ConfigurationAdmin)Mockito.mock(ConfigurationAdmin.class);
        Configuration mockedConfig = (Configuration)Mockito.mock(Configuration.class);
        ((ConfigurationAdmin)Mockito.doReturn((Object)mockedConfig).when((Object)mocked)).getConfiguration("new-pid");
        HashMap props = new HashMap();
        ConfigTypeContext.mergePropertiesFromConfigPid(props, (String)"new-pid", (ConfigurationAdmin)mocked);
        Assert.assertTrue((boolean)props.isEmpty());
    }

    @Test
    public void testMergePropertiesFromNullConfigurationAdmin() throws IOException {
        HashMap props = new HashMap();
        ConfigTypeContext.mergePropertiesFromConfigPid(props, (String)"new-pid", null);
        Assert.assertTrue((boolean)props.isEmpty());
    }

    @Test
    public void testMergePropertiesFromExistingConfiguration() throws IOException {
        Configuration mockedConfig = (Configuration)Mockito.mock(Configuration.class);
        Map<String, Integer> existingProps = Map.of("prop.string", "a string", "prop.integer", 42);
        ((Configuration)Mockito.doAnswer(call -> MapUtil.toDictionary(Map.copyOf(existingProps))).when((Object)mockedConfig)).getProperties();
        ConfigurationAdmin mocked = (ConfigurationAdmin)Mockito.mock(ConfigurationAdmin.class);
        ((ConfigurationAdmin)Mockito.doReturn((Object)mockedConfig).when((Object)mocked)).getConfiguration("existing-pid");
        HashMap props = new HashMap();
        ConfigTypeContext.mergePropertiesFromConfigPid(props, (String)"existing-pid", (ConfigurationAdmin)mocked);
        Assert.assertEquals(Map.of("prop.string", "a string", "prop.integer", 42), props);
        HashMap<String, Boolean> overrideProps = new HashMap<String, Boolean>(Map.of("prop.string", "a different string", "prop.boolean", true));
        ConfigTypeContext.mergePropertiesFromConfigPid(overrideProps, (String)"existing-pid", (ConfigurationAdmin)mocked);
        Assert.assertEquals(Map.of("prop.string", "a string", "prop.boolean", true, "prop.integer", 42), overrideProps);
    }

    @Test
    public void testConfigTypeInterface() {
        ConfigType configAnnotation = ConfiguredWithInterface.class.getAnnotation(ConfigType.class);
        Object reified = this.configTypeContext.constructConfigType(configAnnotation);
        Assert.assertTrue((boolean)(reified instanceof AnInterface));
        AnInterface serviceRanking = (AnInterface)reified;
        Assert.assertEquals((long)42L, (long)serviceRanking.service_ranking());
    }

    @Test
    public void testNewTypedConfig() {
        ConfigType configAnnotation = Configured.class.getAnnotation(ConfigType.class);
        TypedConfig typedConfig = this.configTypeContext.newTypedConfig((Annotation)configAnnotation);
        Assert.assertTrue((boolean)(typedConfig.getConfig() instanceof ServiceRanking));
        ServiceRanking serviceRanking = (ServiceRanking)typedConfig.getConfig();
        Assert.assertEquals((long)42L, (long)serviceRanking.value());
        TypedConfig typedConfigFromResult = this.configTypeContext.newTypedConfig((Annotation)serviceRanking);
        Assert.assertTrue((boolean)(typedConfigFromResult.getConfig() instanceof ServiceRanking));
        ServiceRanking serviceRanking2 = (ServiceRanking)typedConfigFromResult.getConfig();
        Assert.assertEquals((long)42L, (long)serviceRanking2.value());
    }

    @Test
    public void testSelfTestSingleElementPass() {
        ConfigType configAnnotation = SelfTestSingleElementPass.class.getAnnotation(ConfigType.class);
        Assert.assertNotNull((Object)this.configTypeContext.constructConfigType(configAnnotation));
    }

    @Test(expected=ConfigTypeStrictnessViolation.class)
    public void testSelfTestSingleElementFail() {
        ConfigType configAnnotation = SelfTestSingleElementFail.class.getAnnotation(ConfigType.class);
        this.configTypeContext.constructConfigType(configAnnotation);
    }

    @Test
    public void testSelfTestSingleElementLenient() {
        ConfigType configAnnotation = SelfTestSingleElementLenient.class.getAnnotation(ConfigType.class);
        Assert.assertNotNull((Object)this.configTypeContext.constructConfigType(configAnnotation));
    }

    @Test
    public void testSelfTestAnnotationPass() {
        ConfigType configAnnotation = SelfTestAnnotationPass.class.getAnnotation(ConfigType.class);
        Assert.assertNotNull((Object)this.configTypeContext.constructConfigType(configAnnotation));
    }

    @Test(expected=ConfigTypeStrictnessViolation.class)
    public void testSelfTestAnnotationUnexpected() {
        ConfigType configAnnotation = SelfTestAnnotationUnexpectedFail.class.getAnnotation(ConfigType.class);
        this.configTypeContext.constructConfigType(configAnnotation);
    }

    @Test(expected=ConfigTypeStrictnessViolation.class)
    public void testSelfTestAnnotationMissing() {
        ConfigType configAnnotation = SelfTestAnnotationMissingFail.class.getAnnotation(ConfigType.class);
        this.configTypeContext.constructConfigType(configAnnotation);
    }

    @Test
    public void testSelfTestInterfacePass() {
        ConfigType configAnnotation = SelfTestInterfacePass.class.getAnnotation(ConfigType.class);
        Assert.assertNotNull((Object)this.configTypeContext.constructConfigType(configAnnotation));
    }

    @Test(expected=ConfigTypeStrictnessViolation.class)
    public void testSelfTestInterfaceFail() {
        ConfigType configAnnotation = SelfTestInterfaceFail.class.getAnnotation(ConfigType.class);
        this.configTypeContext.constructConfigType(configAnnotation);
    }

    static class TestOsgiContext
    extends OsgiContextImpl {
        TestOsgiContext() {
        }

        void setUpContext() {
            this.setUp();
        }

        void tearDownContext() {
            this.tearDown();
        }
    }

    @ConfigType(type=ServiceRanking.class, property={"service.ranking:Integer=42"})
    public static class Configured {
    }

    @ConfigType(type=String.class, property={"service.ranking:Integer=42"})
    public static class IllegallyConfigured {
    }

    @ConfigType(type=ConfigurableFromPid.class, pid="existing-pid", property={"string.property=a Component.property() value"})
    public static class ConfiguredWithPid {
    }

    public static @interface ConfigurableFromPid {
        public String string_property() default "a default value";
    }

    @SetConfig(pid="a pid", property={"service.ranking:Integer=42"})
    public static class UpdatesConfiguration {
    }

    @SetConfig(pid="a pid", property={"service.ranking:Integer=42", "service.ranking:Integer=55"})
    public static class UpdatesConfigurationArray {
    }

    @SetConfig(pid="", property={"service.ranking:Integer=42"})
    public static class NoUpdatesConfiguration {
    }

    @SetConfig(component=UpdatesConfigurationByComponentName.class, property={"service.ranking:Integer=42"})
    public static class UpdatesConfigurationByComponentName {
    }

    @SetConfigs(value={@SetConfig(pid="ranking.is.21", property={"service.ranking:Integer=21"}), @SetConfig(pid="ranking.is.42", property={"service.ranking:Integer=42"}), @SetConfig(component=AppliesMultipleConfigs.class, property={"service.ranking:Integer=55"})})
    @ConfigType(type=ServiceRanking.class, property={"service.ranking:Integer=10"})
    public static class AppliesMultipleConfigs {
    }

    @SetConfigs(value={@SetConfig(pid="ranking.is.21", property={"service.ranking:Integer=21"}), @SetConfig(pid="ranking.is.42", property={"service.ranking:Integer=42"}), @SetConfig(component=AppliesMultipleConfigsWithOwnDefault.class, property={"service.ranking:Integer=55"})})
    @ConfigType(type=ServiceRanking.class, pid="ranking.is.21", property={"service.ranking:Integer=10"})
    public static class AppliesMultipleConfigsWithOwnDefault {
    }

    @SetConfigs(value={@SetConfig(pid="ranking.is.21", property={"service.ranking:Integer=21"}), @SetConfig(pid="ranking.is.42", property={"service.ranking:Integer=42"}), @SetConfig(component=AppliesMultipleConfigsWithOwnDefaultComponent.class, property={"service.ranking:Integer=55"})})
    @ConfigType(type=ServiceRanking.class, pid="$", component=AppliesMultipleConfigsWithOwnDefaultComponent.class, property={"service.ranking:Integer=10"})
    public static class AppliesMultipleConfigsWithOwnDefaultComponent {
    }

    @ConfigType(type=AnInterface.class, property={"service.ranking:Integer=42"})
    public static class ConfiguredWithInterface {
    }

    public static interface AnInterface {
        public int service_ranking();
    }

    @ConfigType(type=ServiceRanking.class, property={"service.ranking:Integer=42"}, lenient=true)
    public static final class SelfTestSingleElementPass {
    }

    @ConfigType(type=ServiceRanking.class, property={"service.vendor=Acme"})
    public static final class SelfTestSingleElementFail {
    }

    @ConfigType(type=ServiceRanking.class, property={"service.vendor=Acme"}, lenient=true)
    public static final class SelfTestSingleElementLenient {
    }

    @ConfigType(type=ServiceRankingAndVendor.class, property={"service.ranking:Integer=42", "service.vendor=Acme"})
    public static final class SelfTestAnnotationPass {
    }

    @ConfigType(type=ServiceRankingAndVendor.class, property={"service_ranking:Integer=42", "service.vendor=Acme"})
    public static final class SelfTestAnnotationUnexpectedFail {
    }

    @ConfigType(type=ServiceRankingAndVendor.class, property={"service_vendor=Acme"})
    public static final class SelfTestAnnotationMissingFail {
    }

    @ConfigType(type=IServiceRankingAndVendor.class, property={"service.ranking:Integer=42", "service.vendor=Acme"})
    public static final class SelfTestInterfacePass {
    }

    @ConfigType(type=IServiceRankingAndVendor.class, property={"service_ranking:Integer=42", "service_vendor=Acme"})
    public static final class SelfTestInterfaceFail {
    }

    public static interface IServiceRankingAndVendor {
        public int service_ranking();

        public String service_vendor();
    }

    public static @interface ServiceRankingAndVendor {
        public int service_ranking();

        public String service_vendor() default "";
    }
}

