/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.json.BlobDeserializer;
import org.apache.jackrabbit.oak.json.TypeCodes;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import sling-mock-oak.com.google.common.base.CharMatcher;
import sling-mock-oak.com.google.common.collect.ImmutableSet;
import sling-mock-oak.com.google.common.collect.Lists;

public class JsonDeserializer {
    public static final String OAK_CHILD_ORDER = ":childOrder";
    private final BlobDeserializer blobHandler;
    private final NodeBuilder builder;
    private final DeserializationSupport deserializationSupport;

    private JsonDeserializer(BlobDeserializer blobHandler, NodeBuilder builder, DeserializationSupport support) {
        this.blobHandler = blobHandler;
        this.builder = builder;
        this.deserializationSupport = support;
    }

    public JsonDeserializer(BlobDeserializer blobHandler) {
        this(blobHandler, EmptyNodeState.EMPTY_NODE.builder(), DeserializationSupport.INSTANCE);
    }

    public JsonDeserializer(BlobDeserializer blobHandler, NodeBuilder builder) {
        this(blobHandler, builder, DeserializationSupport.INSTANCE);
    }

    public NodeState deserialize(String json) {
        JsopTokenizer reader = new JsopTokenizer(json);
        reader.read(123);
        NodeState state = this.deserialize(reader);
        reader.read(0);
        return state;
    }

    public NodeState deserialize(JsopReader reader) {
        this.readNode(reader, this.builder);
        return this.builder.getNodeState();
    }

    private void readNode(JsopReader reader, NodeBuilder builder) {
        ArrayList<String> childNames = Lists.newArrayList();
        if (!reader.matches(125)) {
            do {
                String key = reader.readString();
                reader.read(58);
                if (reader.matches(123)) {
                    childNames.add(key);
                    this.readNode(reader, builder.child(key));
                    continue;
                }
                if (reader.matches(91)) {
                    builder.setProperty(this.readArrayProperty(key, reader));
                    continue;
                }
                builder.setProperty(this.readProperty(key, reader));
            } while (reader.matches(44));
            reader.read(125);
        }
        if (this.deserializationSupport.hasOrderableChildren(builder) && !builder.hasProperty(OAK_CHILD_ORDER)) {
            builder.setProperty(OAK_CHILD_ORDER, childNames, Type.NAMES);
        }
    }

    private PropertyState readProperty(String name, JsopReader reader) {
        if (reader.matches(2)) {
            String number = reader.getToken();
            try {
                return new LongPropertyState(name, Long.parseLong(number));
            }
            catch (NumberFormatException e) {
                return new DoublePropertyState(name, Double.parseDouble(number));
            }
        }
        if (reader.matches(3)) {
            return BooleanPropertyState.booleanProperty(name, true);
        }
        if (reader.matches(4)) {
            return BooleanPropertyState.booleanProperty(name, false);
        }
        if (reader.matches(1)) {
            String jsonString = reader.getToken();
            Type<String> inferredType = this.deserializationSupport.inferPropertyType(name, jsonString);
            if (jsonString.startsWith("[0]:")) {
                int type = PropertyType.valueFromName((String)jsonString.substring("[0]:".length()));
                return PropertyStates.createProperty(name, Collections.emptyList(), Type.fromTag(type, true));
            }
            int split = TypeCodes.split(jsonString);
            if (split != -1) {
                int type = TypeCodes.decodeType(split, jsonString);
                String value = TypeCodes.decodeName(split, jsonString);
                if (type == 2) {
                    return BinaryPropertyState.binaryProperty(name, this.blobHandler.deserialize(value));
                }
                if (type == 0) {
                    Type<String> oakType = inferredType != Type.UNDEFINED ? inferredType : Type.STRING;
                    return PropertyStates.createProperty(name, (Object)jsonString, oakType);
                }
                return PropertyStates.createProperty(name, value, type);
            }
            Type<String> oakType = inferredType != Type.UNDEFINED ? inferredType : Type.STRING;
            return PropertyStates.createProperty(name, (Object)jsonString, oakType);
        }
        throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
    }

    private PropertyState readArrayProperty(String name, JsopReader reader) {
        int type = 1;
        ArrayList<Object> values = Lists.newArrayList();
        while (!reader.matches(93)) {
            if (reader.matches(2)) {
                String number = reader.getToken();
                try {
                    type = 3;
                    values.add(Long.parseLong(number));
                }
                catch (NumberFormatException e) {
                    type = 4;
                    values.add(Double.parseDouble(number));
                }
            } else if (reader.matches(3)) {
                type = 6;
                values.add(true);
            } else if (reader.matches(4)) {
                type = 6;
                values.add(false);
            } else if (reader.matches(1)) {
                String jsonString = reader.getToken();
                Type inferredType = this.deserializationSupport.inferPropertyType(name, jsonString);
                int split = TypeCodes.split(jsonString);
                if (split != -1) {
                    type = TypeCodes.decodeType(split, jsonString);
                    String value = TypeCodes.decodeName(split, jsonString);
                    if (type == 2) {
                        values.add(this.blobHandler.deserialize(value));
                    } else if (type == 4) {
                        values.add(Conversions.convert(value).toDouble());
                    } else if (type == 12) {
                        values.add(Conversions.convert(value).toDecimal());
                    } else if (type == 0) {
                        type = inferredType != Type.UNDEFINED ? inferredType.tag() : 1;
                        values.add(jsonString);
                    } else {
                        values.add(value);
                    }
                } else {
                    type = inferredType != Type.UNDEFINED ? inferredType.tag() : 1;
                    values.add(jsonString);
                }
            } else {
                throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
            }
            reader.matches(44);
        }
        return PropertyStates.createProperty(name, values, Type.fromTag(type, true));
    }

    private static class DeserializationSupport {
        static final Set<String> NAME_PROPS = ImmutableSet.of("jcr:primaryType", "jcr:mixinTypes");
        static final Set<String> ORDERABLE_TYPES = ImmutableSet.of("nt:unstructured");
        static final DeserializationSupport INSTANCE = new DeserializationSupport();

        private DeserializationSupport() {
        }

        Type inferPropertyType(String propertyName, String jsonString) {
            if (NAME_PROPS.contains(propertyName) && this.hasSingleColon(jsonString)) {
                return Type.NAME;
            }
            return Type.UNDEFINED;
        }

        boolean hasOrderableChildren(NodeBuilder builder) {
            PropertyState primaryType = builder.getProperty("jcr:primaryType");
            return primaryType != null && ORDERABLE_TYPES.contains(primaryType.getValue(Type.NAME));
        }

        private boolean hasSingleColon(String jsonString) {
            return CharMatcher.is(':').countIn(jsonString) == 1;
        }
    }
}

