/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.observation;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.observation.ChangeSet;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.collect.Sets;

public class ChangeSetBuilder {
    private final int maxItems;
    private int maxPathDepth;
    private final Set<String> parentPaths = Sets.newHashSet();
    private final Set<String> parentNodeNames = Sets.newHashSet();
    private final Set<String> parentNodeTypes = Sets.newHashSet();
    private final Set<String> propertyNames = Sets.newHashSet();
    private final Set<String> allNodeTypes = Sets.newHashSet();
    private boolean parentPathOverflow;
    private boolean parentNodeNameOverflow;
    private boolean parentNodeTypeOverflow;
    private boolean propertyNameOverflow;
    private boolean allNodeTypeOverflow;

    public ChangeSetBuilder(int maxItems, int maxPathDepth) {
        this.maxItems = maxItems;
        this.maxPathDepth = maxPathDepth;
    }

    public String toString() {
        return "ChangeSetBuilder{parentPaths[maxDepth:" + this.maxPathDepth + "]=" + this.parentPaths + ", propertyNames=" + this.propertyNames + ", parentNodeNames=" + this.parentNodeNames + ", parentNodeTypes=" + this.parentNodeTypes + ", allNodeTypes=" + this.allNodeTypes + "}";
    }

    public boolean isParentPathOverflown() {
        return this.parentPathOverflow;
    }

    public ChangeSetBuilder addParentPath(String path) {
        path = ChangeSetBuilder.getPathWithMaxDepth(path, this.maxPathDepth);
        this.parentPathOverflow = ChangeSetBuilder.addAndCheckOverflow(this.parentPaths, path, this.maxItems, this.parentPathOverflow);
        return this;
    }

    public boolean isParentNodeNameOverflown() {
        return this.parentNodeNameOverflow;
    }

    public ChangeSetBuilder addParentNodeName(String parentNodeName) {
        this.parentNodeNameOverflow = ChangeSetBuilder.addAndCheckOverflow(this.parentNodeNames, parentNodeName, this.maxItems, this.parentNodeNameOverflow);
        return this;
    }

    public boolean isParentNodeTypeOverflown() {
        return this.parentNodeTypeOverflow;
    }

    public ChangeSetBuilder addParentNodeTypes(Iterable<String> nodeTypes) {
        for (String nodeType : nodeTypes) {
            this.addParentNodeType(nodeType);
        }
        return this;
    }

    public ChangeSetBuilder addParentNodeType(String parentNodeType) {
        this.parentNodeTypeOverflow = ChangeSetBuilder.addAndCheckOverflow(this.parentNodeTypes, parentNodeType, this.maxItems, this.parentNodeTypeOverflow);
        return this;
    }

    public boolean isPropertyNameOverflown() {
        return this.propertyNameOverflow;
    }

    public ChangeSetBuilder addPropertyName(String propertyName) {
        this.propertyNameOverflow = ChangeSetBuilder.addAndCheckOverflow(this.propertyNames, propertyName, this.maxItems, this.propertyNameOverflow);
        return this;
    }

    public boolean isAllNodeTypeOverflown() {
        return this.allNodeTypeOverflow;
    }

    public ChangeSetBuilder addNodeTypes(Iterable<String> nodeTypes) {
        for (String nodeType : nodeTypes) {
            this.addNodeType(nodeType);
        }
        return this;
    }

    public ChangeSetBuilder addNodeType(String nodeType) {
        this.allNodeTypeOverflow = ChangeSetBuilder.addAndCheckOverflow(this.allNodeTypes, nodeType, this.maxItems, this.allNodeTypeOverflow);
        return this;
    }

    public int getMaxPrefilterPathDepth() {
        return this.maxPathDepth;
    }

    public ChangeSetBuilder add(@Nullable ChangeSet cs) {
        if (cs == null) {
            this.parentPathOverflow = true;
            this.parentNodeNameOverflow = true;
            this.parentNodeTypeOverflow = true;
            this.propertyNameOverflow = true;
            this.allNodeTypeOverflow = true;
            return this;
        }
        if (cs.getParentPaths() == null) {
            this.parentPathOverflow = true;
        } else {
            this.addPathFromChangeSet(cs);
        }
        if (cs.getParentNodeNames() == null) {
            this.parentNodeNameOverflow = true;
        } else {
            for (String parentNodeName : cs.getParentNodeNames()) {
                this.addParentNodeName(parentNodeName);
            }
        }
        if (cs.getParentNodeTypes() == null) {
            this.parentNodeTypeOverflow = true;
        } else {
            for (String parentNodeType : cs.getParentNodeTypes()) {
                this.addParentNodeType(parentNodeType);
            }
        }
        if (cs.getPropertyNames() == null) {
            this.propertyNameOverflow = true;
        } else {
            for (String propertyName : cs.getPropertyNames()) {
                this.addPropertyName(propertyName);
            }
        }
        if (cs.getAllNodeTypes() == null) {
            this.allNodeTypeOverflow = true;
        } else {
            for (String nodeType : cs.getAllNodeTypes()) {
                this.addNodeType(nodeType);
            }
        }
        return this;
    }

    public ChangeSet build() {
        return new ChangeSet(this.maxPathDepth, this.parentPathOverflow ? null : this.parentPaths, this.parentNodeNameOverflow ? null : this.parentNodeNames, this.parentNodeTypeOverflow ? null : this.parentNodeTypes, this.propertyNameOverflow ? null : this.propertyNames, this.allNodeTypeOverflow ? null : this.allNodeTypes);
    }

    private void addPathFromChangeSet(ChangeSet cs) {
        int maxDepthInChangeSet = cs.getMaxPrefilterPathDepth();
        if (maxDepthInChangeSet < this.maxPathDepth) {
            HashSet<String> existingPathSet = Sets.newHashSet(this.parentPaths);
            this.parentPaths.clear();
            for (String existingPath : existingPathSet) {
                this.parentPaths.add(ChangeSetBuilder.getPathWithMaxDepth(existingPath, maxDepthInChangeSet));
            }
            this.maxPathDepth = maxDepthInChangeSet;
        }
        for (String pathFromChangeSet : cs.getParentPaths()) {
            this.addParentPath(ChangeSetBuilder.getPathWithMaxDepth(pathFromChangeSet, this.maxPathDepth));
        }
    }

    private static String getPathWithMaxDepth(String path, int maxDepth) {
        int depth = PathUtils.getDepth(path);
        if (depth <= maxDepth) {
            return path;
        }
        return PathUtils.getAncestorPath(path, depth - maxDepth);
    }

    private static boolean addAndCheckOverflow(Set<String> dataSet, String data, int maxSize, boolean overflow) {
        if (overflow) {
            return true;
        }
        dataSet.add(data);
        if (dataSet.size() > maxSize) {
            dataSet.clear();
            return true;
        }
        return false;
    }
}

