/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tooling.support.source.impl;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.tooling.support.source.impl.SourceReference;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class PomHandler
extends DefaultHandler {
    private final String jettyVersion;
    private Deque<String> elements = new LinkedList<String>();
    private String artifactId;
    private String groupId;
    private String version;
    private List<SourceReference> references = new ArrayList<SourceReference>();

    PomHandler(String jettyVersion) {
        this.jettyVersion = jettyVersion;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elements.add(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elements.size() != 4) {
            return;
        }
        String tagName = this.elements.peekLast();
        if (tagName.equals("artifactId")) {
            this.artifactId = new String(ch, start, length);
        } else if (tagName.equals("groupId")) {
            this.groupId = new String(ch, start, length);
        } else if (tagName.equals("version")) {
            this.version = new String(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.elements.size() == 3 && qName.equals("dependency")) {
            if (this.groupId.startsWith("org.eclipse.jetty")) {
                this.references.add(new SourceReference(this.groupId, this.artifactId, this.jettyVersion));
            } else if (this.groupId.startsWith("org.apache.felix")) {
                this.references.add(new SourceReference(this.groupId, this.artifactId, this.version));
            }
            this.artifactId = null;
            this.groupId = null;
            this.version = null;
        }
        this.elements.removeLast();
    }

    public List<SourceReference> getReferences() {
        return this.references;
    }
}

