/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractHBaseSaslRpcClient {
    private static final byte[] EMPTY_TOKEN = new byte[0];
    protected final SaslClient saslClient;
    protected final boolean fallbackAllowed;
    protected final Map<String, String> saslProps;

    protected AbstractHBaseSaslRpcClient(Configuration conf, SaslClientAuthenticationProvider provider, Token<? extends TokenIdentifier> token, InetAddress serverAddr, String servicePrincipal, boolean fallbackAllowed) throws IOException {
        this(conf, provider, token, serverAddr, servicePrincipal, fallbackAllowed, "authentication");
    }

    protected AbstractHBaseSaslRpcClient(Configuration conf, SaslClientAuthenticationProvider provider, Token<? extends TokenIdentifier> token, InetAddress serverAddr, String servicePrincipal, boolean fallbackAllowed, String rpcProtection) throws IOException {
        this.fallbackAllowed = fallbackAllowed;
        this.saslProps = SaslUtil.initSaslProperties(rpcProtection);
        this.saslClient = provider.createClient(conf, serverAddr, servicePrincipal, token, fallbackAllowed, this.saslProps);
        if (this.saslClient == null) {
            throw new IOException("Authentication provider " + provider.getClass() + " returned a null SaslClient");
        }
    }

    public byte[] getInitialResponse() throws SaslException {
        if (this.saslClient.hasInitialResponse()) {
            return this.saslClient.evaluateChallenge(EMPTY_TOKEN);
        }
        return EMPTY_TOKEN;
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        return this.saslClient.evaluateChallenge(challenge);
    }

    protected void verifyNegotiatedQop() throws IOException {
        SaslUtil.verifyNegotiatedQop(this.saslProps.get("javax.security.sasl.qop"), (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop"));
    }

    public void dispose() {
        SaslUtil.safeDispose(this.saslClient);
    }
}

