/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ByteBufferOutputStream
extends OutputStream
implements ByteBufferWriter {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected ByteBuffer curBuf = null;

    ByteBufferOutputStream() {
    }

    public ByteBufferOutputStream(int capacity) {
        this(capacity, false);
    }

    public ByteBufferOutputStream(int capacity, boolean useDirectByteBuffer) {
        this(ByteBufferOutputStream.allocate(capacity, useDirectByteBuffer));
    }

    public ByteBufferOutputStream(ByteBuffer bb) {
        assert (bb.order() == ByteOrder.BIG_ENDIAN);
        this.curBuf = bb;
        this.curBuf.clear();
    }

    public int size() {
        return this.curBuf.position();
    }

    private static ByteBuffer allocate(int capacity, boolean useDirectByteBuffer) {
        if (capacity > 0x7FFFFFF7) {
            throw new BufferOverflowException();
        }
        return useDirectByteBuffer ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public ByteBuffer getByteBuffer() {
        this.curBuf.flip();
        return this.curBuf;
    }

    protected void checkSizeAndGrow(int extra) {
        long capacityNeeded = (long)this.curBuf.position() + (long)extra;
        if (capacityNeeded > (long)this.curBuf.limit()) {
            if (capacityNeeded > 0x7FFFFFF7L) {
                throw new BufferOverflowException();
            }
            long nextCapacity = Math.min((long)this.curBuf.capacity() * 2L, 0x7FFFFFF7L);
            nextCapacity = Math.max(nextCapacity, capacityNeeded);
            ByteBuffer newBuf = ByteBufferOutputStream.allocate((int)nextCapacity, this.curBuf.isDirect());
            this.curBuf.flip();
            ByteBufferUtils.copyFromBufferToBuffer(this.curBuf, newBuf);
            this.curBuf = newBuf;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkSizeAndGrow(1);
        this.curBuf.put((byte)b);
    }

    public void writeTo(OutputStream out) throws IOException {
        WritableByteChannel channel = Channels.newChannel(out);
        ByteBuffer bb = this.curBuf.duplicate();
        bb.flip();
        channel.write(bb);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkSizeAndGrow(len);
        ByteBufferUtils.copyFromArrayToBuffer(this.curBuf, b, off, len);
    }

    @Override
    public void write(ByteBuffer b, int off, int len) throws IOException {
        this.checkSizeAndGrow(len);
        ByteBufferUtils.copyFromBufferToBuffer(b, this.curBuf, off, len);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.checkSizeAndGrow(4);
        ByteBufferUtils.putInt(this.curBuf, i);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] toByteArray(int offset, int length) {
        ByteBuffer bb = this.curBuf.duplicate();
        bb.flip();
        byte[] chunk = new byte[length];
        bb.position(offset);
        bb.get(chunk, 0, length);
        return chunk;
    }
}

