/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.security;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.storm.hbase.security.AutoHBase;
import org.apache.storm.security.auth.kerberos.AutoTGT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseSecurityUtil.class);
    public static final String STORM_KEYTAB_FILE_KEY = "storm.keytab.file";
    public static final String STORM_USER_NAME_KEY = "storm.kerberos.principal";
    public static final String HBASE_CREDENTIALS_CONFIG_KEYS = "hbaseCredentialsConfigKeys";
    public static final String HBASE_CREDENTIALS = "HBASE_CREDENTIALS";
    public static final String HBASE_KEYTAB_FILE_KEY = "hbase.keytab.file";
    public static final String HBASE_PRINCIPAL_KEY = "hbase.kerberos.principal";
    private static volatile UserProvider legacyProvider = null;

    private HBaseSecurityUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserProvider login(Map<String, Object> conf, Configuration hbaseConfig) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) return null;
        List autoCredentials = (List)conf.get("topology.auto-credentials");
        if (autoCredentials != null && (autoCredentials.contains(AutoHBase.class.getName()) || autoCredentials.contains(AutoTGT.class.getName()))) return legacyProvider;
        LOG.info("Logging in using keytab as neither AutoHBase or AutoTGT is specified for topology.auto-credentials");
        if (legacyProvider != null) return legacyProvider;
        Class<HBaseSecurityUtil> clazz = HBaseSecurityUtil.class;
        synchronized (HBaseSecurityUtil.class) {
            String userName;
            if (legacyProvider != null) return legacyProvider;
            legacyProvider = UserProvider.instantiate((Configuration)hbaseConfig);
            String keytab = (String)conf.get(STORM_KEYTAB_FILE_KEY);
            if (keytab != null) {
                hbaseConfig.set(STORM_KEYTAB_FILE_KEY, keytab);
            }
            if ((userName = (String)conf.get(STORM_USER_NAME_KEY)) != null) {
                hbaseConfig.set(STORM_USER_NAME_KEY, userName);
            }
            legacyProvider.login(STORM_KEYTAB_FILE_KEY, STORM_USER_NAME_KEY, InetAddress.getLocalHost().getCanonicalHostName());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return legacyProvider;
        }
    }
}

