/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.ExpressionValues;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import net.sf.jasperreports.engine.util.ExpressionParser;

public class SimpleTextExpressionEvaluator {
    private static final String EMPTY_RESULT = "";

    public static String evaluateExpression(JRExpression expression, ExpressionValues values) {
        if (expression.getType() != ExpressionTypeEnum.SIMPLE_TEXT) {
            throw new IllegalArgumentException("Simple text expression expected");
        }
        JRExpressionChunk[] chunks = expression.getChunks();
        return SimpleTextExpressionEvaluator.evaluate(chunks, values);
    }

    public static String evaluate(JRExpressionChunk[] chunks, ExpressionValues values) {
        if (chunks == null || chunks.length == 0) {
            return EMPTY_RESULT;
        }
        ResultCollector result = new ResultCollector(values);
        result.collectChunks(chunks);
        return result.getResult();
    }

    private static class ResultCollector
    implements ExpressionParser.ParseResult {
        private final ExpressionValues values;
        private String firstText;
        private StringBuilder resultBuilder;

        public ResultCollector(ExpressionValues values) {
            this.values = values;
        }

        public String getResult() {
            String result = this.resultBuilder != null ? this.resultBuilder.toString() : (this.firstText != null ? this.firstText : SimpleTextExpressionEvaluator.EMPTY_RESULT);
            return result;
        }

        private void appendText(String text) {
            assert (text != null);
            if (this.resultBuilder == null) {
                if (this.firstText == null) {
                    this.firstText = text;
                } else {
                    this.resultBuilder = new StringBuilder(this.firstText.length() + text.length() + 16);
                    this.resultBuilder.append(this.firstText);
                    this.resultBuilder.append(text);
                    this.firstText = null;
                }
            } else {
                this.resultBuilder.append(text);
            }
        }

        public void collectChunks(JRExpressionChunk[] chunks) {
            for (JRExpressionChunk chunk : chunks) {
                byte chunkType = chunk.getType();
                if (chunkType == 1) {
                    this.appendTextChunk(chunk.getText());
                    continue;
                }
                this.appendValueChunk(chunkType, chunk.getText());
            }
        }

        private void appendTextChunk(String text) {
            if (text != null) {
                this.appendText(text);
            }
        }

        private void appendValueChunk(byte chunkType, String chunkText) {
            switch (chunkType) {
                case 5: {
                    this.appendValueChunk(this.values.getMessage(chunkText));
                    break;
                }
                case 2: {
                    this.appendValueChunk(this.values.getParameterValue(chunkText));
                    break;
                }
                case 3: {
                    this.appendValueChunk(this.values.getFieldValue(chunkText));
                    break;
                }
                case 4: {
                    this.appendValueChunk(this.values.getVariableValue(chunkText));
                    break;
                }
                default: {
                    throw new JRRuntimeException("Unexpected expression chunk type " + chunkType);
                }
            }
        }

        private void appendValueChunk(Object value) {
            if (value == null) {
                this.appendText(String.valueOf(value));
            } else if (value instanceof String) {
                String text = (String)value;
                ExpressionParser expressionParser = ExpressionParser.instance();
                if (expressionParser.fastPlaceholderDetect(text)) {
                    expressionParser.parseExpression(text, this);
                } else {
                    this.appendText(text);
                }
            } else {
                String text = String.valueOf(value);
                this.appendText(text == null ? String.valueOf(text) : text);
            }
        }

        @Override
        public void addTextChunk(String text) {
            this.appendTextChunk(text);
        }

        @Override
        public void addChunk(byte chunkType, String chunkText) {
            this.appendValueChunk(chunkType, chunkText);
        }
    }
}

