/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyleConstants;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.MarkupProcessor;

public abstract class EditorKitMarkupProcessor
implements MarkupProcessor {
    protected abstract EditorKit getEditorKit();

    protected Document getDocument(String srcText) {
        EditorKit kit = this.getEditorKit();
        Document document = kit.createDefaultDocument();
        try {
            document.remove(0, document.getLength());
            kit.read(new StringReader(srcText), document, 0);
        }
        catch (IOException | BadLocationException e) {
            throw new JRRuntimeException(e);
        }
        return document;
    }

    protected Map<AttributedCharacterIterator.Attribute, Object> getAttributes(AttributeSet attrSet) {
        HashMap<AttributedCharacterIterator.Attribute, Object> attrMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if (attrSet.isDefined(StyleConstants.FontFamily)) {
            attrMap.put(TextAttribute.FAMILY, StyleConstants.getFontFamily(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Bold)) {
            attrMap.put(TextAttribute.WEIGHT, StyleConstants.isBold(attrSet) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Italic)) {
            attrMap.put(TextAttribute.POSTURE, StyleConstants.isItalic(attrSet) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Underline)) {
            attrMap.put(TextAttribute.UNDERLINE, StyleConstants.isUnderline(attrSet) ? TextAttribute.UNDERLINE_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.StrikeThrough)) {
            attrMap.put(TextAttribute.STRIKETHROUGH, StyleConstants.isStrikeThrough(attrSet) ? TextAttribute.STRIKETHROUGH_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.FontSize)) {
            attrMap.put(TextAttribute.SIZE, StyleConstants.getFontSize(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Foreground)) {
            attrMap.put(TextAttribute.FOREGROUND, StyleConstants.getForeground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Background)) {
            attrMap.put(TextAttribute.BACKGROUND, StyleConstants.getBackground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Superscript) && !StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        if (attrSet.isDefined(StyleConstants.Subscript) && StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        return attrMap;
    }
}

