/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintLine;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.xml.print.ReportElementLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class LineLoader {
    private static final LineLoader INSTANCE = new LineLoader();

    public static LineLoader instance() {
        return INSTANCE;
    }

    public void loadLine(XmlLoader xmlLoader, JasperPrint jasperPrint, Consumer<? super JRPrintLine> consumer) {
        JRBasePrintLine line = new JRBasePrintLine(jasperPrint.getDefaultStyleProvider());
        xmlLoader.setEnumAttribute("direction", LineDirectionEnum::getByName, line::setDirection);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "reportElement": {
                    ReportElementLoader.instance().loadReportElement(xmlLoader, jasperPrint, line);
                    break;
                }
                case "graphicElement": {
                    ReportElementLoader.instance().loadGraphicElement(xmlLoader, line);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        consumer.accept(line);
    }
}

