/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.listener;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.jaxws.context.listener.CompositeInputStream;
import org.apache.axis2.jaxws.context.listener.ProviderOMContextListener;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextListenerUtils {
    private static final Log log = LogFactory.getLog(ContextListenerUtils.class);

    public static void registerProviderOMListener(MessageContext mc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating ProviderOMContextListener");
        }
        ProviderOMContextListener.create(mc.getAxisMessageContext().getServiceContext());
    }

    public static InputStream createPayloadElement(InputStream payloadContent, OMNamespace ns, String localPart, OMContainer parent, HashMap<String, String> nsElementDecls, HashMap<String, String> attrElementDecls) {
        CompositeInputStream inputStream = new CompositeInputStream();
        InputStream startTag = ContextListenerUtils.getStartTag(ns, localPart, parent, nsElementDecls, attrElementDecls);
        InputStream endTag = ContextListenerUtils.getEndTag(ns, localPart);
        inputStream.append(startTag);
        inputStream.append(payloadContent);
        inputStream.append(endTag);
        return inputStream;
    }

    public static int skipEventsTo(int targetEvent, XMLStreamReader parser) throws XMLStreamException {
        int eventType = 0;
        while (parser.hasNext()) {
            eventType = parser.next();
            if (eventType != targetEvent) continue;
            return eventType;
        }
        return eventType;
    }

    private static InputStream getEndTag(OMNamespace ns, String localPart) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start ParsedEntityDataSource.Data.getEndTag()");
        }
        String endElement = null;
        String prefix = ns != null ? ns.getPrefix() : null;
        String uri = ns != null ? ns.getNamespaceURI() : null;
        endElement = prefix != null && prefix.length() > 0 ? "</" + prefix + ":" + localPart + ">" : "</" + localPart + ">";
        if (log.isDebugEnabled()) {
            log.debug((Object)"End ParsedEntityDataSource.Data.getEndTag()");
        }
        return new ByteArrayInputStream(endElement.getBytes());
    }

    private static InputStream getStartTag(OMNamespace ns, String localPart, OMContainer parent, HashMap<String, String> nsElementDecls, HashMap<String, String> attrElementDecls) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start ParsedEntityDataSource.Data.getStartTag()");
        }
        StringBuffer startElement = new StringBuffer();
        String prefix = ns != null ? ns.getPrefix() : null;
        String uri = ns != null ? ns.getNamespaceURI() : null;
        HashMap<String, String> nsDecls = ContextListenerUtils.getParentnsdeclarations(parent);
        nsDecls.putAll(nsElementDecls);
        if (prefix != null && prefix.length() > 0) {
            startElement.append("<" + prefix + ":" + localPart + " ");
            if (!nsDecls.containsKey(prefix) || !nsDecls.get(prefix).equals(uri)) {
                nsDecls.put(prefix, uri);
            }
        } else {
            startElement.append("<" + localPart + " ");
        }
        ContextListenerUtils.addParentNs(startElement, parent, nsDecls);
        ContextListenerUtils.addAttrs(startElement, attrElementDecls);
        if (log.isDebugEnabled()) {
            log.debug((Object)("StartElement =" + startElement));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End ParsedEntityDataSource.Data.getStartTag()");
        }
        return new ByteArrayInputStream(startElement.toString().getBytes());
    }

    private static HashMap<String, String> getParentnsdeclarations(OMContainer parent) {
        HashMap<String, String> nsDecls = new HashMap<String, String>();
        if (parent instanceof OMElement) {
            Iterator ite = ((OMElement)parent).getNamespacesInScope();
            while (ite.hasNext()) {
                OMNamespace omn = (OMNamespace)ite.next();
                nsDecls.put(omn.getPrefix(), omn.getNamespaceURI());
            }
        }
        return nsDecls;
    }

    private static void addParentNs(StringBuffer startElement, OMContainer parent, HashMap<String, String> nsDecls) {
        for (Map.Entry<String, String> entry : nsDecls.entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            if ("".equals(prefix)) {
                startElement.append(" xmlns=\"");
            } else {
                startElement.append(" xmlns:");
                startElement.append(prefix);
                startElement.append("=\"");
            }
            startElement.append(uri);
            startElement.append("\"");
        }
    }

    private static void addAttrs(StringBuffer startElement, HashMap<String, String> attrDecls) {
        for (Map.Entry<String, String> entry : attrDecls.entrySet()) {
            String compoundName = entry.getKey();
            String value = entry.getValue();
            startElement.append(" ");
            startElement.append(compoundName);
            startElement.append("=\"");
            startElement.append(value);
            startElement.append("\"");
        }
        startElement.append(">");
    }
}

