/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;

public class LogMediator
extends AbstractMediator {
    public static final int CUSTOM = 0;
    public static final int SIMPLE = 1;
    public static final int HEADERS = 2;
    public static final int FULL = 3;
    public static final int CATEGORY_INFO = 0;
    public static final int CATEGORY_DEBUG = 1;
    public static final int CATEGORY_TRACE = 2;
    public static final int CATEGORY_WARN = 3;
    public static final int CATEGORY_ERROR = 4;
    public static final int CATEGORY_FATAL = 5;
    public static final String DEFAULT_SEP = ", ";
    private int logLevel = 1;
    private String separator = ", ";
    private int category = 0;
    private final List<MediatorProperty> properties = new ArrayList<MediatorProperty>();

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Log mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        switch (this.category) {
            case 0: {
                synLog.auditLog(this.getLogMessage(synCtx));
                break;
            }
            case 2: {
                synLog.auditTrace(this.getLogMessage(synCtx));
                break;
            }
            case 1: {
                synLog.auditDebug(this.getLogMessage(synCtx));
                break;
            }
            case 3: {
                synLog.auditWarn(this.getLogMessage(synCtx));
                break;
            }
            case 4: {
                synLog.auditError(this.getLogMessage(synCtx));
                break;
            }
            case 5: {
                synLog.auditFatal(this.getLogMessage(synCtx));
            }
        }
        synLog.traceOrDebug("End : Log mediator");
        return true;
    }

    private String getLogMessage(MessageContext synCtx) {
        switch (this.logLevel) {
            case 0: {
                return this.getCustomLogMessage(synCtx);
            }
            case 1: {
                return this.getSimpleLogMessage(synCtx);
            }
            case 2: {
                return this.getHeadersLogMessage(synCtx);
            }
            case 3: {
                return this.getFullLogMessage(synCtx);
            }
        }
        return "Invalid log level specified";
    }

    private String getCustomLogMessage(MessageContext synCtx) {
        StringBuffer sb = new StringBuffer();
        this.setCustomProperties(sb, synCtx);
        return this.trimLeadingSeparator(sb);
    }

    private String getSimpleLogMessage(MessageContext synCtx) {
        StringBuffer sb = new StringBuffer();
        if (synCtx.getTo() != null) {
            sb.append("To: ").append(synCtx.getTo().getAddress());
        } else {
            sb.append("To: ");
        }
        if (synCtx.getFrom() != null) {
            sb.append(this.separator).append("From: ").append(synCtx.getFrom().getAddress());
        }
        if (synCtx.getWSAAction() != null) {
            sb.append(this.separator).append("WSAction: ").append(synCtx.getWSAAction());
        }
        if (synCtx.getSoapAction() != null) {
            sb.append(this.separator).append("SOAPAction: ").append(synCtx.getSoapAction());
        }
        if (synCtx.getReplyTo() != null) {
            sb.append(this.separator).append("ReplyTo: ").append(synCtx.getReplyTo().getAddress());
        }
        if (synCtx.getMessageID() != null) {
            sb.append(this.separator).append("MessageID: ").append(synCtx.getMessageID());
        }
        sb.append(this.separator).append("Direction: ").append(synCtx.isResponse() ? "response" : "request");
        this.setCustomProperties(sb, synCtx);
        return this.trimLeadingSeparator(sb);
    }

    private String getHeadersLogMessage(MessageContext synCtx) {
        SOAPHeader header;
        StringBuffer sb = new StringBuffer();
        if (synCtx.getEnvelope() != null && (header = synCtx.getEnvelope().getHeader()) != null) {
            Iterator iter = header.examineAllHeaderBlocks();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock headerBlk = (SOAPHeaderBlock)o;
                    sb.append(this.separator).append(headerBlk.getLocalName()).append(" : ").append(headerBlk.getText());
                    continue;
                }
                if (!(o instanceof OMElement)) continue;
                OMElement headerElem = (OMElement)o;
                sb.append(this.separator).append(headerElem.getLocalName()).append(" : ").append(headerElem.getText());
            }
        }
        this.setCustomProperties(sb, synCtx);
        return this.trimLeadingSeparator(sb);
    }

    private String getFullLogMessage(MessageContext synCtx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSimpleLogMessage(synCtx));
        if (synCtx.getEnvelope() != null) {
            sb.append(this.separator).append("Envelope: ").append(synCtx.getEnvelope());
        }
        return this.trimLeadingSeparator(sb);
    }

    private void setCustomProperties(StringBuffer sb, MessageContext synCtx) {
        if (this.properties != null && !this.properties.isEmpty()) {
            for (MediatorProperty property : this.properties) {
                if (property == null) continue;
                sb.append(this.separator).append(property.getName()).append(" = ").append(property.getValue() != null ? property.getValue() : property.getEvaluatedExpression(synCtx));
            }
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void addProperty(MediatorProperty p) {
        this.properties.add(p);
    }

    public void addAllProperties(List<MediatorProperty> list) {
        this.properties.addAll(list);
    }

    public List<MediatorProperty> getProperties() {
        return this.properties;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        if (category > 0 && category <= 5) {
            this.category = category;
        }
    }

    private String trimLeadingSeparator(StringBuffer sb) {
        String retStr = sb.toString();
        if (retStr.startsWith(this.separator)) {
            return retStr.substring(this.separator.length());
        }
        return retStr;
    }

    @Override
    public boolean isContentAware() {
        if (this.logLevel == 0) {
            for (MediatorProperty property : this.properties) {
                if (property.getExpression() == null || !property.getExpression().isContentAware()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

