/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.elementary;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Source {
    private SynapseXPath xpath = null;
    private String property = null;
    private int sourceType = 0;
    private boolean clone = true;
    private OMNode inlineOMNode = null;
    private String inlineKey = null;

    public ArrayList<OMNode> evaluate(MessageContext synCtx, SynapseLog synLog) throws JaxenException {
        ArrayList<OMNode> sourceNodeList = new ArrayList<OMNode>();
        if (this.sourceType == 0) {
            assert (this.xpath != null) : "XPath should be non null in case of CUSTOM";
            List selectedNodeList = this.xpath.selectNodes(synCtx);
            if (selectedNodeList != null && selectedNodeList.size() != 0) {
                for (Object o : selectedNodeList) {
                    if (o instanceof OMElement) {
                        if (this.clone) {
                            sourceNodeList.add((OMNode)((OMElement)o).cloneOMElement());
                            continue;
                        }
                        sourceNodeList.add((OMNode)((OMElement)o));
                        continue;
                    }
                    if (o instanceof OMText) {
                        sourceNodeList.add((OMNode)((OMText)o));
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    sourceNodeList.add((OMNode)fac.createOMText(o.toString()));
                }
            } else {
                synLog.error("Specified node by xpath cannot be found.");
            }
        } else if (this.sourceType == 2) {
            if (this.clone) {
                sourceNodeList.add((OMNode)synCtx.getEnvelope().getBody().getFirstElement().cloneOMElement());
            } else {
                sourceNodeList.add((OMNode)synCtx.getEnvelope().getBody().getFirstElement());
            }
        } else if (this.sourceType == 1) {
            if (this.clone) {
                sourceNodeList.add((OMNode)MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope()));
            } else {
                sourceNodeList.add((OMNode)synCtx.getEnvelope());
            }
        } else if (this.sourceType == 3) {
            assert (this.property != null) : "property shouldn't be null when type is PROPERTY";
            Object o = synCtx.getProperty(this.property);
            if (o instanceof OMElement) {
                if (this.clone) {
                    sourceNodeList.add((OMNode)((OMElement)o).cloneOMElement());
                } else {
                    sourceNodeList.add((OMNode)((OMElement)o));
                }
            } else if (o instanceof String) {
                String sourceStr = (String)o;
                OMFactory fac = OMAbstractFactory.getOMFactory();
                sourceNodeList.add((OMNode)fac.createOMText(sourceStr));
            } else if (o instanceof ArrayList) {
                ArrayList nodesList = (ArrayList)o;
                for (Object node : nodesList) {
                    if (node instanceof OMElement) {
                        if (node instanceof SOAPEnvelope) {
                            SOAPEnvelope soapEnvelope = (SOAPEnvelope)node;
                            soapEnvelope.getOrCreateHeader();
                            sourceNodeList.add((OMNode)soapEnvelope);
                            continue;
                        }
                        OMElement ele = (OMElement)node;
                        sourceNodeList.add((OMNode)ele);
                        continue;
                    }
                    if (!(node instanceof OMText)) continue;
                    sourceNodeList.add((OMNode)((OMText)node));
                }
            } else {
                synLog.error("Invalid source property type.");
            }
        } else if (this.sourceType == 4) {
            if (this.inlineOMNode instanceof OMElement) {
                OMElement inlineOMElement = (OMElement)this.inlineOMNode;
                if (inlineOMElement.getLocalName().equals("Envelope")) {
                    SOAPEnvelope soapEnvelope = this.getSOAPEnvFromOM(inlineOMElement);
                    if (soapEnvelope != null) {
                        sourceNodeList.add((OMNode)soapEnvelope);
                    } else {
                        synLog.error("Inline Source is not a valid SOAPEnvelope.");
                    }
                } else {
                    sourceNodeList.add((OMNode)inlineOMElement.cloneOMElement());
                }
            } else if (this.inlineOMNode instanceof OMText) {
                sourceNodeList.add(this.inlineOMNode);
            } else if (this.inlineKey != null) {
                Object inlineObj = synCtx.getEntry(this.inlineKey);
                if (inlineObj instanceof OMElement) {
                    if (((OMElement)inlineObj).getLocalName().equals("Envelope")) {
                        SOAPEnvelope soapEnvelope = this.getSOAPEnvFromOM((OMElement)inlineObj);
                        if (soapEnvelope != null) {
                            sourceNodeList.add((OMNode)soapEnvelope);
                        } else {
                            synLog.error("Specified Resource as Source is not a valid SOAPEnvelope.");
                        }
                    } else {
                        sourceNodeList.add((OMNode)((OMElement)inlineObj));
                    }
                } else if (inlineObj instanceof OMText) {
                    sourceNodeList.add((OMNode)((OMText)inlineObj));
                } else if (inlineObj instanceof String) {
                    sourceNodeList.add((OMNode)OMAbstractFactory.getOMFactory().createOMText(inlineObj.toString()));
                } else {
                    synLog.error("Specified Resource as Source is not valid.");
                }
            } else {
                synLog.error("Inline Source Content is not valid.");
            }
        }
        return sourceNodeList;
    }

    private SOAPEnvelope getSOAPEnvFromOM(OMElement inlineElement) {
        return OMXMLBuilderFactory.createStAXSOAPModelBuilder((XMLStreamReader)inlineElement.getXMLStreamReader()).getSOAPEnvelope();
    }

    public SynapseXPath getXpath() {
        return this.xpath;
    }

    public void setXpath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isClone() {
        return this.clone;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    public void setInlineOMNode(OMNode inlineOMNode) {
        this.inlineOMNode = inlineOMNode;
    }

    public OMNode getInlineOMNode() {
        return this.inlineOMNode;
    }

    public String getInlineKey() {
        return this.inlineKey;
    }

    public void setInlineKey(String inlineKey) {
        this.inlineKey = inlineKey;
    }
}

