/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisFault
extends RemoteException {
    private static final long serialVersionUID = -374933082062124907L;
    private List<SOAPHeaderBlock> headers = new ArrayList<SOAPHeaderBlock>(0);
    private String message;
    private List<FaultReason> faultReasonList = new ArrayList<FaultReason>(1);
    private QName faultCode;
    private List<QName> faultSubCodes;
    private String faultNode;
    private String faultRole;
    private List<OMElement> details;
    private SOAPFaultCode soapFaultCode;
    private SOAPFaultReason soapFaultReason;
    private SOAPFaultNode soapFaultNode;
    private SOAPFaultRole soapFaultRole;
    private SOAPFaultDetail soapFaultDetail;
    private MessageContext faultMessageContext;
    private String nodeURI;
    private String faultAction;
    private int faultType;

    public AxisFault(String message) {
        this.message = message;
        this.addReason(message);
    }

    public AxisFault(QName faultCode, String faultReason, Throwable cause) {
        this(faultReason, cause);
        this.setFaultCode(faultCode);
    }

    public AxisFault(QName faultCode, List<QName> faultSubCodes, String faultReason, Throwable cause) {
        this(faultReason, cause);
        this.setFaultCode(faultCode);
        this.setFaultSubCodes(faultSubCodes);
    }

    public AxisFault(QName faultCode, String faultReason, String faultNode, String faultRole, OMElement faultDetail) {
        this(faultReason, faultCode);
        this.faultNode = faultNode;
        this.faultRole = faultRole;
        this.setDetail(faultDetail);
    }

    public AxisFault(SOAPFaultCode soapFaultCode, SOAPFaultReason soapFaultReason, SOAPFaultNode soapFaultNode, SOAPFaultRole soapFaultRole, SOAPFaultDetail soapFaultDetail) {
        this.initializeValues(soapFaultCode, soapFaultReason, soapFaultNode, soapFaultRole, soapFaultDetail);
    }

    public AxisFault(SOAPFault fault) {
        this.initializeValues(fault);
    }

    public AxisFault(SOAPFault fault, MessageContext faultCtx) {
        this.initializeValues(fault);
        this.faultMessageContext = faultCtx;
    }

    private void initializeValues(SOAPFault fault) {
        if (fault != null) {
            this.initializeValues(fault.getCode(), fault.getReason(), fault.getNode(), fault.getRole(), fault.getDetail());
        }
    }

    private void initializeValues(SOAPFaultCode soapFaultCode, SOAPFaultReason soapFaultReason, SOAPFaultNode soapFaultNode, SOAPFaultRole soapFaultRole, SOAPFaultDetail soapFaultDetail) {
        this.soapFaultCode = soapFaultCode;
        this.soapFaultReason = soapFaultReason;
        this.soapFaultNode = soapFaultNode;
        this.soapFaultRole = soapFaultRole;
        this.soapFaultDetail = soapFaultDetail;
        if (soapFaultDetail != null) {
            this.details = new ArrayList<OMElement>();
            Iterator it = soapFaultDetail.getChildElements();
            while (it.hasNext()) {
                this.details.add((OMElement)it.next());
            }
        }
        if (soapFaultReason != null) {
            this.message = soapFaultReason.getText();
        }
        if (soapFaultCode != null) {
            this.faultCode = soapFaultCode.getValueAsQName();
            SOAPFaultSubCode subCode = soapFaultCode.getSubCode();
            if (subCode != null) {
                this.faultSubCodes = new ArrayList<QName>();
                while (subCode != null) {
                    this.faultSubCodes.add(subCode.getValueAsQName());
                    subCode = subCode.getSubCode();
                }
            }
        }
    }

    protected AxisFault(Throwable cause) {
        this(cause != null ? cause.getMessage() : null, cause);
    }

    public AxisFault(String messageText, String faultCode) {
        this(messageText);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String messageText, QName faultCode) {
        this(messageText);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String message, Throwable cause) {
        super(message, cause);
        if (message != null) {
            this.addReason(message);
            this.message = message;
        }
    }

    public AxisFault(String messageText, QName faultCode, Throwable cause) {
        this(messageText, cause);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String message, MessageContext faultMessageContext, Throwable cause) {
        super(message, cause);
        this.faultMessageContext = faultMessageContext;
    }

    public AxisFault(String messageText, String faultCode, Throwable cause) {
        this(messageText, cause);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String message, MessageContext faultMessageContext) {
        this(message);
        this.faultMessageContext = faultMessageContext;
    }

    public void addHeader(SOAPHeaderBlock header) {
        this.headers.add(header);
    }

    public void addReason(String text) {
        this.faultReasonList.add(new FaultReason(text, ""));
    }

    public void addReason(String text, String language) {
        this.faultReasonList.add(new FaultReason(text, language));
    }

    public String getReason() {
        if (this.faultReasonList.size() >= 1) {
            return this.faultReasonList.get(0).getText();
        }
        if (this.soapFaultReason != null) {
            return this.soapFaultReason.getText();
        }
        return null;
    }

    public ListIterator<SOAPHeaderBlock> headerIterator() {
        return this.headers.listIterator();
    }

    public List<SOAPHeaderBlock> headers() {
        return this.headers;
    }

    public static AxisFault makeFault(Throwable e) {
        Throwable t;
        if (e instanceof InvocationTargetException) {
            return AxisFault.makeFault(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof UndeclaredThrowableException && (t = ((UndeclaredThrowableException)e).getCause()) instanceof Exception) {
            e = t;
        }
        if (e instanceof AxisFault) {
            return (AxisFault)e;
        }
        return new AxisFault(e);
    }

    public OMElement getDetail() {
        return this.details == null || this.details.isEmpty() ? null : this.details.get(0);
    }

    public List<OMElement> getDetails() {
        return this.details;
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public List<QName> getFaultSubCodes() {
        return this.faultSubCodes;
    }

    public SOAPFaultCode getFaultCodeElement() {
        return this.soapFaultCode;
    }

    public SOAPFaultReason getFaultReasonElement() {
        return this.soapFaultReason;
    }

    public SOAPFaultNode getFaultNodeElement() {
        return this.soapFaultNode;
    }

    public SOAPFaultRole getFaultRoleElement() {
        return this.soapFaultRole;
    }

    public SOAPFaultDetail getFaultDetailElement() {
        return this.soapFaultDetail;
    }

    public String getNodeURI() {
        return this.nodeURI;
    }

    public void setDetail(OMElement detail) {
        this.details = new ArrayList<OMElement>();
        this.details.add(detail);
    }

    public void setDetails(List<OMElement> details) {
        this.details = details;
    }

    public void setFaultCode(QName soapFaultCode) {
        this.faultCode = soapFaultCode;
    }

    public void setFaultSubCodes(List<QName> faultSubCodes) {
        this.faultSubCodes = faultSubCodes;
    }

    public void setFaultCode(String soapFaultCode) {
        this.faultCode = new QName(soapFaultCode);
    }

    public void setNodeURI(String nodeURI) {
        this.nodeURI = nodeURI;
    }

    public String getFaultNode() {
        return this.faultNode;
    }

    public String getFaultRole() {
        return this.faultRole;
    }

    public MessageContext getFaultMessageContext() {
        return this.faultMessageContext;
    }

    public String getFaultAction() {
        return this.faultAction;
    }

    public void setFaultAction(String faultAction) {
        this.faultAction = faultAction;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getFaultType() {
        return this.faultType;
    }

    public void setFaultType(int faultType) {
        this.faultType = faultType;
    }

    class FaultReason
    implements Serializable {
        private static final long serialVersionUID = -8125991422614607169L;
        private String language = "";
        private String text;

        public FaultReason() {
        }

        public FaultReason(String text, String language) {
            this.text = text;
            this.language = language;
        }

        public String toString() {
            return this.text;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getText() {
            return this.text;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

