/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.xquery;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.xquery.MediatorBaseVariable;
import org.apache.synapse.mediators.xquery.MediatorCustomVariable;
import org.apache.synapse.mediators.xquery.MediatorVariable;
import org.apache.synapse.mediators.xquery.XQueryMediator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public class XQueryMediatorFactory
extends AbstractMediatorFactory {
    private static final Log log = LogFactory.getLog(XQueryMediatorFactory.class);
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "xquery");
    public static final QName ATT_NAME_Q = new QName("", "name");
    public static final QName ATT_VALUE_Q = new QName("", "value");
    public static final QName ATT_EXPR_Q = new QName("", "expression");
    public static final QName ATT_KEY_Q = new QName("", "key");
    public static final QName ATT_TYPE_Q = new QName("", "type");

    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        String targetValue;
        XQueryMediator xQueryMediator = new XQueryMediator();
        OMAttribute xqueryKey = elem.getAttribute(new QName("", "key"));
        OMAttribute attrTarget = elem.getAttribute(new QName("", "target"));
        if (xqueryKey != null) {
            ValueFactory keyFac = new ValueFactory();
            Value generatedKey = keyFac.createValue("key", elem);
            if (generatedKey != null) {
                xQueryMediator.setQueryKey(generatedKey);
            } else {
                this.handleException("The 'key' attribute is required for the XQuery mediator");
            }
        } else {
            this.handleException("The 'key' attribute is required for the XQuery mediator");
        }
        if (attrTarget != null && (targetValue = attrTarget.getAttributeValue()) != null && !"".equals(targetValue)) {
            try {
                xQueryMediator.setTarget(SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_TARGET));
            }
            catch (JaxenException e) {
                this.handleException("Invalid XPath specified for the target attribute : " + targetValue);
            }
        }
        this.processAuditStatus((Mediator)xQueryMediator, elem);
        OMElement dataSource = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "dataSource"));
        if (dataSource != null) {
            xQueryMediator.addAllDataSourceProperties(MediatorPropertyFactory.getMediatorProperties((OMElement)dataSource));
        }
        Iterator it = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "variable"));
        while (it.hasNext()) {
            MediatorVariable variable;
            String type;
            OMElement variableOM = (OMElement)it.next();
            String name = variableOM.getAttributeValue(ATT_NAME_Q);
            if (name == null || "".equals(name) || (type = variableOM.getAttributeValue(ATT_TYPE_Q)) == null || "".equals(type)) continue;
            String value = variableOM.getAttributeValue(ATT_VALUE_Q);
            if (value != null && !"".equals(value)) {
                variable = new MediatorBaseVariable(new QName(name.trim()));
                variable.setValue(value.trim());
            } else {
                String key = variableOM.getAttributeValue(ATT_KEY_Q);
                String expr = variableOM.getAttributeValue(ATT_EXPR_Q);
                variable = new MediatorCustomVariable(new QName(name.trim()));
                if (key != null) {
                    ((MediatorCustomVariable)variable).setRegKey(key.trim());
                }
                if (expr != null && !"".equals(expr)) {
                    try {
                        SynapseXPath xpath = new SynapseXPath(expr);
                        OMElementUtils.addNameSpaces((XPath)xpath, (OMElement)variableOM, (Log)log);
                        ((MediatorCustomVariable)variable).setExpression(xpath);
                    }
                    catch (JaxenException e) {
                        this.handleException("Invalid XPath specified for the expression attribute : " + expr);
                    }
                }
            }
            if ("INT".equals(type.trim())) {
                variable.setType(13);
            } else if ("INTEGER".equals(type.trim())) {
                variable.setType(14);
            } else if ("BOOLEAN".equals(type.trim())) {
                variable.setType(11);
            } else if ("BYTE".equals(type.trim())) {
                variable.setType(32);
            } else if ("DOUBLE".equals(type.trim())) {
                variable.setType(19);
            } else if ("SHORT".equals(type.trim())) {
                variable.setType(15);
            } else if ("LONG".equals(type.trim())) {
                variable.setType(16);
            } else if ("FLOAT".equals(type.trim())) {
                variable.setType(21);
            } else if ("STRING".equals(type.trim())) {
                variable.setType(30);
            } else if ("DOCUMENT".equals(type.trim())) {
                variable.setType(4);
            } else if ("DOCUMENT_ELEMENT".equals(type.trim())) {
                variable.setType(5);
            } else if ("ELEMENT".equals(type.trim())) {
                variable.setType(6);
            } else {
                this.handleException("Unsupported Type");
            }
            xQueryMediator.addVariable(variable);
        }
        return xQueryMediator;
    }

    public QName getTagQName() {
        return TAG_NAME;
    }
}

