/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.search.FIQLQueries;
import org.apache.syncope.client.console.panels.search.SaveFIQLQuery;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.FIQLQueryRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.SearchableFields;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchPanel
extends Panel {
    private static final long serialVersionUID = 5922413053568696414L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSearchPanel.class);
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected FIQLQueryRestClient fiqlQueryRestClient;
    @SpringBean
    protected GroupRestClient groupRestClient;
    protected IModel<Map<String, PlainSchemaTO>> dnames;
    protected IModel<Map<String, PlainSchemaTO>> anames;
    protected IModel<List<String>> auxClassNames;
    protected IModel<List<String>> resourceNames;
    protected IModel<List<SearchClause.Type>> types;
    protected IModel<List<String>> groupNames;
    protected IModel<List<String>> roleNames;
    protected IModel<List<SearchClause>> model;
    protected WebMarkupContainer searchFormContainer;
    protected final AnyTypeKind typeKind;
    protected final String anyType;

    protected AbstractSearchPanel(String id, AnyTypeKind kind, Builder<?> builder) {
        this(id, kind, kind.name(), builder);
    }

    protected AbstractSearchPanel(String id, AnyTypeKind kind, final String type, Builder<?> builder) {
        super(id);
        this.populate();
        this.model = builder.model;
        this.typeKind = kind;
        this.anyType = type;
        this.setOutputMarkupId(true);
        this.searchFormContainer = new WebMarkupContainer("searchFormContainer");
        this.searchFormContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.searchFormContainer});
        Pair groupInfo = this.typeKind != AnyTypeKind.GROUP && SyncopeConsoleSession.get().owns("GROUP_SEARCH", new String[0]) ? Pair.of(this.groupNames, (Object)new LoadableDetachableModel<Long>(){
            private static final long serialVersionUID = 7362833782319137329L;

            protected Long load() {
                return AbstractSearchPanel.this.groupRestClient.count("/", null);
            }
        }) : Pair.of(this.groupNames, (Object)Model.of((Serializable)Long.valueOf(0L)));
        SearchClausePanel searchClausePanel = new SearchClausePanel("panel", "panel", (Model<SearchClause>)Model.of((Serializable)new SearchClause()), builder.required, this.types, builder.customizer, this.anames, this.dnames, (Pair<IModel<List<String>>, IModel<Long>>)groupInfo, this.roleNames, this.auxClassNames, this.resourceNames);
        if (builder.enableSearch) {
            searchClausePanel.enableSearch(builder.resultContainer);
        }
        this.searchFormContainer.add(new Component[]{new MultiFieldPanel.Builder<SearchClause>(this.model){
            private static final long serialVersionUID = 1343431509987473047L;

            protected SearchClause newModelObject() {
                return new SearchClause();
            }
        }.build("search", "search", (FieldPanel)searchClausePanel).hideLabel().setOutputMarkupId(true)});
        final FIQLQueries fiqlQueries = new FIQLQueries("fiqlQueries", this.fiqlQueryRestClient, this, this.getFIQLQueryTarget(), builder.pageRef);
        this.add(new Component[]{fiqlQueries});
        final SaveFIQLQuery saveFIQLQuery = new SaveFIQLQuery("saveFIQLQuery", this.getFIQLQueryTarget(), builder.pageRef);
        this.add(new Component[]{saveFIQLQuery});
        ActionsPanel fiqlQueryActionsPanel = new ActionsPanel("fiqlQueryActionsPanel", null);
        fiqlQueryActionsPanel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 2041211756396714619L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                Optional.ofNullable(SearchUtils.buildFIQL((List)AbstractSearchPanel.this.getModel().getObject(), AbstractSearchPanel.this.getSearchConditionBuilder())).ifPresentOrElse(fiql -> saveFIQLQuery.setFiql(fiql.replaceAll(SearchUtils.getTypeConditionPattern(type).pattern(), "")), () -> saveFIQLQuery.setFiql(null));
                saveFIQLQuery.toggle(target, true);
            }
        }, ActionLink.ActionType.EXPORT, "").hideLabel();
        fiqlQueryActionsPanel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                fiqlQueries.toggle(target, true);
            }
        }, ActionLink.ActionType.SELECT, "").hideLabel();
        fiqlQueryActionsPanel.setVisible(builder.enableSearch && !((List)this.model.getObject()).isEmpty() && !SyncopeConsoleSession.get().getSelfTO().getUsername().equals(SyncopeWebApplication.get().getAdminUser()));
        this.add(new Component[]{fiqlQueryActionsPanel.setOutputMarkupPlaceholderTag(true)});
    }

    protected abstract AbstractFiqlSearchConditionBuilder<?, ?, ?> getSearchConditionBuilder();

    protected abstract String getFIQLQueryTarget();

    protected void updateFIQL(AjaxRequestTarget target, String fiql) {
        this.model.setObject(SearchUtils.getSearchClauses(fiql.replaceAll(SearchUtils.getTypeConditionPattern(this.anyType).pattern(), "")));
        target.add(new Component[]{this.searchFormContainer});
    }

    protected void populate() {
        this.dnames = new LoadableDetachableModel<Map<String, PlainSchemaTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<String, PlainSchemaTO> load() {
                HashMap<String, PlainSchemaTO> dSchemaNames = new HashMap<String, PlainSchemaTO>();
                SearchableFields.get((Class)AbstractSearchPanel.this.typeKind.getTOClass()).forEach((key, type) -> {
                    PlainSchemaTO plainSchema = new PlainSchemaTO();
                    plainSchema.setType(type);
                    plainSchema.setKey(key);
                    dSchemaNames.put((String)key, plainSchema);
                });
                return dSchemaNames;
            }
        };
        this.auxClassNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return AbstractSearchPanel.this.anyTypeClassRestClient.list().stream().filter(c -> c.getInUseByTypes().isEmpty()).map(AnyTypeClassTO::getKey).collect(Collectors.toList());
            }
        };
        this.resourceNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return SyncopeWebApplication.get().getResourceProvider().get(AbstractSearchPanel.this.anyType);
            }
        };
    }

    public IModel<List<SearchClause>> getModel() {
        return this.model;
    }

    public String getAnyType() {
        return this.anyType;
    }

    public Map<String, PlainSchemaTO> getAvailableSchemaTypes() {
        return (Map)this.anames.getObject();
    }

    public static abstract class Builder<T extends AbstractSearchPanel>
    implements Serializable {
        private static final long serialVersionUID = 6308997285778809578L;
        protected final IModel<List<SearchClause>> model;
        protected PageReference pageRef;
        protected boolean required = true;
        protected boolean enableSearch = false;
        protected SearchClausePanel.Customizer customizer = new SearchClausePanel.Customizer(){
            private static final long serialVersionUID = 4449199405807453441L;
        };
        protected IEventSink resultContainer;

        public Builder(IModel<List<SearchClause>> model, PageReference pageRef) {
            this.model = model;
            this.pageRef = pageRef;
        }

        public Builder<T> enableSearch(IEventSink resultContainer) {
            this.resultContainer = resultContainer;
            return this.enableSearch();
        }

        public Builder<T> enableSearch() {
            this.enableSearch = true;
            return this;
        }

        public Builder<T> customizer(SearchClausePanel.Customizer customizer) {
            this.customizer = customizer;
            return this;
        }

        public Builder<T> required(boolean required) {
            this.required = required;
            return this;
        }

        public abstract T build(String var1);
    }
}

