/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.services.BaseWebBasedRegisteredService;

public class SamlRegisteredService
extends BaseWebBasedRegisteredService {
    public static final String FRIENDLY_NAME = "SAML2 Service Provider";
    private static final long serialVersionUID = 1218757374062931021L;
    @ExpressionLanguageCapable
    private String metadataLocation;
    @ExpressionLanguageCapable
    private String idpMetadataLocation;
    private String metadataProxyLocation;
    private long metadataMaxValidity;
    @ExpressionLanguageCapable
    private String requiredAuthenticationContextClass;
    private String metadataCriteriaDirection = "INCLUDE";
    private String metadataCriteriaPattern;
    private Map<String, List<String>> metadataCriteriaEntityAttributes = new HashMap<String, List<String>>();
    private String requiredNameIdFormat;
    @ExpressionLanguageCapable
    private String metadataSignatureLocation;
    @JacksonInject(value="logoutResponseEnabled")
    private boolean logoutResponseEnabled = true;
    private String logoutResponseBinding;
    private boolean requireSignedRoot = true;
    private String subjectLocality;
    private String serviceProviderNameIdQualifier;
    private String nameIdQualifier;
    private String metadataExpirationDuration = "PT60M";
    private String signingCredentialFingerprint;
    private String issuerEntityId;
    private String signingKeyAlgorithm;
    @JsonDeserialize(using=TriStateBoolean.Deserializer.class)
    @JacksonInject(value="signAssertions")
    private TriStateBoolean signAssertions = TriStateBoolean.FALSE;
    @JacksonInject(value="signUnsolicitedAuthnRequest")
    private boolean signUnsolicitedAuthnRequest;
    @JacksonInject(value="skipGeneratingAssertionNameId")
    private boolean skipGeneratingAssertionNameId;
    @JacksonInject(value="skipGeneratingSubjectConfirmationInResponseTo")
    private boolean skipGeneratingSubjectConfirmationInResponseTo;
    @JacksonInject(value="isSkipGeneratingResponseInResponseTo")
    private boolean isSkipGeneratingResponseInResponseTo;
    @JacksonInject(value="skipGeneratingSubjectConfirmationNotOnOrAfter")
    private boolean skipGeneratingSubjectConfirmationNotOnOrAfter;
    @JacksonInject(value="skipGeneratingSubjectConfirmationRecipient")
    private boolean skipGeneratingSubjectConfirmationRecipient;
    @JacksonInject(value="skipGeneratingSubjectConfirmationAddress")
    private boolean skipGeneratingSubjectConfirmationAddress;
    @JacksonInject(value="skipGeneratingSubjectConfirmationNotBefore")
    private boolean skipGeneratingSubjectConfirmationNotBefore = true;
    @JacksonInject(value="skipGeneratingSubjectConfirmationNameId")
    private boolean skipGeneratingSubjectConfirmationNameId = true;
    @JacksonInject(value="skipGeneratingNameIdQualifiers")
    private boolean skipGeneratingNameIdQualifiers;
    @JacksonInject(value="skipGeneratingTransientNameId")
    private boolean skipGeneratingTransientNameId;
    @JacksonInject(value="skipValidatingAuthnRequest")
    private boolean skipValidatingAuthnRequest;
    @JacksonInject(value="skipGeneratingServiceProviderNameIdQualifier")
    private boolean skipGeneratingServiceProviderNameIdQualifier;
    @JacksonInject(value="skipGeneratingAuthenticatingAuthority")
    private boolean skipGeneratingAuthenticatingAuthority;
    @JacksonInject(value="skipGeneratingNameIdQualifier")
    private boolean skipGeneratingNameIdQualifier;
    @JacksonInject(value="skipGeneratingSessionNotOnOrAfter")
    private boolean skipGeneratingSessionNotOnOrAfter;
    @JsonDeserialize(using=TriStateBoolean.Deserializer.class)
    @JacksonInject(value="signResponses")
    private TriStateBoolean signResponses = TriStateBoolean.TRUE;
    @JsonDeserialize(using=TriStateBoolean.Deserializer.class)
    @JacksonInject(value="signLogoutResponse")
    private TriStateBoolean signLogoutResponse = TriStateBoolean.UNDEFINED;
    @JacksonInject(value="encryptAssertions")
    private boolean encryptAssertions;
    @JacksonInject(value="encryptAttributes")
    private boolean encryptAttributes;
    @JacksonInject(value="encryptionOptional")
    private boolean encryptionOptional;
    private String metadataCriteriaRoles = "SPSSODescriptor";
    private boolean metadataCriteriaRemoveEmptyEntitiesDescriptors = true;
    private boolean metadataCriteriaRemoveRolelessEntityDescriptors = true;
    private String signingCredentialType;
    private String assertionAudiences;
    private int skewAllowance;
    private String whiteListBlackListPrecedence;
    private Map<String, String> attributeNameFormats = new TreeMap<String, String>();
    private Map<String, String> attributeFriendlyNames = new TreeMap<String, String>();
    private Map<String, String> attributeValueTypes = new TreeMap<String, String>();
    private Set<String> encryptableAttributes = new HashSet<String>(0);
    private List<String> signingSignatureReferenceDigestMethods = new ArrayList<String>();
    private List<String> signingSignatureAlgorithms = new ArrayList<String>();
    private List<String> signingSignatureBlackListedAlgorithms = new ArrayList<String>();
    private List<String> signingSignatureWhiteListedAlgorithms = new ArrayList<String>();
    private String signingSignatureCanonicalizationAlgorithm;
    private List<String> encryptionDataAlgorithms = new ArrayList<String>();
    private List<String> encryptionKeyAlgorithms = new ArrayList<String>();
    private List<String> encryptionBlackListedAlgorithms = new ArrayList<String>();
    private List<String> encryptionWhiteListedAlgorithms = new ArrayList<String>();

    @JsonIgnore
    public String getFriendlyName() {
        return FRIENDLY_NAME;
    }

    @JsonIgnore
    public int getEvaluationPriority() {
        return 0;
    }

    @Generated
    public String toString() {
        return "SamlRegisteredService(super=" + super.toString() + ", metadataLocation=" + this.metadataLocation + ", idpMetadataLocation=" + this.idpMetadataLocation + ", metadataProxyLocation=" + this.metadataProxyLocation + ", metadataMaxValidity=" + this.metadataMaxValidity + ", requiredAuthenticationContextClass=" + this.requiredAuthenticationContextClass + ", metadataCriteriaDirection=" + this.metadataCriteriaDirection + ", metadataCriteriaPattern=" + this.metadataCriteriaPattern + ", metadataCriteriaEntityAttributes=" + String.valueOf(this.metadataCriteriaEntityAttributes) + ", requiredNameIdFormat=" + this.requiredNameIdFormat + ", metadataSignatureLocation=" + this.metadataSignatureLocation + ", logoutResponseEnabled=" + this.logoutResponseEnabled + ", logoutResponseBinding=" + this.logoutResponseBinding + ", requireSignedRoot=" + this.requireSignedRoot + ", subjectLocality=" + this.subjectLocality + ", serviceProviderNameIdQualifier=" + this.serviceProviderNameIdQualifier + ", nameIdQualifier=" + this.nameIdQualifier + ", metadataExpirationDuration=" + this.metadataExpirationDuration + ", signingCredentialFingerprint=" + this.signingCredentialFingerprint + ", issuerEntityId=" + this.issuerEntityId + ", signingKeyAlgorithm=" + this.signingKeyAlgorithm + ", signAssertions=" + String.valueOf(this.signAssertions) + ", signUnsolicitedAuthnRequest=" + this.signUnsolicitedAuthnRequest + ", skipGeneratingAssertionNameId=" + this.skipGeneratingAssertionNameId + ", skipGeneratingSubjectConfirmationInResponseTo=" + this.skipGeneratingSubjectConfirmationInResponseTo + ", isSkipGeneratingResponseInResponseTo=" + this.isSkipGeneratingResponseInResponseTo + ", skipGeneratingSubjectConfirmationNotOnOrAfter=" + this.skipGeneratingSubjectConfirmationNotOnOrAfter + ", skipGeneratingSubjectConfirmationRecipient=" + this.skipGeneratingSubjectConfirmationRecipient + ", skipGeneratingSubjectConfirmationAddress=" + this.skipGeneratingSubjectConfirmationAddress + ", skipGeneratingSubjectConfirmationNotBefore=" + this.skipGeneratingSubjectConfirmationNotBefore + ", skipGeneratingSubjectConfirmationNameId=" + this.skipGeneratingSubjectConfirmationNameId + ", skipGeneratingNameIdQualifiers=" + this.skipGeneratingNameIdQualifiers + ", skipGeneratingTransientNameId=" + this.skipGeneratingTransientNameId + ", skipValidatingAuthnRequest=" + this.skipValidatingAuthnRequest + ", skipGeneratingServiceProviderNameIdQualifier=" + this.skipGeneratingServiceProviderNameIdQualifier + ", skipGeneratingAuthenticatingAuthority=" + this.skipGeneratingAuthenticatingAuthority + ", skipGeneratingNameIdQualifier=" + this.skipGeneratingNameIdQualifier + ", skipGeneratingSessionNotOnOrAfter=" + this.skipGeneratingSessionNotOnOrAfter + ", signResponses=" + String.valueOf(this.signResponses) + ", signLogoutResponse=" + String.valueOf(this.signLogoutResponse) + ", encryptAssertions=" + this.encryptAssertions + ", encryptAttributes=" + this.encryptAttributes + ", encryptionOptional=" + this.encryptionOptional + ", metadataCriteriaRoles=" + this.metadataCriteriaRoles + ", metadataCriteriaRemoveEmptyEntitiesDescriptors=" + this.metadataCriteriaRemoveEmptyEntitiesDescriptors + ", metadataCriteriaRemoveRolelessEntityDescriptors=" + this.metadataCriteriaRemoveRolelessEntityDescriptors + ", signingCredentialType=" + this.signingCredentialType + ", assertionAudiences=" + this.assertionAudiences + ", skewAllowance=" + this.skewAllowance + ", whiteListBlackListPrecedence=" + this.whiteListBlackListPrecedence + ", attributeNameFormats=" + String.valueOf(this.attributeNameFormats) + ", attributeFriendlyNames=" + String.valueOf(this.attributeFriendlyNames) + ", attributeValueTypes=" + String.valueOf(this.attributeValueTypes) + ", encryptableAttributes=" + String.valueOf(this.encryptableAttributes) + ", signingSignatureReferenceDigestMethods=" + String.valueOf(this.signingSignatureReferenceDigestMethods) + ", signingSignatureAlgorithms=" + String.valueOf(this.signingSignatureAlgorithms) + ", signingSignatureBlackListedAlgorithms=" + String.valueOf(this.signingSignatureBlackListedAlgorithms) + ", signingSignatureWhiteListedAlgorithms=" + String.valueOf(this.signingSignatureWhiteListedAlgorithms) + ", signingSignatureCanonicalizationAlgorithm=" + this.signingSignatureCanonicalizationAlgorithm + ", encryptionDataAlgorithms=" + String.valueOf(this.encryptionDataAlgorithms) + ", encryptionKeyAlgorithms=" + String.valueOf(this.encryptionKeyAlgorithms) + ", encryptionBlackListedAlgorithms=" + String.valueOf(this.encryptionBlackListedAlgorithms) + ", encryptionWhiteListedAlgorithms=" + String.valueOf(this.encryptionWhiteListedAlgorithms) + ")";
    }

    @Generated
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    @Generated
    public String getIdpMetadataLocation() {
        return this.idpMetadataLocation;
    }

    @Generated
    public String getMetadataProxyLocation() {
        return this.metadataProxyLocation;
    }

    @Generated
    public long getMetadataMaxValidity() {
        return this.metadataMaxValidity;
    }

    @Generated
    public String getRequiredAuthenticationContextClass() {
        return this.requiredAuthenticationContextClass;
    }

    @Generated
    public String getMetadataCriteriaDirection() {
        return this.metadataCriteriaDirection;
    }

    @Generated
    public String getMetadataCriteriaPattern() {
        return this.metadataCriteriaPattern;
    }

    @Generated
    public Map<String, List<String>> getMetadataCriteriaEntityAttributes() {
        return this.metadataCriteriaEntityAttributes;
    }

    @Generated
    public String getRequiredNameIdFormat() {
        return this.requiredNameIdFormat;
    }

    @Generated
    public String getMetadataSignatureLocation() {
        return this.metadataSignatureLocation;
    }

    @Generated
    public boolean isLogoutResponseEnabled() {
        return this.logoutResponseEnabled;
    }

    @Generated
    public String getLogoutResponseBinding() {
        return this.logoutResponseBinding;
    }

    @Generated
    public boolean isRequireSignedRoot() {
        return this.requireSignedRoot;
    }

    @Generated
    public String getSubjectLocality() {
        return this.subjectLocality;
    }

    @Generated
    public String getServiceProviderNameIdQualifier() {
        return this.serviceProviderNameIdQualifier;
    }

    @Generated
    public String getNameIdQualifier() {
        return this.nameIdQualifier;
    }

    @Generated
    public String getMetadataExpirationDuration() {
        return this.metadataExpirationDuration;
    }

    @Generated
    public String getSigningCredentialFingerprint() {
        return this.signingCredentialFingerprint;
    }

    @Generated
    public String getIssuerEntityId() {
        return this.issuerEntityId;
    }

    @Generated
    public String getSigningKeyAlgorithm() {
        return this.signingKeyAlgorithm;
    }

    @Generated
    public TriStateBoolean getSignAssertions() {
        return this.signAssertions;
    }

    @Generated
    public boolean isSignUnsolicitedAuthnRequest() {
        return this.signUnsolicitedAuthnRequest;
    }

    @Generated
    public boolean isSkipGeneratingAssertionNameId() {
        return this.skipGeneratingAssertionNameId;
    }

    @Generated
    public boolean isSkipGeneratingSubjectConfirmationInResponseTo() {
        return this.skipGeneratingSubjectConfirmationInResponseTo;
    }

    @Generated
    public boolean isSkipGeneratingResponseInResponseTo() {
        return this.isSkipGeneratingResponseInResponseTo;
    }

    @Generated
    public boolean isSkipGeneratingSubjectConfirmationNotOnOrAfter() {
        return this.skipGeneratingSubjectConfirmationNotOnOrAfter;
    }

    @Generated
    public boolean isSkipGeneratingSubjectConfirmationRecipient() {
        return this.skipGeneratingSubjectConfirmationRecipient;
    }

    @Generated
    public boolean isSkipGeneratingSubjectConfirmationAddress() {
        return this.skipGeneratingSubjectConfirmationAddress;
    }

    @Generated
    public boolean isSkipGeneratingSubjectConfirmationNotBefore() {
        return this.skipGeneratingSubjectConfirmationNotBefore;
    }

    @Generated
    public boolean isSkipGeneratingSubjectConfirmationNameId() {
        return this.skipGeneratingSubjectConfirmationNameId;
    }

    @Generated
    public boolean isSkipGeneratingNameIdQualifiers() {
        return this.skipGeneratingNameIdQualifiers;
    }

    @Generated
    public boolean isSkipGeneratingTransientNameId() {
        return this.skipGeneratingTransientNameId;
    }

    @Generated
    public boolean isSkipValidatingAuthnRequest() {
        return this.skipValidatingAuthnRequest;
    }

    @Generated
    public boolean isSkipGeneratingServiceProviderNameIdQualifier() {
        return this.skipGeneratingServiceProviderNameIdQualifier;
    }

    @Generated
    public boolean isSkipGeneratingAuthenticatingAuthority() {
        return this.skipGeneratingAuthenticatingAuthority;
    }

    @Generated
    public boolean isSkipGeneratingNameIdQualifier() {
        return this.skipGeneratingNameIdQualifier;
    }

    @Generated
    public boolean isSkipGeneratingSessionNotOnOrAfter() {
        return this.skipGeneratingSessionNotOnOrAfter;
    }

    @Generated
    public TriStateBoolean getSignResponses() {
        return this.signResponses;
    }

    @Generated
    public TriStateBoolean getSignLogoutResponse() {
        return this.signLogoutResponse;
    }

    @Generated
    public boolean isEncryptAssertions() {
        return this.encryptAssertions;
    }

    @Generated
    public boolean isEncryptAttributes() {
        return this.encryptAttributes;
    }

    @Generated
    public boolean isEncryptionOptional() {
        return this.encryptionOptional;
    }

    @Generated
    public String getMetadataCriteriaRoles() {
        return this.metadataCriteriaRoles;
    }

    @Generated
    public boolean isMetadataCriteriaRemoveEmptyEntitiesDescriptors() {
        return this.metadataCriteriaRemoveEmptyEntitiesDescriptors;
    }

    @Generated
    public boolean isMetadataCriteriaRemoveRolelessEntityDescriptors() {
        return this.metadataCriteriaRemoveRolelessEntityDescriptors;
    }

    @Generated
    public String getSigningCredentialType() {
        return this.signingCredentialType;
    }

    @Generated
    public String getAssertionAudiences() {
        return this.assertionAudiences;
    }

    @Generated
    public int getSkewAllowance() {
        return this.skewAllowance;
    }

    @Generated
    public String getWhiteListBlackListPrecedence() {
        return this.whiteListBlackListPrecedence;
    }

    @Generated
    public Map<String, String> getAttributeNameFormats() {
        return this.attributeNameFormats;
    }

    @Generated
    public Map<String, String> getAttributeFriendlyNames() {
        return this.attributeFriendlyNames;
    }

    @Generated
    public Map<String, String> getAttributeValueTypes() {
        return this.attributeValueTypes;
    }

    @Generated
    public Set<String> getEncryptableAttributes() {
        return this.encryptableAttributes;
    }

    @Generated
    public List<String> getSigningSignatureReferenceDigestMethods() {
        return this.signingSignatureReferenceDigestMethods;
    }

    @Generated
    public List<String> getSigningSignatureAlgorithms() {
        return this.signingSignatureAlgorithms;
    }

    @Generated
    public List<String> getSigningSignatureBlackListedAlgorithms() {
        return this.signingSignatureBlackListedAlgorithms;
    }

    @Generated
    public List<String> getSigningSignatureWhiteListedAlgorithms() {
        return this.signingSignatureWhiteListedAlgorithms;
    }

    @Generated
    public String getSigningSignatureCanonicalizationAlgorithm() {
        return this.signingSignatureCanonicalizationAlgorithm;
    }

    @Generated
    public List<String> getEncryptionDataAlgorithms() {
        return this.encryptionDataAlgorithms;
    }

    @Generated
    public List<String> getEncryptionKeyAlgorithms() {
        return this.encryptionKeyAlgorithms;
    }

    @Generated
    public List<String> getEncryptionBlackListedAlgorithms() {
        return this.encryptionBlackListedAlgorithms;
    }

    @Generated
    public List<String> getEncryptionWhiteListedAlgorithms() {
        return this.encryptionWhiteListedAlgorithms;
    }

    @Generated
    public void setMetadataLocation(String metadataLocation) {
        this.metadataLocation = metadataLocation;
    }

    @Generated
    public void setIdpMetadataLocation(String idpMetadataLocation) {
        this.idpMetadataLocation = idpMetadataLocation;
    }

    @Generated
    public void setMetadataProxyLocation(String metadataProxyLocation) {
        this.metadataProxyLocation = metadataProxyLocation;
    }

    @Generated
    public void setMetadataMaxValidity(long metadataMaxValidity) {
        this.metadataMaxValidity = metadataMaxValidity;
    }

    @Generated
    public void setRequiredAuthenticationContextClass(String requiredAuthenticationContextClass) {
        this.requiredAuthenticationContextClass = requiredAuthenticationContextClass;
    }

    @Generated
    public void setMetadataCriteriaDirection(String metadataCriteriaDirection) {
        this.metadataCriteriaDirection = metadataCriteriaDirection;
    }

    @Generated
    public void setMetadataCriteriaPattern(String metadataCriteriaPattern) {
        this.metadataCriteriaPattern = metadataCriteriaPattern;
    }

    @Generated
    public void setMetadataCriteriaEntityAttributes(Map<String, List<String>> metadataCriteriaEntityAttributes) {
        this.metadataCriteriaEntityAttributes = metadataCriteriaEntityAttributes;
    }

    @Generated
    public void setRequiredNameIdFormat(String requiredNameIdFormat) {
        this.requiredNameIdFormat = requiredNameIdFormat;
    }

    @Generated
    public void setMetadataSignatureLocation(String metadataSignatureLocation) {
        this.metadataSignatureLocation = metadataSignatureLocation;
    }

    @JacksonInject(value="logoutResponseEnabled")
    @Generated
    public void setLogoutResponseEnabled(boolean logoutResponseEnabled) {
        this.logoutResponseEnabled = logoutResponseEnabled;
    }

    @Generated
    public void setLogoutResponseBinding(String logoutResponseBinding) {
        this.logoutResponseBinding = logoutResponseBinding;
    }

    @Generated
    public void setRequireSignedRoot(boolean requireSignedRoot) {
        this.requireSignedRoot = requireSignedRoot;
    }

    @Generated
    public void setSubjectLocality(String subjectLocality) {
        this.subjectLocality = subjectLocality;
    }

    @Generated
    public void setServiceProviderNameIdQualifier(String serviceProviderNameIdQualifier) {
        this.serviceProviderNameIdQualifier = serviceProviderNameIdQualifier;
    }

    @Generated
    public void setNameIdQualifier(String nameIdQualifier) {
        this.nameIdQualifier = nameIdQualifier;
    }

    @Generated
    public void setMetadataExpirationDuration(String metadataExpirationDuration) {
        this.metadataExpirationDuration = metadataExpirationDuration;
    }

    @Generated
    public void setSigningCredentialFingerprint(String signingCredentialFingerprint) {
        this.signingCredentialFingerprint = signingCredentialFingerprint;
    }

    @Generated
    public void setIssuerEntityId(String issuerEntityId) {
        this.issuerEntityId = issuerEntityId;
    }

    @Generated
    public void setSigningKeyAlgorithm(String signingKeyAlgorithm) {
        this.signingKeyAlgorithm = signingKeyAlgorithm;
    }

    @JsonDeserialize(using=TriStateBoolean.Deserializer.class)
    @JacksonInject(value="signAssertions")
    @Generated
    public void setSignAssertions(TriStateBoolean signAssertions) {
        this.signAssertions = signAssertions;
    }

    @JacksonInject(value="signUnsolicitedAuthnRequest")
    @Generated
    public void setSignUnsolicitedAuthnRequest(boolean signUnsolicitedAuthnRequest) {
        this.signUnsolicitedAuthnRequest = signUnsolicitedAuthnRequest;
    }

    @JacksonInject(value="skipGeneratingAssertionNameId")
    @Generated
    public void setSkipGeneratingAssertionNameId(boolean skipGeneratingAssertionNameId) {
        this.skipGeneratingAssertionNameId = skipGeneratingAssertionNameId;
    }

    @JacksonInject(value="skipGeneratingSubjectConfirmationInResponseTo")
    @Generated
    public void setSkipGeneratingSubjectConfirmationInResponseTo(boolean skipGeneratingSubjectConfirmationInResponseTo) {
        this.skipGeneratingSubjectConfirmationInResponseTo = skipGeneratingSubjectConfirmationInResponseTo;
    }

    @JacksonInject(value="isSkipGeneratingResponseInResponseTo")
    @Generated
    public void setSkipGeneratingResponseInResponseTo(boolean isSkipGeneratingResponseInResponseTo) {
        this.isSkipGeneratingResponseInResponseTo = isSkipGeneratingResponseInResponseTo;
    }

    @JacksonInject(value="skipGeneratingSubjectConfirmationNotOnOrAfter")
    @Generated
    public void setSkipGeneratingSubjectConfirmationNotOnOrAfter(boolean skipGeneratingSubjectConfirmationNotOnOrAfter) {
        this.skipGeneratingSubjectConfirmationNotOnOrAfter = skipGeneratingSubjectConfirmationNotOnOrAfter;
    }

    @JacksonInject(value="skipGeneratingSubjectConfirmationRecipient")
    @Generated
    public void setSkipGeneratingSubjectConfirmationRecipient(boolean skipGeneratingSubjectConfirmationRecipient) {
        this.skipGeneratingSubjectConfirmationRecipient = skipGeneratingSubjectConfirmationRecipient;
    }

    @JacksonInject(value="skipGeneratingSubjectConfirmationAddress")
    @Generated
    public void setSkipGeneratingSubjectConfirmationAddress(boolean skipGeneratingSubjectConfirmationAddress) {
        this.skipGeneratingSubjectConfirmationAddress = skipGeneratingSubjectConfirmationAddress;
    }

    @JacksonInject(value="skipGeneratingSubjectConfirmationNotBefore")
    @Generated
    public void setSkipGeneratingSubjectConfirmationNotBefore(boolean skipGeneratingSubjectConfirmationNotBefore) {
        this.skipGeneratingSubjectConfirmationNotBefore = skipGeneratingSubjectConfirmationNotBefore;
    }

    @JacksonInject(value="skipGeneratingSubjectConfirmationNameId")
    @Generated
    public void setSkipGeneratingSubjectConfirmationNameId(boolean skipGeneratingSubjectConfirmationNameId) {
        this.skipGeneratingSubjectConfirmationNameId = skipGeneratingSubjectConfirmationNameId;
    }

    @JacksonInject(value="skipGeneratingNameIdQualifiers")
    @Generated
    public void setSkipGeneratingNameIdQualifiers(boolean skipGeneratingNameIdQualifiers) {
        this.skipGeneratingNameIdQualifiers = skipGeneratingNameIdQualifiers;
    }

    @JacksonInject(value="skipGeneratingTransientNameId")
    @Generated
    public void setSkipGeneratingTransientNameId(boolean skipGeneratingTransientNameId) {
        this.skipGeneratingTransientNameId = skipGeneratingTransientNameId;
    }

    @JacksonInject(value="skipValidatingAuthnRequest")
    @Generated
    public void setSkipValidatingAuthnRequest(boolean skipValidatingAuthnRequest) {
        this.skipValidatingAuthnRequest = skipValidatingAuthnRequest;
    }

    @JacksonInject(value="skipGeneratingServiceProviderNameIdQualifier")
    @Generated
    public void setSkipGeneratingServiceProviderNameIdQualifier(boolean skipGeneratingServiceProviderNameIdQualifier) {
        this.skipGeneratingServiceProviderNameIdQualifier = skipGeneratingServiceProviderNameIdQualifier;
    }

    @JacksonInject(value="skipGeneratingAuthenticatingAuthority")
    @Generated
    public void setSkipGeneratingAuthenticatingAuthority(boolean skipGeneratingAuthenticatingAuthority) {
        this.skipGeneratingAuthenticatingAuthority = skipGeneratingAuthenticatingAuthority;
    }

    @JacksonInject(value="skipGeneratingNameIdQualifier")
    @Generated
    public void setSkipGeneratingNameIdQualifier(boolean skipGeneratingNameIdQualifier) {
        this.skipGeneratingNameIdQualifier = skipGeneratingNameIdQualifier;
    }

    @JacksonInject(value="skipGeneratingSessionNotOnOrAfter")
    @Generated
    public void setSkipGeneratingSessionNotOnOrAfter(boolean skipGeneratingSessionNotOnOrAfter) {
        this.skipGeneratingSessionNotOnOrAfter = skipGeneratingSessionNotOnOrAfter;
    }

    @JsonDeserialize(using=TriStateBoolean.Deserializer.class)
    @JacksonInject(value="signResponses")
    @Generated
    public void setSignResponses(TriStateBoolean signResponses) {
        this.signResponses = signResponses;
    }

    @JsonDeserialize(using=TriStateBoolean.Deserializer.class)
    @JacksonInject(value="signLogoutResponse")
    @Generated
    public void setSignLogoutResponse(TriStateBoolean signLogoutResponse) {
        this.signLogoutResponse = signLogoutResponse;
    }

    @JacksonInject(value="encryptAssertions")
    @Generated
    public void setEncryptAssertions(boolean encryptAssertions) {
        this.encryptAssertions = encryptAssertions;
    }

    @JacksonInject(value="encryptAttributes")
    @Generated
    public void setEncryptAttributes(boolean encryptAttributes) {
        this.encryptAttributes = encryptAttributes;
    }

    @JacksonInject(value="encryptionOptional")
    @Generated
    public void setEncryptionOptional(boolean encryptionOptional) {
        this.encryptionOptional = encryptionOptional;
    }

    @Generated
    public void setMetadataCriteriaRoles(String metadataCriteriaRoles) {
        this.metadataCriteriaRoles = metadataCriteriaRoles;
    }

    @Generated
    public void setMetadataCriteriaRemoveEmptyEntitiesDescriptors(boolean metadataCriteriaRemoveEmptyEntitiesDescriptors) {
        this.metadataCriteriaRemoveEmptyEntitiesDescriptors = metadataCriteriaRemoveEmptyEntitiesDescriptors;
    }

    @Generated
    public void setMetadataCriteriaRemoveRolelessEntityDescriptors(boolean metadataCriteriaRemoveRolelessEntityDescriptors) {
        this.metadataCriteriaRemoveRolelessEntityDescriptors = metadataCriteriaRemoveRolelessEntityDescriptors;
    }

    @Generated
    public void setSigningCredentialType(String signingCredentialType) {
        this.signingCredentialType = signingCredentialType;
    }

    @Generated
    public void setAssertionAudiences(String assertionAudiences) {
        this.assertionAudiences = assertionAudiences;
    }

    @Generated
    public void setSkewAllowance(int skewAllowance) {
        this.skewAllowance = skewAllowance;
    }

    @Generated
    public void setWhiteListBlackListPrecedence(String whiteListBlackListPrecedence) {
        this.whiteListBlackListPrecedence = whiteListBlackListPrecedence;
    }

    @Generated
    public void setAttributeNameFormats(Map<String, String> attributeNameFormats) {
        this.attributeNameFormats = attributeNameFormats;
    }

    @Generated
    public void setAttributeFriendlyNames(Map<String, String> attributeFriendlyNames) {
        this.attributeFriendlyNames = attributeFriendlyNames;
    }

    @Generated
    public void setAttributeValueTypes(Map<String, String> attributeValueTypes) {
        this.attributeValueTypes = attributeValueTypes;
    }

    @Generated
    public void setEncryptableAttributes(Set<String> encryptableAttributes) {
        this.encryptableAttributes = encryptableAttributes;
    }

    @Generated
    public void setSigningSignatureReferenceDigestMethods(List<String> signingSignatureReferenceDigestMethods) {
        this.signingSignatureReferenceDigestMethods = signingSignatureReferenceDigestMethods;
    }

    @Generated
    public void setSigningSignatureAlgorithms(List<String> signingSignatureAlgorithms) {
        this.signingSignatureAlgorithms = signingSignatureAlgorithms;
    }

    @Generated
    public void setSigningSignatureBlackListedAlgorithms(List<String> signingSignatureBlackListedAlgorithms) {
        this.signingSignatureBlackListedAlgorithms = signingSignatureBlackListedAlgorithms;
    }

    @Generated
    public void setSigningSignatureWhiteListedAlgorithms(List<String> signingSignatureWhiteListedAlgorithms) {
        this.signingSignatureWhiteListedAlgorithms = signingSignatureWhiteListedAlgorithms;
    }

    @Generated
    public void setSigningSignatureCanonicalizationAlgorithm(String signingSignatureCanonicalizationAlgorithm) {
        this.signingSignatureCanonicalizationAlgorithm = signingSignatureCanonicalizationAlgorithm;
    }

    @Generated
    public void setEncryptionDataAlgorithms(List<String> encryptionDataAlgorithms) {
        this.encryptionDataAlgorithms = encryptionDataAlgorithms;
    }

    @Generated
    public void setEncryptionKeyAlgorithms(List<String> encryptionKeyAlgorithms) {
        this.encryptionKeyAlgorithms = encryptionKeyAlgorithms;
    }

    @Generated
    public void setEncryptionBlackListedAlgorithms(List<String> encryptionBlackListedAlgorithms) {
        this.encryptionBlackListedAlgorithms = encryptionBlackListedAlgorithms;
    }

    @Generated
    public void setEncryptionWhiteListedAlgorithms(List<String> encryptionWhiteListedAlgorithms) {
        this.encryptionWhiteListedAlgorithms = encryptionWhiteListedAlgorithms;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SamlRegisteredService)) {
            return false;
        }
        SamlRegisteredService other = (SamlRegisteredService)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.metadataMaxValidity != other.metadataMaxValidity) {
            return false;
        }
        if (this.logoutResponseEnabled != other.logoutResponseEnabled) {
            return false;
        }
        if (this.requireSignedRoot != other.requireSignedRoot) {
            return false;
        }
        if (this.signUnsolicitedAuthnRequest != other.signUnsolicitedAuthnRequest) {
            return false;
        }
        if (this.skipGeneratingAssertionNameId != other.skipGeneratingAssertionNameId) {
            return false;
        }
        if (this.skipGeneratingSubjectConfirmationInResponseTo != other.skipGeneratingSubjectConfirmationInResponseTo) {
            return false;
        }
        if (this.isSkipGeneratingResponseInResponseTo != other.isSkipGeneratingResponseInResponseTo) {
            return false;
        }
        if (this.skipGeneratingSubjectConfirmationNotOnOrAfter != other.skipGeneratingSubjectConfirmationNotOnOrAfter) {
            return false;
        }
        if (this.skipGeneratingSubjectConfirmationRecipient != other.skipGeneratingSubjectConfirmationRecipient) {
            return false;
        }
        if (this.skipGeneratingSubjectConfirmationAddress != other.skipGeneratingSubjectConfirmationAddress) {
            return false;
        }
        if (this.skipGeneratingSubjectConfirmationNotBefore != other.skipGeneratingSubjectConfirmationNotBefore) {
            return false;
        }
        if (this.skipGeneratingSubjectConfirmationNameId != other.skipGeneratingSubjectConfirmationNameId) {
            return false;
        }
        if (this.skipGeneratingNameIdQualifiers != other.skipGeneratingNameIdQualifiers) {
            return false;
        }
        if (this.skipGeneratingTransientNameId != other.skipGeneratingTransientNameId) {
            return false;
        }
        if (this.skipValidatingAuthnRequest != other.skipValidatingAuthnRequest) {
            return false;
        }
        if (this.skipGeneratingServiceProviderNameIdQualifier != other.skipGeneratingServiceProviderNameIdQualifier) {
            return false;
        }
        if (this.skipGeneratingAuthenticatingAuthority != other.skipGeneratingAuthenticatingAuthority) {
            return false;
        }
        if (this.skipGeneratingNameIdQualifier != other.skipGeneratingNameIdQualifier) {
            return false;
        }
        if (this.skipGeneratingSessionNotOnOrAfter != other.skipGeneratingSessionNotOnOrAfter) {
            return false;
        }
        if (this.encryptAssertions != other.encryptAssertions) {
            return false;
        }
        if (this.encryptAttributes != other.encryptAttributes) {
            return false;
        }
        if (this.encryptionOptional != other.encryptionOptional) {
            return false;
        }
        if (this.metadataCriteriaRemoveEmptyEntitiesDescriptors != other.metadataCriteriaRemoveEmptyEntitiesDescriptors) {
            return false;
        }
        if (this.metadataCriteriaRemoveRolelessEntityDescriptors != other.metadataCriteriaRemoveRolelessEntityDescriptors) {
            return false;
        }
        if (this.skewAllowance != other.skewAllowance) {
            return false;
        }
        String this$metadataLocation = this.metadataLocation;
        String other$metadataLocation = other.metadataLocation;
        if (this$metadataLocation == null ? other$metadataLocation != null : !this$metadataLocation.equals(other$metadataLocation)) {
            return false;
        }
        String this$idpMetadataLocation = this.idpMetadataLocation;
        String other$idpMetadataLocation = other.idpMetadataLocation;
        if (this$idpMetadataLocation == null ? other$idpMetadataLocation != null : !this$idpMetadataLocation.equals(other$idpMetadataLocation)) {
            return false;
        }
        String this$metadataProxyLocation = this.metadataProxyLocation;
        String other$metadataProxyLocation = other.metadataProxyLocation;
        if (this$metadataProxyLocation == null ? other$metadataProxyLocation != null : !this$metadataProxyLocation.equals(other$metadataProxyLocation)) {
            return false;
        }
        String this$requiredAuthenticationContextClass = this.requiredAuthenticationContextClass;
        String other$requiredAuthenticationContextClass = other.requiredAuthenticationContextClass;
        if (this$requiredAuthenticationContextClass == null ? other$requiredAuthenticationContextClass != null : !this$requiredAuthenticationContextClass.equals(other$requiredAuthenticationContextClass)) {
            return false;
        }
        String this$metadataCriteriaDirection = this.metadataCriteriaDirection;
        String other$metadataCriteriaDirection = other.metadataCriteriaDirection;
        if (this$metadataCriteriaDirection == null ? other$metadataCriteriaDirection != null : !this$metadataCriteriaDirection.equals(other$metadataCriteriaDirection)) {
            return false;
        }
        String this$metadataCriteriaPattern = this.metadataCriteriaPattern;
        String other$metadataCriteriaPattern = other.metadataCriteriaPattern;
        if (this$metadataCriteriaPattern == null ? other$metadataCriteriaPattern != null : !this$metadataCriteriaPattern.equals(other$metadataCriteriaPattern)) {
            return false;
        }
        Map<String, List<String>> this$metadataCriteriaEntityAttributes = this.metadataCriteriaEntityAttributes;
        Map<String, List<String>> other$metadataCriteriaEntityAttributes = other.metadataCriteriaEntityAttributes;
        if (this$metadataCriteriaEntityAttributes == null ? other$metadataCriteriaEntityAttributes != null : !((Object)this$metadataCriteriaEntityAttributes).equals(other$metadataCriteriaEntityAttributes)) {
            return false;
        }
        String this$requiredNameIdFormat = this.requiredNameIdFormat;
        String other$requiredNameIdFormat = other.requiredNameIdFormat;
        if (this$requiredNameIdFormat == null ? other$requiredNameIdFormat != null : !this$requiredNameIdFormat.equals(other$requiredNameIdFormat)) {
            return false;
        }
        String this$metadataSignatureLocation = this.metadataSignatureLocation;
        String other$metadataSignatureLocation = other.metadataSignatureLocation;
        if (this$metadataSignatureLocation == null ? other$metadataSignatureLocation != null : !this$metadataSignatureLocation.equals(other$metadataSignatureLocation)) {
            return false;
        }
        String this$logoutResponseBinding = this.logoutResponseBinding;
        String other$logoutResponseBinding = other.logoutResponseBinding;
        if (this$logoutResponseBinding == null ? other$logoutResponseBinding != null : !this$logoutResponseBinding.equals(other$logoutResponseBinding)) {
            return false;
        }
        String this$subjectLocality = this.subjectLocality;
        String other$subjectLocality = other.subjectLocality;
        if (this$subjectLocality == null ? other$subjectLocality != null : !this$subjectLocality.equals(other$subjectLocality)) {
            return false;
        }
        String this$serviceProviderNameIdQualifier = this.serviceProviderNameIdQualifier;
        String other$serviceProviderNameIdQualifier = other.serviceProviderNameIdQualifier;
        if (this$serviceProviderNameIdQualifier == null ? other$serviceProviderNameIdQualifier != null : !this$serviceProviderNameIdQualifier.equals(other$serviceProviderNameIdQualifier)) {
            return false;
        }
        String this$nameIdQualifier = this.nameIdQualifier;
        String other$nameIdQualifier = other.nameIdQualifier;
        if (this$nameIdQualifier == null ? other$nameIdQualifier != null : !this$nameIdQualifier.equals(other$nameIdQualifier)) {
            return false;
        }
        String this$metadataExpirationDuration = this.metadataExpirationDuration;
        String other$metadataExpirationDuration = other.metadataExpirationDuration;
        if (this$metadataExpirationDuration == null ? other$metadataExpirationDuration != null : !this$metadataExpirationDuration.equals(other$metadataExpirationDuration)) {
            return false;
        }
        String this$signingCredentialFingerprint = this.signingCredentialFingerprint;
        String other$signingCredentialFingerprint = other.signingCredentialFingerprint;
        if (this$signingCredentialFingerprint == null ? other$signingCredentialFingerprint != null : !this$signingCredentialFingerprint.equals(other$signingCredentialFingerprint)) {
            return false;
        }
        String this$issuerEntityId = this.issuerEntityId;
        String other$issuerEntityId = other.issuerEntityId;
        if (this$issuerEntityId == null ? other$issuerEntityId != null : !this$issuerEntityId.equals(other$issuerEntityId)) {
            return false;
        }
        String this$signingKeyAlgorithm = this.signingKeyAlgorithm;
        String other$signingKeyAlgorithm = other.signingKeyAlgorithm;
        if (this$signingKeyAlgorithm == null ? other$signingKeyAlgorithm != null : !this$signingKeyAlgorithm.equals(other$signingKeyAlgorithm)) {
            return false;
        }
        TriStateBoolean this$signAssertions = this.signAssertions;
        TriStateBoolean other$signAssertions = other.signAssertions;
        if (this$signAssertions == null ? other$signAssertions != null : !this$signAssertions.equals(other$signAssertions)) {
            return false;
        }
        TriStateBoolean this$signResponses = this.signResponses;
        TriStateBoolean other$signResponses = other.signResponses;
        if (this$signResponses == null ? other$signResponses != null : !this$signResponses.equals(other$signResponses)) {
            return false;
        }
        TriStateBoolean this$signLogoutResponse = this.signLogoutResponse;
        TriStateBoolean other$signLogoutResponse = other.signLogoutResponse;
        if (this$signLogoutResponse == null ? other$signLogoutResponse != null : !this$signLogoutResponse.equals(other$signLogoutResponse)) {
            return false;
        }
        String this$metadataCriteriaRoles = this.metadataCriteriaRoles;
        String other$metadataCriteriaRoles = other.metadataCriteriaRoles;
        if (this$metadataCriteriaRoles == null ? other$metadataCriteriaRoles != null : !this$metadataCriteriaRoles.equals(other$metadataCriteriaRoles)) {
            return false;
        }
        String this$signingCredentialType = this.signingCredentialType;
        String other$signingCredentialType = other.signingCredentialType;
        if (this$signingCredentialType == null ? other$signingCredentialType != null : !this$signingCredentialType.equals(other$signingCredentialType)) {
            return false;
        }
        String this$assertionAudiences = this.assertionAudiences;
        String other$assertionAudiences = other.assertionAudiences;
        if (this$assertionAudiences == null ? other$assertionAudiences != null : !this$assertionAudiences.equals(other$assertionAudiences)) {
            return false;
        }
        String this$whiteListBlackListPrecedence = this.whiteListBlackListPrecedence;
        String other$whiteListBlackListPrecedence = other.whiteListBlackListPrecedence;
        if (this$whiteListBlackListPrecedence == null ? other$whiteListBlackListPrecedence != null : !this$whiteListBlackListPrecedence.equals(other$whiteListBlackListPrecedence)) {
            return false;
        }
        Map<String, String> this$attributeNameFormats = this.attributeNameFormats;
        Map<String, String> other$attributeNameFormats = other.attributeNameFormats;
        if (this$attributeNameFormats == null ? other$attributeNameFormats != null : !((Object)this$attributeNameFormats).equals(other$attributeNameFormats)) {
            return false;
        }
        Map<String, String> this$attributeFriendlyNames = this.attributeFriendlyNames;
        Map<String, String> other$attributeFriendlyNames = other.attributeFriendlyNames;
        if (this$attributeFriendlyNames == null ? other$attributeFriendlyNames != null : !((Object)this$attributeFriendlyNames).equals(other$attributeFriendlyNames)) {
            return false;
        }
        Map<String, String> this$attributeValueTypes = this.attributeValueTypes;
        Map<String, String> other$attributeValueTypes = other.attributeValueTypes;
        if (this$attributeValueTypes == null ? other$attributeValueTypes != null : !((Object)this$attributeValueTypes).equals(other$attributeValueTypes)) {
            return false;
        }
        Set<String> this$encryptableAttributes = this.encryptableAttributes;
        Set<String> other$encryptableAttributes = other.encryptableAttributes;
        if (this$encryptableAttributes == null ? other$encryptableAttributes != null : !((Object)this$encryptableAttributes).equals(other$encryptableAttributes)) {
            return false;
        }
        List<String> this$signingSignatureReferenceDigestMethods = this.signingSignatureReferenceDigestMethods;
        List<String> other$signingSignatureReferenceDigestMethods = other.signingSignatureReferenceDigestMethods;
        if (this$signingSignatureReferenceDigestMethods == null ? other$signingSignatureReferenceDigestMethods != null : !((Object)this$signingSignatureReferenceDigestMethods).equals(other$signingSignatureReferenceDigestMethods)) {
            return false;
        }
        List<String> this$signingSignatureAlgorithms = this.signingSignatureAlgorithms;
        List<String> other$signingSignatureAlgorithms = other.signingSignatureAlgorithms;
        if (this$signingSignatureAlgorithms == null ? other$signingSignatureAlgorithms != null : !((Object)this$signingSignatureAlgorithms).equals(other$signingSignatureAlgorithms)) {
            return false;
        }
        List<String> this$signingSignatureBlackListedAlgorithms = this.signingSignatureBlackListedAlgorithms;
        List<String> other$signingSignatureBlackListedAlgorithms = other.signingSignatureBlackListedAlgorithms;
        if (this$signingSignatureBlackListedAlgorithms == null ? other$signingSignatureBlackListedAlgorithms != null : !((Object)this$signingSignatureBlackListedAlgorithms).equals(other$signingSignatureBlackListedAlgorithms)) {
            return false;
        }
        List<String> this$signingSignatureWhiteListedAlgorithms = this.signingSignatureWhiteListedAlgorithms;
        List<String> other$signingSignatureWhiteListedAlgorithms = other.signingSignatureWhiteListedAlgorithms;
        if (this$signingSignatureWhiteListedAlgorithms == null ? other$signingSignatureWhiteListedAlgorithms != null : !((Object)this$signingSignatureWhiteListedAlgorithms).equals(other$signingSignatureWhiteListedAlgorithms)) {
            return false;
        }
        String this$signingSignatureCanonicalizationAlgorithm = this.signingSignatureCanonicalizationAlgorithm;
        String other$signingSignatureCanonicalizationAlgorithm = other.signingSignatureCanonicalizationAlgorithm;
        if (this$signingSignatureCanonicalizationAlgorithm == null ? other$signingSignatureCanonicalizationAlgorithm != null : !this$signingSignatureCanonicalizationAlgorithm.equals(other$signingSignatureCanonicalizationAlgorithm)) {
            return false;
        }
        List<String> this$encryptionDataAlgorithms = this.encryptionDataAlgorithms;
        List<String> other$encryptionDataAlgorithms = other.encryptionDataAlgorithms;
        if (this$encryptionDataAlgorithms == null ? other$encryptionDataAlgorithms != null : !((Object)this$encryptionDataAlgorithms).equals(other$encryptionDataAlgorithms)) {
            return false;
        }
        List<String> this$encryptionKeyAlgorithms = this.encryptionKeyAlgorithms;
        List<String> other$encryptionKeyAlgorithms = other.encryptionKeyAlgorithms;
        if (this$encryptionKeyAlgorithms == null ? other$encryptionKeyAlgorithms != null : !((Object)this$encryptionKeyAlgorithms).equals(other$encryptionKeyAlgorithms)) {
            return false;
        }
        List<String> this$encryptionBlackListedAlgorithms = this.encryptionBlackListedAlgorithms;
        List<String> other$encryptionBlackListedAlgorithms = other.encryptionBlackListedAlgorithms;
        if (this$encryptionBlackListedAlgorithms == null ? other$encryptionBlackListedAlgorithms != null : !((Object)this$encryptionBlackListedAlgorithms).equals(other$encryptionBlackListedAlgorithms)) {
            return false;
        }
        List<String> this$encryptionWhiteListedAlgorithms = this.encryptionWhiteListedAlgorithms;
        List<String> other$encryptionWhiteListedAlgorithms = other.encryptionWhiteListedAlgorithms;
        return !(this$encryptionWhiteListedAlgorithms == null ? other$encryptionWhiteListedAlgorithms != null : !((Object)this$encryptionWhiteListedAlgorithms).equals(other$encryptionWhiteListedAlgorithms));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SamlRegisteredService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $metadataMaxValidity = this.metadataMaxValidity;
        result = result * 59 + (int)($metadataMaxValidity >>> 32 ^ $metadataMaxValidity);
        result = result * 59 + (this.logoutResponseEnabled ? 79 : 97);
        result = result * 59 + (this.requireSignedRoot ? 79 : 97);
        result = result * 59 + (this.signUnsolicitedAuthnRequest ? 79 : 97);
        result = result * 59 + (this.skipGeneratingAssertionNameId ? 79 : 97);
        result = result * 59 + (this.skipGeneratingSubjectConfirmationInResponseTo ? 79 : 97);
        result = result * 59 + (this.isSkipGeneratingResponseInResponseTo ? 79 : 97);
        result = result * 59 + (this.skipGeneratingSubjectConfirmationNotOnOrAfter ? 79 : 97);
        result = result * 59 + (this.skipGeneratingSubjectConfirmationRecipient ? 79 : 97);
        result = result * 59 + (this.skipGeneratingSubjectConfirmationAddress ? 79 : 97);
        result = result * 59 + (this.skipGeneratingSubjectConfirmationNotBefore ? 79 : 97);
        result = result * 59 + (this.skipGeneratingSubjectConfirmationNameId ? 79 : 97);
        result = result * 59 + (this.skipGeneratingNameIdQualifiers ? 79 : 97);
        result = result * 59 + (this.skipGeneratingTransientNameId ? 79 : 97);
        result = result * 59 + (this.skipValidatingAuthnRequest ? 79 : 97);
        result = result * 59 + (this.skipGeneratingServiceProviderNameIdQualifier ? 79 : 97);
        result = result * 59 + (this.skipGeneratingAuthenticatingAuthority ? 79 : 97);
        result = result * 59 + (this.skipGeneratingNameIdQualifier ? 79 : 97);
        result = result * 59 + (this.skipGeneratingSessionNotOnOrAfter ? 79 : 97);
        result = result * 59 + (this.encryptAssertions ? 79 : 97);
        result = result * 59 + (this.encryptAttributes ? 79 : 97);
        result = result * 59 + (this.encryptionOptional ? 79 : 97);
        result = result * 59 + (this.metadataCriteriaRemoveEmptyEntitiesDescriptors ? 79 : 97);
        result = result * 59 + (this.metadataCriteriaRemoveRolelessEntityDescriptors ? 79 : 97);
        result = result * 59 + this.skewAllowance;
        String $metadataLocation = this.metadataLocation;
        result = result * 59 + ($metadataLocation == null ? 43 : $metadataLocation.hashCode());
        String $idpMetadataLocation = this.idpMetadataLocation;
        result = result * 59 + ($idpMetadataLocation == null ? 43 : $idpMetadataLocation.hashCode());
        String $metadataProxyLocation = this.metadataProxyLocation;
        result = result * 59 + ($metadataProxyLocation == null ? 43 : $metadataProxyLocation.hashCode());
        String $requiredAuthenticationContextClass = this.requiredAuthenticationContextClass;
        result = result * 59 + ($requiredAuthenticationContextClass == null ? 43 : $requiredAuthenticationContextClass.hashCode());
        String $metadataCriteriaDirection = this.metadataCriteriaDirection;
        result = result * 59 + ($metadataCriteriaDirection == null ? 43 : $metadataCriteriaDirection.hashCode());
        String $metadataCriteriaPattern = this.metadataCriteriaPattern;
        result = result * 59 + ($metadataCriteriaPattern == null ? 43 : $metadataCriteriaPattern.hashCode());
        Map<String, List<String>> $metadataCriteriaEntityAttributes = this.metadataCriteriaEntityAttributes;
        result = result * 59 + ($metadataCriteriaEntityAttributes == null ? 43 : ((Object)$metadataCriteriaEntityAttributes).hashCode());
        String $requiredNameIdFormat = this.requiredNameIdFormat;
        result = result * 59 + ($requiredNameIdFormat == null ? 43 : $requiredNameIdFormat.hashCode());
        String $metadataSignatureLocation = this.metadataSignatureLocation;
        result = result * 59 + ($metadataSignatureLocation == null ? 43 : $metadataSignatureLocation.hashCode());
        String $logoutResponseBinding = this.logoutResponseBinding;
        result = result * 59 + ($logoutResponseBinding == null ? 43 : $logoutResponseBinding.hashCode());
        String $subjectLocality = this.subjectLocality;
        result = result * 59 + ($subjectLocality == null ? 43 : $subjectLocality.hashCode());
        String $serviceProviderNameIdQualifier = this.serviceProviderNameIdQualifier;
        result = result * 59 + ($serviceProviderNameIdQualifier == null ? 43 : $serviceProviderNameIdQualifier.hashCode());
        String $nameIdQualifier = this.nameIdQualifier;
        result = result * 59 + ($nameIdQualifier == null ? 43 : $nameIdQualifier.hashCode());
        String $metadataExpirationDuration = this.metadataExpirationDuration;
        result = result * 59 + ($metadataExpirationDuration == null ? 43 : $metadataExpirationDuration.hashCode());
        String $signingCredentialFingerprint = this.signingCredentialFingerprint;
        result = result * 59 + ($signingCredentialFingerprint == null ? 43 : $signingCredentialFingerprint.hashCode());
        String $issuerEntityId = this.issuerEntityId;
        result = result * 59 + ($issuerEntityId == null ? 43 : $issuerEntityId.hashCode());
        String $signingKeyAlgorithm = this.signingKeyAlgorithm;
        result = result * 59 + ($signingKeyAlgorithm == null ? 43 : $signingKeyAlgorithm.hashCode());
        TriStateBoolean $signAssertions = this.signAssertions;
        result = result * 59 + ($signAssertions == null ? 43 : $signAssertions.hashCode());
        TriStateBoolean $signResponses = this.signResponses;
        result = result * 59 + ($signResponses == null ? 43 : $signResponses.hashCode());
        TriStateBoolean $signLogoutResponse = this.signLogoutResponse;
        result = result * 59 + ($signLogoutResponse == null ? 43 : $signLogoutResponse.hashCode());
        String $metadataCriteriaRoles = this.metadataCriteriaRoles;
        result = result * 59 + ($metadataCriteriaRoles == null ? 43 : $metadataCriteriaRoles.hashCode());
        String $signingCredentialType = this.signingCredentialType;
        result = result * 59 + ($signingCredentialType == null ? 43 : $signingCredentialType.hashCode());
        String $assertionAudiences = this.assertionAudiences;
        result = result * 59 + ($assertionAudiences == null ? 43 : $assertionAudiences.hashCode());
        String $whiteListBlackListPrecedence = this.whiteListBlackListPrecedence;
        result = result * 59 + ($whiteListBlackListPrecedence == null ? 43 : $whiteListBlackListPrecedence.hashCode());
        Map<String, String> $attributeNameFormats = this.attributeNameFormats;
        result = result * 59 + ($attributeNameFormats == null ? 43 : ((Object)$attributeNameFormats).hashCode());
        Map<String, String> $attributeFriendlyNames = this.attributeFriendlyNames;
        result = result * 59 + ($attributeFriendlyNames == null ? 43 : ((Object)$attributeFriendlyNames).hashCode());
        Map<String, String> $attributeValueTypes = this.attributeValueTypes;
        result = result * 59 + ($attributeValueTypes == null ? 43 : ((Object)$attributeValueTypes).hashCode());
        Set<String> $encryptableAttributes = this.encryptableAttributes;
        result = result * 59 + ($encryptableAttributes == null ? 43 : ((Object)$encryptableAttributes).hashCode());
        List<String> $signingSignatureReferenceDigestMethods = this.signingSignatureReferenceDigestMethods;
        result = result * 59 + ($signingSignatureReferenceDigestMethods == null ? 43 : ((Object)$signingSignatureReferenceDigestMethods).hashCode());
        List<String> $signingSignatureAlgorithms = this.signingSignatureAlgorithms;
        result = result * 59 + ($signingSignatureAlgorithms == null ? 43 : ((Object)$signingSignatureAlgorithms).hashCode());
        List<String> $signingSignatureBlackListedAlgorithms = this.signingSignatureBlackListedAlgorithms;
        result = result * 59 + ($signingSignatureBlackListedAlgorithms == null ? 43 : ((Object)$signingSignatureBlackListedAlgorithms).hashCode());
        List<String> $signingSignatureWhiteListedAlgorithms = this.signingSignatureWhiteListedAlgorithms;
        result = result * 59 + ($signingSignatureWhiteListedAlgorithms == null ? 43 : ((Object)$signingSignatureWhiteListedAlgorithms).hashCode());
        String $signingSignatureCanonicalizationAlgorithm = this.signingSignatureCanonicalizationAlgorithm;
        result = result * 59 + ($signingSignatureCanonicalizationAlgorithm == null ? 43 : $signingSignatureCanonicalizationAlgorithm.hashCode());
        List<String> $encryptionDataAlgorithms = this.encryptionDataAlgorithms;
        result = result * 59 + ($encryptionDataAlgorithms == null ? 43 : ((Object)$encryptionDataAlgorithms).hashCode());
        List<String> $encryptionKeyAlgorithms = this.encryptionKeyAlgorithms;
        result = result * 59 + ($encryptionKeyAlgorithms == null ? 43 : ((Object)$encryptionKeyAlgorithms).hashCode());
        List<String> $encryptionBlackListedAlgorithms = this.encryptionBlackListedAlgorithms;
        result = result * 59 + ($encryptionBlackListedAlgorithms == null ? 43 : ((Object)$encryptionBlackListedAlgorithms).hashCode());
        List<String> $encryptionWhiteListedAlgorithms = this.encryptionWhiteListedAlgorithms;
        result = result * 59 + ($encryptionWhiteListedAlgorithms == null ? 43 : ((Object)$encryptionWhiteListedAlgorithms).hashCode());
        return result;
    }

    @Generated
    public SamlRegisteredService() {
    }
}

