/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.ArrayList;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractMultifactorAuthenticationAction<T extends MultifactorAuthenticationProvider>
extends BaseCasWebflowAction {
    protected T provider;

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        String providerId = MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationProvider(requestContext);
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        this.provider = (MultifactorAuthenticationProvider)MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)providerId, (ApplicationContext)applicationContext).orElseThrow(() -> new AuthenticationException("Unable to determine multifactor authentication provider for " + providerId));
        Assert.isTrue((boolean)providerId.equalsIgnoreCase(this.provider.getId()), (String)"Requested provider id %s does not match the available provider id %s".formatted(providerId, this.provider.getId()));
        return super.doPreExecute(requestContext);
    }

    protected Principal resolvePrincipal(Principal principal, RequestContext requestContext) {
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)requestContext.getActiveFlow().getApplicationContext()).getBeanFactory();
        ArrayList resolvers = new ArrayList(BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, MultifactorAuthenticationPrincipalResolver.class).values());
        AnnotationAwareOrderComparator.sort(resolvers);
        return resolvers.stream().filter(BeanSupplier::isNotProxy).filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElseThrow(() -> new IllegalStateException("Unable to resolve principal for multifactor authentication"));
    }

    protected String getThrottledRequestKeyFor(Authentication authentication, RequestContext requestContext) {
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        return principal.getId();
    }
}

